package com.xunlei.niux.manager.web.model;

import com.xunlei.common.util.FunRef;
import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import com.xunlei.niux.data.bonus.bo.UserBonusBo;
import com.xunlei.niux.data.bonus.facade.FacadeFactory;
import com.xunlei.niux.data.bonus.facade.IFacade;
import com.xunlei.niux.data.bonus.vo.UserBonus;
import java.util.ArrayList;
import java.util.List;

@FunRef("bonus")
public class BonusManagedBean extends BaseManagedBean
{
    public String getQueryUserBonusList()
    {
        authenticateRun();
        UserBonus userBonus = (UserBonus)findBean(UserBonus.class, "userbonus");
        UserBonus bonus = FacadeFactory.INSTANCE.getUserBonusBo().find(userBonus.getUserId());
        List list = new ArrayList();
        if (bonus != null) {
            list.add(bonus);
        }
        Sheet sheet = new Sheet(list.size(), list);
        PagedFliper pagedFliper = getFliper();
        mergePagedDataModel(sheet, new PagedFliper[] { pagedFliper });
        return "";
    }
    public String freeze() {
        authenticateEdit();
        UserBonus userBonus = (UserBonus)findBean(UserBonus.class, "userbonus");
        try {
            FacadeFactory.INSTANCE.getUserBonusBo().update_freeze(userBonus.getUserId());
        } catch (Exception e) {
            alertJS("冻结失败，原因：" + e.getMessage());
        }
        return "";
    }
    public String unfreeze() {
        authenticateEdit();
        UserBonus userBonus = (UserBonus)findBean(UserBonus.class, "userbonus");
        try {
            FacadeFactory.INSTANCE.getUserBonusBo().update_unfreeze(userBonus.getUserId());
        } catch (Exception e) {
            alertJS("解冻失败，原因：" + e.getMessage());
        }
        return "";
    }
}