package com.xunlei.niux.manager.web.model;

import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import com.ferret.common.dao.enums.OrderType;
import com.ferret.common.dao.vo.Page;
import com.xunlei.common.util.FunRef;
import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import com.xunlei.common.util.XLRuntimeException;
import com.xunlei.niux.data.vipgame.bo.AutoCountBo;
import com.xunlei.niux.data.vipgame.bo.BonusProductBo;
import com.xunlei.niux.data.vipgame.facade.FacadeFactory;
import com.xunlei.niux.data.vipgame.vo.AutoCount;
import com.xunlei.niux.data.vipgame.vo.BonusProduct;
import com.xunlei.niux.manager.web.util.NiUxFunctionConstant;

/**
 * 自动发放奖品总数量业务处理类
 * @author lisu
 *  2013-04-26
 */
@FunRef(NiUxFunctionConstant.NIUX_FUNCTION_AUTOPRODUCT)
public class AutoCountManagedBean extends BaseManagedBean {
	private static final Logger logger = Logger.getLogger(AutoCountManagedBean.class.getName());
	private AutoCountBo autoCountBo;
	private BonusProductBo bonusProductBo;
	private int rownum = 0;
	
	
	public AutoCountManagedBean(){
		autoCountBo = FacadeFactory.INSTANCE.getAutoCountBo();
		bonusProductBo = FacadeFactory.INSTANCE.getBonusProductBo();
		//初始化行号
		int pageNo=this.getFliper().getPageNo();
		int pageSize=this.getFliper().getPageSize();
		rownum=rownum+(pageNo-1)*pageSize+1;
	}
	

	public int getRownum() {
		return rownum++;
	}

	public void setRownum(int rownum) {
		this.rownum = rownum;
	}
	/**
	 * 查询自动发放奖品总数量 
	 * @return
	 */
	public String getQueryAutoCountList(){
		logger.info("开始自动发放奖品总数量查询");
        this.authenticateRun();//验证运行权限
        AutoCount product = findBean(AutoCount.class, "autocount");
        PagedFliper pagedFliper = this.getFliper();
        int count = autoCountBo.count(product);
        pagedFliper.setRecordCount(count);
        List<AutoCount> list = new ArrayList<AutoCount>();
        if (count > 0) {
        	rownum = 1;
        	Page page=new Page();
        	page.setPageNo(pagedFliper.getPageNo());
        	page.setPageSize(pagedFliper.getPageSize());
        	page.addOrder("productNo", OrderType.DESC);
            list = autoCountBo.findAutoCount(product, page);
        }
        Sheet<AutoCount> sheet = new Sheet<AutoCount>(count, list);
        this.mergePagedDataModel(sheet, pagedFliper);
        return "";
	}
	
	/**
	 * 新增自动发放奖品总数量
	 * @return
	 */
	public String add(){
		logger.info("开始自动发放奖品总数量添加");		
		AutoCount product = this.findBean(AutoCount.class,"autocount");	
		try{
			if(product==null){
				logger.info("自动发放奖品总数量为空");
				throw new XLRuntimeException("自动发放奖品总数量为空");
			}		
			BonusProduct bp = new BonusProduct();
			bp.setProductNo(product.getProductNo().trim());
			List<BonusProduct> bplist = bonusProductBo.find(bp, 0, 0);
			if(bplist == null || bplist.size()==0){
				logger.info("您输入的奖品编号:"+product.getProductNo()+" 在系统中不存在");
				throw new XLRuntimeException("您输入的奖品编号:"+product.getProductNo()+" 在系统中不存在");
			}
			AutoCount autoCount = new AutoCount();
			autoCount.setProductNo(product.getProductNo());
			List<AutoCount> aclist = autoCountBo.findAutoCount(autoCount,new Page());
			if(aclist != null && aclist.size()>0){
				logger.info("已添加过编号:"+product.getProductNo()+"的相关记录，不能重复添加");
				throw new XLRuntimeException("已添加过编号:"+product.getProductNo()+"的相关记录，不能重复添加");
			}
			autoCountBo.insert(product);
		}catch(Exception e){
			logger.error("添加失败", e);
			mergeJsmessage("添加失败，原因：" + e.getMessage());
		}
		return "";
	}
	
	/**
	 * 修改自动发放奖品总数量
	 * @return
	 */
	public String edit(){
		logger.info("开始自动发放奖品总数量修改");
		this.authenticateEdit();//编辑权限
		AutoCount product =this.findBean(AutoCount.class,"autocount");
		try{
			if(product==null){
				logger.info("自动发放奖品总数量为空");
				throw new XLRuntimeException("自动发放奖品总数量为空");
			}	
			BonusProduct bp = new BonusProduct();
			bp.setProductNo(product.getProductNo().trim());
			List<BonusProduct> bplist = bonusProductBo.find(bp, 0, 0);
			if(bplist == null || bplist.size()==0){
				logger.info("您输入的奖品编号:"+product.getProductNo()+" 在奖品列表中不存在");
				throw new XLRuntimeException("您输入的奖品编号:"+product.getProductNo()+" 在奖品列表中不存在");
			}
			autoCountBo.update(product);		
		}catch(Exception e){
			logger.error("修改失败", e);
			mergeJsmessage("修改失败，原因：" + e.getMessage());
		}
		return "";
	}
	
	/**
	 * 删除自动发放奖品总数量
	 * @return
	 */
	public String delete(){	
		logger.info("开始自动发放奖品信息总数量");
		this.authenticateDel();//删除权限
		String delseqids = findParameter("delseqids");		
		try{
			String ids[] = delseqids.split(",");
			for(String id:ids)
				autoCountBo.delete(new Long(id));			
		}catch(Exception e){
			logger.error("删除失败", e);
			mergeJsmessage("删除失败，原因：" + e.getMessage());
		}
		return "";
	}
}
