package com.xunlei.niux.manager.web.model;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.faces.model.SelectItem;

import com.ferret.common.dao.vo.Page;
import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import com.xunlei.common.vo.UserInfo;
import com.xunlei.niux.data.vipgame.facade.FacadeFactory;
import com.xunlei.niux.data.vipgame.vo.bonus.AuctionProduct;
import com.xunlei.niux.data.vipgame.vo.bonus.BaseProduct;
import com.xunlei.niux.manager.web.util.PageUtil;
import com.xunlei.niux.manager.web.util.PicUtil;

/**
 * 竞拍产品
 * @author Administrator
 *
 */
public class AuctionProductManagedBean extends BaseManagedBean{
	private static final SimpleDateFormat sdf=new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
	private BaseProduct baseProduct;//基础框架
	public BaseProduct refreshBaseProduct(){
		BaseProduct selectedBaseProduct=findBean(BaseProduct.class, "selectedbaseproduct");
		long baseProductId=findParamLong("baseProductId");
		baseProduct=FacadeFactory.INSTANCE.getBaseProductBo().findOne(baseProductId);
		selectedBaseProduct.setBaseProductId(baseProduct.getBaseProductId());
		selectedBaseProduct.setIsFixedBaseUnitNum(baseProduct.getIsFixedBaseUnitNum());
		selectedBaseProduct.setProductUnit(baseProduct.getProductUnit());
		selectedBaseProduct.setBaseUnitNum(baseProduct.getBaseUnitNum());
		return baseProduct;
	}
	public List<SelectItem> getAllAuctionProductSiList(){
		AuctionProduct query=new AuctionProduct();
		Page page=new Page();
		List<AuctionProduct> apList=FacadeFactory.INSTANCE.getAuctionProductBo().finds(query, page);
		List<SelectItem> siList=new ArrayList<SelectItem>();
		for(AuctionProduct ap:apList){
			SelectItem si=new SelectItem(ap.getAuctionProductId(), ap.getProductName());
			siList.add(si);
		}
		return siList;
	}
	public Map<Long,String> getAllAuctionProuctMap(){
		Map<Long,String> map=new HashMap<Long,String>();
		AuctionProduct query=new AuctionProduct();
		Page page=new Page();
		List<AuctionProduct> apList=FacadeFactory.INSTANCE.getAuctionProductBo().finds(query, page);
		for(AuctionProduct ap:apList){
			map.put(ap.getAuctionProductId(), ap.getProductName());
		}
		return map;
	}
	public BaseProduct getBaseProduct() {
		return baseProduct;
	}
	public void setBaseProduct(BaseProduct baseProduct) {
		this.baseProduct = baseProduct;
	}
	
	public String getQueryauctionproductList(){
		 this.authenticateRun();//验证运行权限
		 AuctionProduct query=findBean(AuctionProduct.class, "auctionproduct");
		 String auctionProuctIdStr=findParameter("auctionProductId");
		 if(query.getAuctionProductId()!=null&&query.getAuctionProductId()==0){
			 query.setAuctionProductId(null);
		 }
		 if(auctionProuctIdStr!=null&&!"".equals(auctionProuctIdStr)){
			 query.setAuctionProductId(Long.valueOf(auctionProuctIdStr));
		 }
		 //根据竞拍状态设置竞拍时间
		 String status=query.getAuctionStatus();
		 if("0".equals(status)){
			 query.setFromStartAuctionTime(sdf.format(new Date()));
			 query.setToStartAuctionTime("");
			 query.setFromEndAuctionTime("");
			 query.setToEndAuctionTime("");
		 }else if("1".equals(status)){
			 query.setFromStartAuctionTime("");
			 query.setToStartAuctionTime(sdf.format(new Date()));
			 query.setFromEndAuctionTime(sdf.format(new Date()));
			 query.setToEndAuctionTime("");
		 }else if("2".equals(status)){
			 query.setFromStartAuctionTime("");
			 query.setToStartAuctionTime("");
			 query.setFromEndAuctionTime("");
			 query.setToEndAuctionTime(sdf.format(new Date()));
		 }
		 query.setAuctionStatus("");
		 
		 PagedFliper pagedFliper = this.getFliper();
		 int count =FacadeFactory.INSTANCE.getAuctionProductBo().count(query);
		 List<AuctionProduct> arList=new ArrayList<AuctionProduct>();
		 if(count>0){
			 Page page=PageUtil.formatPage(pagedFliper, "auctionProductId","desc");
			 arList=FacadeFactory.INSTANCE.getAuctionProductBo().finds(query, page);
		 }
		 for(AuctionProduct ap:arList){
			 ap.setAuctionStatus(String.valueOf(auctionProductStatus(ap)));
		 }
		 query.setAuctionStatus(status);
		 Sheet<AuctionProduct> sheet = new Sheet<AuctionProduct>(count, arList);
	     this.mergePagedDataModel(sheet, pagedFliper);
		 return "";
	}
	public String add(){
		this.authenticateAdd();//添加权限
		AuctionProduct auctionProduct=findBean(AuctionProduct.class, "auctionproduct");
		UserInfo user=this.currentUserInfo();
		auctionProduct.setInputBy(user.getTrueName());
		auctionProduct.setInputTime(sdf.format(new Date()));
		try{
			auctionProduct.setDetailedDesc(PicUtil.replacePicUrlAndSyn(auctionProduct.getDetailedDesc()));
			FacadeFactory.INSTANCE.getAuctionProductBo().insert(auctionProduct);
		}catch(Exception e){
			logger.error("添加失败", e);
			mergeJsmessage("添加失败，原因：" + e.getMessage());
		}
		return "";
	}
	public String editsomedata(){
		this.authenticateEdit();
		AuctionProduct auctionProduct=findBean(AuctionProduct.class, "auctionproduct");
		UserInfo user=this.currentUserInfo();
		auctionProduct.setEditBy(user.getTrueName());
		auctionProduct.setEditTime(sdf.format(new Date()));
		try{
			auctionProduct.setDetailedDesc(PicUtil.replacePicUrlAndSyn(auctionProduct.getDetailedDesc()));
			FacadeFactory.INSTANCE.getAuctionProductBo().updateSomeInfo(auctionProduct);
		}catch(Exception e){
			logger.error("编辑失败", e);
			mergeJsmessage("编辑失败，原因：" + e.getMessage());
		}
		return "";
	}
	public List<SelectItem> getProductTypeList(){
		List<SelectItem> slList=new ArrayList<SelectItem>();
		List<BaseProduct> bpList=FacadeFactory.INSTANCE.getBaseProductBo().finds(new BaseProduct(), new Page());
		for(BaseProduct bp:bpList){
			SelectItem si=new SelectItem(bp.getBaseProductId(), bp.getProductTypeName());
			slList.add(si);
		}
		return slList;
	}
	/**
	 * 判断竞拍状态；0：未开拍；1：竞拍中；2：已结束
	 * @param auctionProduct
	 * @return
	 */
	private static int auctionProductStatus(AuctionProduct auctionProduct){
		String nowStr=sdf.format(new Date());
		if(auctionProduct.getStartAuctionTime().compareTo(nowStr)>0){
			return 0;
		}
		if(auctionProduct.getEndAuctionTime().compareTo(nowStr)>0){
			return 1;
		}
		return 2;
	}
	public String updateDisplayInfo(){
		int displaySort=findParamInt("displaySort");
		String isDisplay=findParameter("isDisplay");
		long auctionProductId=findParamLong("auctionProductId2");
		AuctionProduct auctionProduct=FacadeFactory.INSTANCE.getAuctionProductBo().findOne(auctionProductId);
		auctionProduct.setDisplaySort(displaySort);
		auctionProduct.setIsDisplay("true".equals(isDisplay));
		FacadeFactory.INSTANCE.getAuctionProductBo().updateSomeInfo(auctionProduct);
		return "";
	}
	public String delete() {
	       this.authenticateDel();
	       String paramseqids = findParameter("delseqids");
	       String[] params = paramseqids.split(",");
           for(String id : params) {
        	   try{
        		   FacadeFactory.INSTANCE.getAuctionProductBo().delete(Long.valueOf(id));
        	   }catch(Exception e){
        		   logger.error("竞拍产品"+id+"删除失败", e);   
        	   }
           }
	       return "";
	   }
}
