package com.xunlei.niux.manager.web.model;

import java.util.ArrayList;
import java.util.List;

import org.apache.log4j.Logger;

import com.xunlei.common.util.FunRef;
import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import com.xunlei.niux.manager.web.model.vo.AccountChange;
import com.xunlei.niux.manager.web.util.HttpClientUtil;
import com.xunlei.niux.manager.web.util.NiUxFunctionConstant;

@FunRef(NiUxFunctionConstant.NIUX_FUNCTION_ACCOUNTCHANGE)
public class AccountChangeManagedBean extends BaseManagedBean {
	private static final Logger logger=Logger.getLogger(AccountChangeManagedBean.class.getName());
	String accountChangeUrl="http://websvr.niu.xunlei.com/queryUserInfo.gameUserInfo?";//gameid=000069&type=200&accounts=lijunfuangguang,wfgfcmwfg"
	public String getQueryAccountChangeList(){
		this.authenticateRun();
		AccountChange ac=this.findBean(AccountChange.class,"accountchange");
		String params="gameid="+ac.getGameid()+"&type="+ac.getType()+"&accounts="+ac.getBeforeaccount().replace(" ", ",");
		logger.info("url:"+accountChangeUrl+params);
		String resp=HttpClientUtil.get(accountChangeUrl+params);
		logger.info("result:"+resp);
		List<AccountChange> list=new ArrayList<AccountChange>();
		PagedFliper pagedFliper = this.getFliper();
		if(resp.contains("\"statues\":\"0\"")){
			resp=resp.replaceAll("\\{\"result\":\"", "");
			resp=resp.replaceAll("\",\"statues\":\"0\"\\}", "");
			resp=resp.replaceAll("\",\"statues\":\"1\"\\}", "");
			String[] a1=resp.split("&");
			long i=0;
			for(String s:a1){
				if(a1==null||"".equals(a1)){
					continue;
				}
				String[] a2=s.split("=");
				AccountChange accountchange=new AccountChange();
				accountchange.setType(ac.getType());
				accountchange.setGameid(ac.getGameid());
				accountchange.setBeforeaccount(a2[0]);
				accountchange.setSeqid(i++);
				if(a2.length>1){
					accountchange.setAfteraccount("null".equals(a2[1])?"":a2[1]);
				}
				list.add(accountchange);
			}
		}
		Sheet<AccountChange> sheet=new Sheet<AccountChange>(list.size(),list);
		this.mergePagedDataModel(sheet, pagedFliper);
		return "";
	}
}
