package com.xunlei.niux.manager.web.client;

import com.google.gson.*;
import com.xunlei.niux.client.util.HttpClientUtil;
import com.xunlei.niux.data.vipgame.dto.game.CpsGamesDTO;
import com.xunlei.niux.data.vipgame.enums.game.CPSGameSouceType;
import com.xunlei.niux.data.vipgame.vo.CpsGames;
import com.xunlei.niux.easyutils.commonutils.NumParseUtil;
import com.xunlei.niux.easyutils.commonutils.PinYinUtil;
import com.xunlei.util.Log;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;

import java.util.ArrayList;
import java.util.List;

/**
 * Created with IntelliJ IDEA.
 * User: admin
 * Date: 15-4-8
 * Time: 上午11:32
 * To change this template use File | Settings | File Templates.
 */
public class XiaoMiMobileGameLeadInClient {
    private static final Logger logger = Log.getLogger(XiaoMiMobileGameLeadInClient.class);

    private final static String XIAOMIGAMEURL = "http://app.migc.xiaomi.com/cms/interface/v5/subjectgamelist2.php?subId=508&pageSize=50&page=";
    private final static String downloadUrl = "http://game.xiaomi.com/wap/index.php?c=app&v=download&channel=meng_1098_1_android&uid=%s&t=%s&app_id=";

    public List<CpsGamesDTO> getXiaomiCPSGames(){
        try {
            List<CpsGamesDTO> allCpsGames = new ArrayList<CpsGamesDTO>();
            int size;
            int index = 1;
            do{
                String resp = HttpClientUtil.get(XIAOMIGAMEURL+index);
                List<CpsGamesDTO> cpsGames = parseXiaomiMobileGames(resp);
                size = cpsGames.size();
                index++;
                allCpsGames.addAll(cpsGames);
            }while (size >= 50);
            return allCpsGames;
        } catch (Exception e) {
            logger.error("getXiaomiCPSGames Exception", e);
        }
        return null;
    }

    private List<CpsGamesDTO> parseXiaomiMobileGames(String parseStr){
        List<CpsGamesDTO> cpsGamesList = new ArrayList<CpsGamesDTO>();

        if(StringUtils.isEmpty(parseStr)){
            return cpsGamesList;
        }

        JsonObject mobileGameObject = new JsonParser().parse(parseStr).getAsJsonObject();
        if(mobileGameObject == null)
            return cpsGamesList;
        JsonArray gameArray = mobileGameObject.getAsJsonArray("gameList");
        if(gameArray.size() <= 0){
            return cpsGamesList;
        }

        for(int i=0;i<gameArray.size();i++){
            JsonObject gameJson = gameArray.get(i).getAsJsonObject();
            CpsGamesDTO cpsGames = new CpsGamesDTO();
            String gameName = gameJson.get("displayName").getAsString();
            String gameDesc = gameJson.get("introduction").getAsString();
            if(gameDesc.length() >255){
                gameDesc = gameDesc.substring(0,254);
            }
            String appSize = gameJson.get("apkSize").getAsString();
            long downloadCount = gameJson.get("downloadCount").getAsLong();
            String iconUrl = gameJson.get("icon").getAsString();
            int xiaomiGameId = gameJson.get("gameId").getAsInt();
            String packageName = gameJson.get("packageName").getAsString();
            String summary = gameJson.get("summary").getAsString();

            List<String> screenShotPicList = new ArrayList<String>();
            JsonArray screenShotArray = gameJson.get("screenShot").getAsJsonArray();
            if(screenShotArray != null){
                screenShotPicList = getScreenShotPicList(screenShotArray);
            }

            cpsGames.setGameName(gameName);
            String simpleName = PinYinUtil.getFirstSpell(gameName, 10);
            cpsGames.setGameNo("mi_"+simpleName);
            cpsGames.setSimpleName(simpleName);
            cpsGames.setGameDesc(gameDesc);
            cpsGames.setIconUrl(iconUrl);
            cpsGames.setDownLoadUrl(downloadUrl + String.valueOf(xiaomiGameId));
            cpsGames.setCpsSize(NumParseUtil.getAppSizeStr(appSize));
            cpsGames.setDownloadNum((int) downloadCount);
            cpsGames.setSourceType(CPSGameSouceType._XIAOMI);
            cpsGames.setPackageName(packageName);
            cpsGames.setXiaomiappId(xiaomiGameId);
            cpsGames.setSummary(summary);
            cpsGames.setPicList(screenShotPicList);

            cpsGamesList.add(cpsGames);
        }

        return cpsGamesList;
    }

    private List<String> getScreenShotPicList(JsonArray screenShotArray){
        List<String> resultList = new ArrayList<String>();
        if(screenShotArray == null){
            return resultList;
        }

        for(int i=0;i<screenShotArray.size();i++){
            if(resultList.size() >=5){//at most 5 pics
                break;
            }
            JsonObject screenShotObj = screenShotArray.get(i).getAsJsonObject();
            if(screenShotObj == null){
                continue;
            }
            int screenShotType = screenShotObj.get("screenType").getAsInt();
            if(screenShotType == 1){//pic type
                String screenShotpicUrl = screenShotObj.get("url").getAsString();
                resultList.add(screenShotpicUrl);
            }
        }

        return resultList;
    }

    public static void main(String[] args){
        List<CpsGamesDTO> list = new XiaoMiMobileGameLeadInClient().getXiaomiCPSGames();
        System.out.println(list.size());
    }
}
