package com.xunlei.niux.manager.web.cache;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

/**
 * Created with IntelliJ IDEA.
 * User: jia
 * Date: 13-9-26
 * Time: 下午7:21
 * To change this template use File | Settings | File Templates.
 */
public class SimpleMemCache implements Cache{
    private ConcurrentMap<String,Object> cache = new ConcurrentHashMap<String, Object>();

    @Override
    public void add(String key, Object obj) {
        cache.putIfAbsent(key,obj);
    }

    @Override
    public Object get(String key) {
        return cache.get(key);
    }

    @Override
    public void move(String key) {
        cache.remove(key);
    }

    @Override
    public String generateKey(Class clazz, String name) {
        return clazz.getSimpleName()+name;
    }
}
