package com.xunlei.niux.manager.web.cache;

import com.ferret.common.dao.vo.Page;
import com.xunlei.niux.data.lychat.facade.FacadeFactory;
import com.xunlei.niux.data.lychat.vo.LyChatGameVO;
import com.xunlei.niux.data.lychat.vo.LyChatSensitiveVO;

import java.util.*;

public class LyChatCache {
	private static LyChatCache instance;

	private Set<String> sensitiveSet = new HashSet<String>();
    private String sensitiveWithSplit;

    private Map<String, LyChatGameVO> lyChatGameMap = new HashMap<String, LyChatGameVO>();

	private LyChatCache(){
		updateSensitiveCache();//更新缓存
        updateLyChatGameCache();
	}

	public synchronized static LyChatCache getInstance(){
            if(instance==null){
                instance=new LyChatCache();
            }
		return instance;
	}

    private void loadAllSensitive(){
        List<LyChatSensitiveVO> list = FacadeFactory.INSTANCE.getBaseSo().findObjects(new LyChatSensitiveVO(), new Page());
        for(LyChatSensitiveVO lcs:list){
            sensitiveSet.add(lcs.getKeyWord());
        }
    }

    private void loadLychatGame(){
        LyChatGameVO query = new LyChatGameVO();
        query.setIsWorking(1);
        List<LyChatGameVO> list = FacadeFactory.INSTANCE.getBaseSo().findObjects(query,new Page());
        for(LyChatGameVO lcg:list){
            if(!lyChatGameMap.containsKey(lcg.getGameId())){
                lyChatGameMap.put(lcg.getGameId(),lcg);
            }
        }
    }

    private void loadSensitiveWithSplit(){
        StringBuilder sb = new StringBuilder();
        for(String keyWord:sensitiveSet){
            sb.append(keyWord).append("|");
        }
        String tmp = sb.toString();
        sensitiveWithSplit = tmp.substring(0, tmp.length()-1);
    }

    public synchronized void updateSensitiveCache(){
        sensitiveSet.clear();
        loadAllSensitive();
        loadSensitiveWithSplit();
    }

    public synchronized void updateLyChatGameCache(){
        lyChatGameMap.clear();
        loadLychatGame();
    }

    public Set<String> getSensitiveSet() {
        return sensitiveSet;
    }

    public String getSensitiveWithSplit() {
        return sensitiveWithSplit;
    }

    public Map<String, LyChatGameVO> getLyChatGameMap() {
        return lyChatGameMap;
    }
}
