package com.xunlei.niux.manager.web.cache;

import com.ferret.common.dao.vo.Page;
import com.xunlei.niux.data.giftcenter.facade.FacadeFactory;
import com.xunlei.niux.data.giftcenter.vo.PackageGames;
import com.xunlei.niux.data.giftcenter.vo.PackageManufacturer;
import com.xunlei.niux.data.giftcenter.vo.PackagePlatforms;
import org.apache.log4j.Logger;

import javax.faces.model.SelectItem;
import java.util.*;

/**
 * 游戏信息缓存
 * @author Administrator
 *
 */
public class GiftCenterCache {
	private static GiftCenterCache instance;
	private static Object lock=new Object();
    private static final Logger logger = Logger.getLogger(GiftCenterCache.class.getName());

	private Map<Long,String> platformsMap =new HashMap<Long,String>();//平台序号对应平台
	private Map<Long,String> gamesMap =new HashMap<Long,String>();//游戏序号对应游戏
	private Map<Long,String> webGamesMap =new HashMap<Long,String>();//页游游戏序号对应游戏
	private Map<Long,String> mobileGamesMap =new HashMap<Long,String>();//手游游戏序号对应游戏

    private Map<Long,String> manufactorerMap = new HashMap<Long, String>();//厂商申请、页游开服、手游开测、页游开测对应厂商

    private List<SelectItem> platformsSelectItemList =new ArrayList<SelectItem>();
    private List<SelectItem> gamesSelectItemList =new ArrayList<SelectItem>();
    private List<SelectItem> webGamesSelectItemList =new ArrayList<SelectItem>();
    private List<SelectItem> mobileGamesSelectItemList =new ArrayList<SelectItem>();
    private List<SelectItem> manufactorerSelectItemList = new ArrayList<SelectItem>();

    private static Date recordTime = null;



	private GiftCenterCache(){
        updatePlatforms();
        updateGames();
	}

	public static GiftCenterCache getInstance(){
		if(instance==null){
			synchronized (lock) {
				if(instance==null){
					instance=new GiftCenterCache();
				}
			}
		}
		return instance;
	}

    public synchronized void updatePlatforms(){
        platformsMap.clear();
        platformsSelectItemList.clear();
        List<PackagePlatforms> list = FacadeFactory.INSTANCE.getBaseSo().findObjects(new PackagePlatforms(), new Page());
        for(PackagePlatforms p:list){
            platformsMap.put(p.getSeqid(), p.getPlatName());
            platformsSelectItemList.add(new SelectItem(p.getSeqid(), p.getSeqid() + "-" + p.getPlatName()));
        }

        logger.info("[updatePlatforms]"+platformsMap);
    }

    public void updateGames(){
        recordTime = new Date();
        updateGamesAll();
        updateWebGames();
        updateMobileGames();
        updateManufactorers();
    }

    public synchronized void updateGamesAll(){
        gamesMap.clear();
        gamesSelectItemList.clear();
        List<PackageGames> list = FacadeFactory.INSTANCE.getBaseSo().findObjects(new PackageGames(), new Page());
        for(PackageGames g:list){
            gamesMap.put(g.getSeqid(), g.getGameName());
            gamesSelectItemList.add(new SelectItem(g.getSeqid(), g.getSeqid() + "-" + g.getGameName()));
        }
    }

    public synchronized void updateWebGames(){
        webGamesMap.clear();
        webGamesSelectItemList.clear();
        PackageGames query = new PackageGames();
        query.setGameType(1);
        List<PackageGames> list = FacadeFactory.INSTANCE.getBaseSo().findObjects(query, new Page());
        for(PackageGames g:list){
            webGamesMap.put(g.getSeqid(), g.getGameName());
            webGamesSelectItemList.add(new SelectItem(g.getSeqid(), g.getSeqid() + "-" + g.getGameName()));
        }
    }

    public synchronized void updateMobileGames(){
        mobileGamesMap.clear();
        mobileGamesSelectItemList.clear();
        PackageGames query = new PackageGames();
        query.setGameType(2);
        List<PackageGames> list = FacadeFactory.INSTANCE.getBaseSo().findObjects(query, new Page());
        for(PackageGames g:list){
            mobileGamesMap.put(g.getSeqid(), g.getGameName());
            mobileGamesSelectItemList.add(new SelectItem(g.getSeqid(), g.getSeqid() + "-" + g.getGameName()));
        }
    }

    private boolean isFlushManufacturers(){
        boolean flag = true;
        Date now = new Date();
        if(now.getTime()-recordTime.getTime()<2*60*1000)
            flag=false;
        return flag;
    }

    public synchronized void updateManufactorers(){

        manufactorerMap.clear();
        manufactorerSelectItemList.clear();
        List<PackageManufacturer> list = FacadeFactory.INSTANCE.getBaseSo().findObjects(new PackageManufacturer(), new Page());
        for(PackageManufacturer p:list){
            manufactorerMap.put(p.getSeqid(), p.getPlatform());
            manufactorerSelectItemList.add(new SelectItem(p.getSeqid(), p.getSeqid() + "-" +p.getPlatform()));
        }

        logger.info("[updateManufactorers]"+manufactorerMap);
    }

    public Map<Long, String> getManufactorerMap() {
        if(isFlushManufacturers())
            updateManufactorers();
        return manufactorerMap;
    }

    public List<SelectItem> getManufactorerSelectItemList() {
        if(isFlushManufacturers())
            updateManufactorers();
        return manufactorerSelectItemList;
    }

    public Map<Long, String> getGamesMap() {
        return gamesMap;
    }

    public List<SelectItem> getGamesSelectItemList() {
        return gamesSelectItemList;
    }

    public Map<Long, String> getMobileGamesMap() {
        return mobileGamesMap;
    }

    public List<SelectItem> getMobileGamesSelectItemList() {
        return mobileGamesSelectItemList;
    }

    public Map<Long, String> getPlatformsMap() {
        return platformsMap;
    }

    public List<SelectItem> getPlatformsSelectItemList() {
        return platformsSelectItemList;
    }

    public Map<Long, String> getWebGamesMap() {
        return webGamesMap;
    }

    public List<SelectItem> getWebGamesSelectItemList() {
        return webGamesSelectItemList;
    }
}
