package com.xunlei.niux.manager.web.cache;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.faces.model.SelectItem;

import com.ferret.common.dao.enums.OrderType;
import com.ferret.common.dao.vo.Page;
import com.xunlei.niux.data.vipgame.facade.FacadeFactory;
import com.xunlei.niux.data.vipgame.vo.CpsGames;
import com.xunlei.niux.data.vipgame.vo.Games;
import org.springframework.beans.BeanUtils;

/**
 * 游戏信息缓存
 * @author Administrator
 *
 */
public class GameCache {
	private static GameCache instance;
	private static Object lock=new Object();
	
	private Object updateCacheLock=new Object();
	
	private Map<String,Games> gameNoMap =new HashMap<String,Games>();//游戏编号对应游戏
	private Map<String,Games> gameIdMap =new HashMap<String,Games>();//游戏id对应游戏
	private Map<Long,Games> gameSeqIdMap =new HashMap<Long,Games>();//seqid对应游戏
	private List<Games> allGameList=new ArrayList<Games>();//所有游戏list
	
	/**
	 * jsf下拉列表
	 */
	private Map<String,String> gameNoNameMap=new HashMap<String,String>();
	private Map<String,String> gameIdNameMap=new HashMap<String,String>();
	private Map<Long,String> gameSeqIdNameMap=new HashMap<Long,String>();
	
	private List<SelectItem> gameNoSelectItemList=new ArrayList<SelectItem>();//
	private List<SelectItem> gameIdSelectItemList=new ArrayList<SelectItem>();

	private GameCache(){
		updateCache();//更新缓存
	}
	/**
	 * 获取游戏缓存类对象
	 * @return
	 */
	public static GameCache getInstance(){
		if(instance==null){
			synchronized (lock) {
				if(instance==null){
					instance=new GameCache();
				}
			}
		}
		return instance;
	}
	/**
	 * 获取所有Games游戏信息
	 */
	private List<Games> getGameList(){
		Games qg=new Games();
		Page page=new Page();
		page.addOrder("simpleName", OrderType.ESC);
		List<Games> list=FacadeFactory.INSTANCE.getGamesBo().findGames(qg, page);
		if(list==null){
			list=new ArrayList<Games>();
		}

        return list;
	}

    /**
     * 获取所有cps游戏信息
     * @return
     */
    private List<CpsGames> getCPSGameList(){
        CpsGames qg=new CpsGames();
        Page page=new Page();
        page.addOrder("simpleName", OrderType.ESC);
        List<CpsGames> list=FacadeFactory.INSTANCE.getBaseSo().findObjects(qg, page);
        if(list==null){
            list=new ArrayList<CpsGames>();
        }

        return list;
    }
	/**
	 * 更新到缓存中
	 * @param glist
	 */
	public void updateCache(){
		 Map<String,Games> tGameNoMap =new HashMap<String,Games>();
		 Map<String,Games> tGameIdMap =new HashMap<String,Games>();
		 Map<Long,Games> tGameSeqIdMap =new HashMap<Long,Games>();
		 Map<String,String> tGameNoNameMap=new HashMap<String,String>();
		 Map<String,String> tGameIdNameMap=new HashMap<String,String>();
		 Map<Long,String> tGameSeqidNameMap=new HashMap<Long, String>();
		 
		 List<SelectItem> tgameNoSelectItemList=new ArrayList<SelectItem>();//
		 List<SelectItem> tgameIdSelectItemList=new ArrayList<SelectItem>();

         List<Games> glist = getGameList();
		 for(Games game:glist){
			 tGameNoMap.put(game.getGameNo(), game);
			 tGameIdMap.put(game.getGameId(), game);
			 tGameSeqIdMap.put(game.getSeqId(), game);
			 tGameNoNameMap.put(game.getGameNo(), game.getSimpleName()+"-"+game.getGameName());
			 tGameIdNameMap.put(game.getGameId(), game.getGameName());
			 tGameSeqidNameMap.put(game.getSeqId(), game.getGameName());
			 
			 tgameNoSelectItemList.add(new SelectItem(game.getGameNo(),game.getGameName()));
			 tgameIdSelectItemList.add(new SelectItem(game.getGameId(),game.getSimpleName()+"-"+game.getGameName()));
			
		 }
        List<CpsGames> cpsList = getCPSGameList();
        for(CpsGames cpsGame : cpsList){
            tGameNoNameMap.put(cpsGame.getGameNo(), cpsGame.getGameName());
            tGameIdNameMap.put(cpsGame.getGameId(), cpsGame.getGameName());
        }

		 synchronized (updateCacheLock) {
			 gameNoMap = tGameNoMap;
			 gameIdMap = tGameIdMap;
			 gameSeqIdMap = tGameSeqIdMap;
			 allGameList=glist;
			 gameNoNameMap=tGameNoNameMap;
			 gameIdNameMap=tGameIdNameMap;
			 gameSeqIdNameMap=tGameSeqidNameMap;
			 gameNoSelectItemList=tgameNoSelectItemList;
			 gameIdSelectItemList=tgameIdSelectItemList;
		}
	}
	
	/**
	 * 获取所有游戏信息
	 * @return
	 */
	public List<Games> getAllGames(){
		List<Games> tempAllGameList=allGameList;
		List<Games> list=new ArrayList<Games>();
		for(Games game:tempAllGameList){
			list.add(copy(game));
		}
		return list;
	}
	/**
	 * 游戏编码获取游戏信息
	 * @param gameNo
	 * @return
	 */
	public Games getGameByGameNo(String gameNo){
		
		return copy(gameNoMap.get(gameNo));
	}
	/**
	 * 游戏id获取游戏信息
	 * @param gameId
	 * @return
	 */
	public Games getGameByGameId(String gameId){
		return copy(gameIdMap.get(gameId));
	}
	/**
	 * seqid获取游戏信息
	 * @param seqid
	 * @return
	 */
	public Games getGameBySeqid(long seqid){
		return copy(gameSeqIdMap.get(seqid));
	}
	/**
	 * 拷贝游戏信息
	 * @param games
	 * @return
	 */
	private Games copy(Games games){
		if(games==null){
			return null;
		}
		Games rg=new Games();
//		rg.setClientType(games.getClientType());
//		rg.setCoparnterId(games.getCoparnterId());
//		rg.setDisplayOrder(games.getDisplayOrder());
//		rg.setEditBy(games.getEditBy());
//		rg.setEditTime(games.getEditTime());
//		rg.setForumUrl(games.getForumUrl());
//		rg.setGameDesc(games.getGameDesc());
//		rg.setGameId(games.getGameId());
//		rg.setGameName(games.getGameName());
//		rg.setGameNo(games.getGameNo());
//		rg.setGameType(games.getGameType());
//		rg.setInputBy(games.getInputBy());
//		rg.setInputTime(games.getInputTime());
//		rg.setLoadClientType(games.getLoadClientType());
//		rg.setOfficialWebSite(games.getOfficialWebSite());
//		rg.setRemark(games.getRemark());
//		rg.setRunStatus(games.getRunStatus());
//		rg.setSeqId(games.getSeqId());
//		rg.setStatus(games.getStatus());
//		rg.setUseTemplate(games.getUseTemplate());
//		rg.setHasBigFenQu(games.getHasBigFenQu());
//		rg.setPayUrl(games.getPayUrl());
//		rg.setSimpleName(games.getSimpleName());

        BeanUtils.copyProperties(games,rg);

		return rg;
	}
	
	
	public Map<String, String> getGameNoNameMap() {
		return gameNoNameMap;
	}
	public Map<String, String> getGameIdNameMap() {
		return gameIdNameMap;
	}
	public List<SelectItem> getGameNoSelectItemList() {
		return gameNoSelectItemList;
	}
	public List<SelectItem> getGameIdSelectItemList() {
		return gameIdSelectItemList;
	}
	public Map<Long, String> getGameSeqIdNameMap() {
		return gameSeqIdNameMap;
	}

	
}
