package com.xunlei.niux.manager.template.thread;

import com.xunlei.niux.data.vipgame.facade.FacadeFactory;
import com.xunlei.niux.data.vipgame.vo.SpreadInfoTime;
import com.xunlei.niux.data.vipgame.vo.Spreadinfo;
import com.xunlei.niux.manager.web.util.SpreadInfoUtil;
import org.apache.log4j.Logger;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;

/**
 * 推广信息定时任务
 *
 * @author hezhong
 */
public class SpreadInfoThread extends Thread {
    private static final Logger logger = Logger.getLogger(SpreadInfoThread.class);
    private static final SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    @Override
    public void run() {
        while(true){
            try{
                exec();
            } catch (Exception e) {
                logger.error("推广信息定时任务出错", e);
            }

            try {
                sleep(1000 * 60);
            } catch (InterruptedException e) {
                logger.error("睡眠出错");
            }
        }
    }

    private void exec() {
        logger.debug("开始定时切量计划");

        List<SpreadInfoTime> lists = FacadeFactory.INSTANCE.getSpreadInfoTimeBo().findAll();

        boolean isUpadte = false;
        for(SpreadInfoTime spreadInfoTime : lists) {
            String spreaddate = spreadInfoTime.getSpreaddate();

            try {
                long l = sdf.parse(spreaddate).getTime();

                if(new Date().getTime() - l > 0) {
                    //开始切量
                    long id = Long.parseLong(String.valueOf(spreadInfoTime.getSpreadid()));

                    Spreadinfo spreadinfo =  FacadeFactory.INSTANCE.getSpreadinfoBo().findSpreadInfo(id);
                    spreadinfo.setJumpurl(spreadInfoTime.getJumpurl());

                    //更新跳转URL
                    FacadeFactory.INSTANCE.getSpreadinfoBo().updateSpreadinfo(spreadinfo);

                    //更新定时状态
                    spreadInfoTime.setIsinvalid(true);
                    FacadeFactory.INSTANCE.getSpreadInfoTimeBo().update(spreadInfoTime);

                    isUpadte = true;
                }
            } catch (Exception e) {
                logger.error("定时ID：" + spreadInfoTime.getSeqid() + "执行异常", e);
            }
        }

        if(isUpadte) {
            SpreadInfoUtil.reloadInfo();
            logger.debug("通知更新");
        }

        logger.debug("结束定时切量");



    }
}
