package com.xunlei.niux.manager.template.thread;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.log4j.Logger;

import com.ferret.common.dao.vo.Page;
import com.xunlei.niux.data.vipgame.facade.FacadeFactory;
import com.xunlei.niux.data.vipgame.vo.AutoCount;
import com.xunlei.niux.data.vipgame.vo.AutoProduct;
import com.xunlei.niux.data.vipgame.vo.BonusProduct;

/**
 * 自动发放奖品线程
 * @author lisu
 *  2013-04-24
 *
 */
public class AutoProductThread extends Thread{

	private static final Logger logger=Logger.getLogger(AutoProductThread.class.getName());
	private static final SimpleDateFormat sdf=new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
	
	public void run(){
		while(true){
            try{
                exec();
            } catch (Exception e) {
                logger.error("自动发放奖品定时任务出错", e);
            }

			try {
				sleep(1000);
			} catch (InterruptedException e) {
				logger.error("睡眠出错");
			}
		}
	}
	
    private void exec(){
    	try{
			logger.info("开始执行自动发放奖品定时任务");
			String nowtime = sdf.format(new Date());//系统当前时间
			String time = nowtime.split(" ")[1];
			String sql = " SELECT * FROM autoproduct WHERE DATE_FORMAT(TIME,'%T') <= '"+time+"' and '"+time+"'< '23:50:00' and flag = 0";
			List<Object> list=new ArrayList<Object>();
			List aplist = FacadeFactory.INSTANCE.getAutoProductBo().executeQuery(AutoProduct.class, sql, list);
			if(aplist != null && aplist.size()>0){
				List<AutoCount> aclist = FacadeFactory.INSTANCE.getAutoCountBo().findAutoCount(new AutoCount(), new Page());
				for(Object obj:aplist){
					AutoProduct ap = (AutoProduct)obj;
					boolean flag = false;
					boolean isrun = false;
					for(AutoCount ac:aclist){
						if(ap.getProductid().trim().equals(ac.getProductNo().trim())){	
							isrun = true;
							if(ac.getCount()-ap.getAmount().intValue()<0){
								if(ac.getCount() != 0){
									ap.setAmount(ac.getCount().intValue());
								}else{
									flag = true;
									break;
								}
							}
							ac.setCount(ac.getCount()-ap.getAmount().intValue());
							FacadeFactory.INSTANCE.getAutoCountBo().update(ac);
							logger.info("auto product success. productNO:"+ac.getProductNo()+",amount:"+ap.getAmount());
							
						}
					}
					if(!flag&&isrun){
						updateProductAmount(ap.getProductid().trim(),ap.getAmount().intValue());
						ap.setFlag(true);
						FacadeFactory.INSTANCE.getAutoProductBo().update(ap);	
					}													
				}				
			}			
			logger.info("结束执行自动发放奖品定时任务");
		}catch(Exception e){
			logger.error(e);
		}    	
    }
    
    /**
     * 更新奖品中的总数量和剩余数量
     */
    private void updateProductAmount(String productNo,int amount){
    	BonusProduct bp = new BonusProduct();
    	bp.setProductNo(productNo);
    	bp.setProductNum(new Long(amount));
    	logger.info("productNo:"+productNo);
    	logger.info("amount:"+amount);
    	FacadeFactory.INSTANCE.getBonusProductBo().update_recharge(bp);
    	logger.info("updateProductAmount success.productNo:"+productNo+",amount:"+amount);
    }
}
