package com.xunlei.niux.manager.template.model;

import com.xunlei.common.util.FunRef;
import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import com.xunlei.niux.data.vipgame.bo.HtmlTemplateBo;
import com.xunlei.niux.data.vipgame.facade.FacadeFactory;
import com.xunlei.niux.data.vipgame.vo.HtmlTemplate;
import com.xunlei.niux.manager.web.model.BaseManagedBean;
import com.xunlei.niux.manager.web.util.NiUxFunctionConstant;
import org.apache.log4j.Logger;

import java.util.ArrayList;
import java.util.List;

/**
 * @author hezhong
 */
@FunRef(NiUxFunctionConstant.NIUX_FUNCTION_HTMLTEMPLATE)
public class HtmltemplateModel extends BaseManagedBean {

    private static final Logger logger = Logger.getLogger(HtmltemplateModel.class);

    public String getQueryHtmlTemplateList() {

        this.authenticateRun();//验证运行权限

        HtmlTemplate htmlTemplate = findBean(HtmlTemplate.class, "htmltemplate");

        PagedFliper pagedFliper = this.getFliper();
        HtmlTemplateBo htmlTemplateBo = FacadeFactory.INSTANCE.getHtmlTemplateBo();
        int count = htmlTemplateBo.count(htmlTemplate);
        pagedFliper.setRecordCount(count);

        List<HtmlTemplate> list = new ArrayList<HtmlTemplate>();
        if (count > 0) {
            list = htmlTemplateBo.find(htmlTemplate,
                    pagedFliper.getPageNo(), pagedFliper.getPageSize());
        }
        Sheet<HtmlTemplate> sheet = new Sheet<HtmlTemplate>(count, list);
        this.mergePagedDataModel(sheet, pagedFliper);

        return "";
    }

    public String edit() {
        this.authenticateRun();

        HtmlTemplate htmlTemplate = findBean(HtmlTemplate.class, "htmltemplate");
        if (htmlTemplate == null) {
            logger.debug("编辑内容为空");
            mergeBean("编辑失败，原因：编辑内容为空", "jsmessage");
            return "";
        }

        try {
            HtmlTemplateBo htmlTemplateBo = FacadeFactory.INSTANCE.getHtmlTemplateBo();

            HtmlTemplate temp = htmlTemplateBo.find(htmlTemplate.getTemplateid());
            if(temp==null){
                logger.debug("编辑内容为空");
                mergeBean("编辑失败，原因：编辑内容为空", "jsmessage");
                return "";
            }


            htmlTemplateBo.update(htmlTemplate);
        } catch (Exception e) {
            logger.error("编辑失败", e);
            mergeBean("编辑失败，原因：" + e.getMessage(), "jsmessage");
        }

        getQueryHtmlTemplateList();


        return "";
    }

    public String add() {
        this.authenticateRun();

        HtmlTemplate htmlTemplate = findBean(HtmlTemplate.class, "htmltemplate");
        if (htmlTemplate == null) {
            logger.debug("添加内容为空");
            mergeBean("添加失败，原因：添加内容为空", "jsmessage");
            return "";
        }
        try{
            FacadeFactory.INSTANCE.getHtmlTemplateBo().insert(htmlTemplate);
        }catch(Exception e){
            logger.error("添加失败", e);
            mergeBean("添加失败，原因：" + e.getMessage(), "jsmessage");
        }


        return "";
    }

    public String delete() {
        this.authenticateRun();

        String paramseqids = findParameter("delseqids");
        String[] params = paramseqids.split(",");

        try{
            for(String id : params) {

                FacadeFactory.INSTANCE.getHtmlTemplateBo().delete(id);
            }
        } catch (Exception e) {
            logger.error("删除失败", e);
            mergeBean("删除失败，原因：" + e.getMessage(), "jsmessage");
        }

        getQueryHtmlTemplateList();

        return "";
    }

}
