package com.xunlei.niux.manager.template.listener;

import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;

import com.xunlei.niux.manager.template.thread.AutoProductThread;
import com.xunlei.niux.manager.template.thread.SpreadInfoThread;
import com.xunlei.niux.manager.template.thread.TempBuildThread;

/**
 * 模板监听器
 * @author lin
 * @date 2012-10-15
 * @Descripter:
 */
public class TempListener implements ServletContextListener {

    private ScheduledExecutorService scheduledExecutorService = Executors.newScheduledThreadPool(1);

    public void contextDestroyed(final ServletContextEvent arg0) {

	}

	
	public void contextInitialized(final ServletContextEvent arg0) {

		TempBuildThread tbt=new TempBuildThread();
        tbt.start();
        new SpreadInfoThread().start();
        new AutoProductThread().start();

        scheduledExecutorService.scheduleAtFixedRate(new OpenServerScheduleTask(), 10, 3600, TimeUnit.SECONDS);
        scheduledExecutorService.scheduleAtFixedRate(new OpenFenQuScheduleTask(), 10, 60, TimeUnit.SECONDS);
        scheduledExecutorService.scheduleAtFixedRate(new LyChatWarningScheduleTask(), 10, 600, TimeUnit.SECONDS);

	}
}
