package com.xunlei.niux.manager.template.builder.yy;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

import com.ferret.common.dao.enums.OrderType;
import com.ferret.common.dao.vo.Page;
import com.xunlei.httptool.util.JsonObjectUtil;
import com.xunlei.niux.data.vipgame.facade.FacadeFactory;
import com.xunlei.niux.data.vipgame.vo.LinkInfo;
import com.xunlei.niux.data.vipgame.vo.YyQuestion;
import com.xunlei.niux.manager.template.builder.AbstractTemplateBuilder;
import com.xunlei.niux.manager.web.util.FileUploadUtil;
import com.xunlei.niux.manager.web.util.FileUtil;
import com.xunlei.niux.manager.web.util.FreemarkerUtil;

public class YyQuestionBuilder extends AbstractTemplateBuilder{

	public void executeShcema() throws Exception {
		Map<String,Object> root=new HashMap<String,Object>();
        Map<String,Object> jsonMap = new HashMap<String, Object>();
        List<Map<String,Object>> yyFirstHuDongList = getYyFirstHuDong();
        List<Map<String,Object>> yyHuDongList = getYyHuDong();

		root.put("home", yyFirstHuDongList);
		root.put("chat", yyHuDongList);

        jsonMap.put("home", yyFirstHuDongList);
        jsonMap.put("chat", yyHuDongList);
        
		root.put("notice", getNotice());

		jsonMap.put("gameBox", getGameBoxMap());
		Map<String,String> vedioADMap=getvedioAD();
		if(vedioADMap!=null){
			jsonMap.put("vedioAD", getvedioAD());
		}
		LinkInfo li=FacadeFactory.INSTANCE.getLinkInfoBo().getValidteLinkInfoByLinkLocId("258", isPreView);
		root.put("adText",(li==null)?"":li.getLinktitle());
		root.put("adUrl", (li==null)?"":li.getLinkurl());
		LinkInfo vipli=FacadeFactory.INSTANCE.getLinkInfoBo().getValidteLinkInfoByLinkLocId("271", isPreView);
		root.put("vipadText",(vipli==null)?"":vipli.getLinktitle());
		root.put("vipadUrl", (vipli==null)?"":vipli.getLinkurl());
		String htmlFilePath=isPreView?htmlTemplate.getPreviewhtmlroot():htmlTemplate.getHtmlroot();
		String yyquestionStr=JsonObjectUtil.getDataJsonObject(root);
        File questionfile=FileUtil.createFile(htmlFilePath, "yyquestion.js");
        FileUploadUtil.write(questionfile, "XmsModule.getInstance().loadConfigDone("+yyquestionStr+")");

        String xmsconfigStr=JsonObjectUtil.getDataJsonObject(jsonMap);
        File xmsjsonfile=FileUtil.createFile(htmlFilePath, "xmsconfig.js");
        FileUploadUtil.write(xmsjsonfile, "PageFloatToolbar.getInstance().setButlerConfig(" + xmsconfigStr +")");
	    FreemarkerUtil.buildHtml(htmlTemplate.getTemplateroot(), "xmsconfig.xml", root, htmlFilePath, "xmsconfig.xml");
	}
	private Map<String,String> getGameBoxMap(){
		LinkInfo gameboxli=FacadeFactory.INSTANCE.getLinkInfoBo().getValidteLinkInfoByLinkLocId("237", this.isPreView);
		Map<String,String> gameboxmap=new HashMap<String,String>();
		if(gameboxli!=null){
			gameboxmap.put("url", gameboxli.getLinkurl()==null?"":gameboxli.getLinkurl());
		}
		return gameboxmap;
	}
	private Map<String,String> getvedioAD(){
		Map<String,String> vedioAD=new HashMap<String,String>();
		LinkInfo li=FacadeFactory.INSTANCE.getLinkInfoBo().getValidteLinkInfoByLinkLocId_V2("1266", this.isPreView);
		if(li==null){
			return null;
		}
		vedioAD.put("src",li.getPicurl());
		vedioAD.put("url",li.getLinkurl()==null?"":li.getLinkurl());
		vedioAD.put("type", li.getPicurl().endsWith(".swf")?"flash":"img");
		return vedioAD;
	}
	public List<Map<String,Object>> getNotice(){
		List<Map<String,Object>> yymaplist=new ArrayList<Map<String,Object>>();
		List<LinkInfo> list=FacadeFactory.INSTANCE.getLinkInfoBo().getValidteLinkInfoListByLinkLocId("257", 5, isPreView);
		for(LinkInfo li:list){
			Map<String,Object> map=new HashMap<String,Object>();
			map.put("text",li.getLinktitle()==null?"":li.getLinktitle());
			map.put("url",li.getLinkurl()==null?"":li.getLinkurl());
			yymaplist.add(map);
		}
		return yymaplist;
	}
	public List<Map<String,Object>> getYyFirstHuDong(){
		List<Map<String,Object>> yymaplist=new ArrayList<Map<String,Object>>();
		YyQuestion qyq=new YyQuestion();
		qyq.setIsValid(true);
		qyq.setParentSeqId(1L);
		Page page=new Page();
		page.addOrder("displaySort", OrderType.ESC);
		List<YyQuestion> yyList=FacadeFactory.INSTANCE.getYyQuestionBo().find(qyq, new Page());
		for(YyQuestion yy:yyList){
			Map<String,Object> map=new HashMap<String,Object>();
			map.put("cid", yy.getSeqId());
			map.put("text", yy.getSolution()==null?"":yy.getSolution());
			map.put("nexttitle", yy.getQuestionTitle()==null?"":yy.getQuestionTitle());
            map.put("picUrl",yy.getPicUrl()==null?"":yy.getPicUrl());
			yymaplist.add(map);
		}
		return yymaplist;
	}
	public List<Map<String,Object>> getYyHuDong(){
		List<Map<String,Object>> yymaplist=new ArrayList<Map<String,Object>>();
		YyQuestion qyq=new YyQuestion();
		qyq.setIsValid(true);
		List<YyQuestion> yyList=FacadeFactory.INSTANCE.getYyQuestionBo().find(qyq, new Page());
		Map<Long,Map<String,Object>> yyMap=new HashMap<Long,Map<String,Object>>();
		for(YyQuestion yy:yyList){
			Map<String,Object> map=new HashMap<String,Object>();
			map.put("cid", yy.getSeqId());
			map.put("text", yy.getQuestionTitle()==null?"":yy.getQuestionTitle());
			map.put("choose", new ArrayList<Map<String,Object>>());
			map.put("type", yy.getQuestionType());
			yyMap.put(yy.getSeqId(), map);
		}
		for(YyQuestion yy:yyList){
			if(yy.getParentSeqId()==null){
				continue;
			}
			//获取父类
			Map<String,Object> pMap=yyMap.get(yy.getParentSeqId());
			if(pMap==null){
				continue;
			}
			String type=(String) pMap.get("type");
			if("0".equals(type)){
				continue;
			}
			//添加到子节点中
			Map<String,Object> childMap=new HashMap<String,Object>();
			childMap.put("cid", yy.getSeqId());
			childMap.put("text", yy.getSolution()==null?"":yy.getSolution());
			childMap.put("url", yy.getSolutionUrl()==null?"":yy.getSolutionUrl());
			@SuppressWarnings("unchecked")
			List<Map<String,Object>> childList=(List<Map<String, Object>>) pMap.get("choose");
			childList.add(childMap);
		}
		//设置子类
		Set<Long> keySet=yyMap.keySet();
		Iterator<Long> it=keySet.iterator();
		while(it.hasNext()){
			Long key=it.next();
			yymaplist.add(yyMap.get(key));
		}
		return yymaplist;
	}
}
