package com.xunlei.niux.manager.template.builder.xmp;


import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import com.ferret.common.dao.enums.OrderType;
import com.ferret.common.dao.vo.Page;
import com.xunlei.niux.data.vipgame.facade.FacadeFactory;
import com.xunlei.niux.data.vipgame.vo.GameServers;
import com.xunlei.niux.data.vipgame.vo.Games;
import com.xunlei.niux.data.vipgame.vo.LinkInfo;
import com.xunlei.niux.manager.constant.LinkLocationIdConstant;
import com.xunlei.niux.manager.template.builder.AbstractTemplateBuilder;
import com.xunlei.niux.manager.web.cache.GameCache;
import com.xunlei.niux.manager.web.util.DateUtil;
import com.xunlei.niux.manager.web.util.FreemarkerUtil;


/**
 * XMP模板生存
 * @author Administrator
 *
 */
public class XmpTempateBuilder extends AbstractTemplateBuilder {
	private static final Logger logger=Logger.getLogger(XmpTempateBuilder.class.getClass());
	public void executeShcema() throws Exception {
		Map<String,Object> root=new HashMap<String,Object>();
		root.put("latestEreaDataList", getLatestServer());
		root.put("lunBoTuDataList", getIndexLuBoTu());
		root.put("lunBoTuDataList2", getIndexLuBoTu2());
		root.put("tuiJianGameDataList", getTuiJianGame());
		root.put("scrollAdvDataList", getScrollAdv());
		root.put("niChaiDataList", getNiChaiList());
		root.put("allGameDataList", getAllGameList());
		root.put("latestEreaUpAdvDataList",getLatestEreaUpAdv());
		String tempPath=htmlTemplate.getTemplateroot();
		String templateFileName="index.ftl";
		String htmlFilePath=isPreView?htmlTemplate.getPreviewhtmlroot():htmlTemplate.getHtmlroot();
		String htmlFileName="index.html";
		
		FreemarkerUtil.buildHtml(tempPath, templateFileName, root, htmlFilePath+"/xmp/", htmlFileName);
		templateFileName="index2.ftl";
		FreemarkerUtil.buildHtml(tempPath, templateFileName, root, htmlFilePath+"/xmp2/", htmlFileName);
	}
	/**
	 * 获取最新开服列表(已开区)
	 * @return
	 */
	private List<Map<String,Object>> getLatestErea(){
		List<LinkInfo> list=FacadeFactory.INSTANCE.getLinkInfoBo().getValidteLinkInfoListByLinkLocId(LinkLocationIdConstant.XMP_LATESTOPENAREA, 6, isPreView);
		List<Map<String,Object>> result=new ArrayList<Map<String,Object>>();
		for(int i=0;i<list.size();i++){
			LinkInfo li=list.get(i);
			if(li==null){
				continue;
			}
			Games game=FacadeFactory.INSTANCE.getGamesBo().getGameByGameId(li.getGameidbytuijian());
			GameServers qgs=new GameServers();
			qgs.setGameId(li.getGameidbytuijian());
			qgs.setFenQuNum(Integer.valueOf(li.getExt1()));
			List<GameServers> gsList=FacadeFactory.INSTANCE.getGameServersBo().find(qgs, new Page());
			if(gsList==null||gsList.size()==0){
				continue;
			}
			GameServers gs=gsList.get(0);
			Map<String,Object> map=new HashMap<String,Object>();
			map.put("openTime", gs.getOpenTime());
			map.put("gameName", game.getGameName());
			map.put("gameNo", game.getGameNo());
			map.put("fenQuNum", gs.getFenQuNum());
			map.put("fenQuName", gs.getFenQuName());
			map.put("officialWebSite", game.getOfficialWebSite());
			map.put("openStatus", gs.getOpenStatus());
			result.add(map);
			
		}
		return result;
	}
	
	
	/**
	 * 获得最新区服数据，跟牛X官网一样
	 * @return add by lisu 2013-12-20
	 * 
	 */
	private List<Map<String,Object>> getLatestServer(){
	 	  List<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
		    String pattern = "yyyy-MM-dd HH:mm:ss";
	        Calendar calendar = Calendar.getInstance();
	        Date today = calendar.getTime();
	        String todayStr = DateUtil.format(today, pattern);

	        List<GameServers> tomorrowServersList = FacadeFactory.INSTANCE.getGameServersBo()
	                .getXmpOpenServersByFromDateAndToDate(todayStr,false,6);
	        int index = 0;
	        for(GameServers server:tomorrowServersList){
	        	if(index>5){
	        		break;
	        	}
				Map<String,Object> map=new HashMap<String,Object>();
				String opentime = server.getOpenTime();
				map.put("openTime", opentime);
				Games game = GameCache.getInstance().getGameByGameId(server.getGameId());
				map.put("gameName", game.getGameName());
				map.put("gameNo", game.getGameNo());
				map.put("officialWebSite",game.getOfficialWebSite());
				map.put("fenQuNum", server.getFenQuNum());
				map.put("fenQuName", server.getFenQuName());
				map.put("openStatus", server.getOpenStatus());
				result.add(map);			
				index++;
		    }
		return result;
	}
	
	
	
	/**
	 * 获取首页轮播图
	 * @return
	 */
	private List<Map<String,Object>> getIndexLuBoTu(){
		List<Map<String,Object>> result=new ArrayList<Map<String,Object>>();
		//获取轮播图配置
		List<LinkInfo> list=FacadeFactory.INSTANCE.getLinkInfoBo().getValidteLinkInfoListByLinkLocId(LinkLocationIdConstant.XMP_LUBOTU, 4, isPreView);
		if(list==null){
			return result;
		}
		for(int i=0;i<list.size();i++){
			LinkInfo li=list.get(i);
			String gameId=li.getGameidbytuijian();
			Games games=FacadeFactory.INSTANCE.getGamesBo().getGameByGameId(gameId);
			if(games==null){
				logger.info("gameid:"+gameId+"对应的游戏不存在");
				continue;
			}
			/**
			 * 获取最新区
			 */
			GameServers gs=FacadeFactory.INSTANCE.getGameServersBo().getLatestGameServerByGameId(li.getGameidbytuijian(), isPreView);
			if(gs==null){
				logger.info("gameId:"+li.getGameidbytuijian()+"对应的最新区不存在");
				continue;
			}
			Map<String,Object> map=new HashMap<String,Object>();
			map.put("picUrl", li.getPicurl());
			map.put("gameNo", games.getGameNo());
			map.put("gameName", games.getGameName());
			map.put("fenQuNum", gs.getFenQuNum());
			map.put("gameDesc",li.getLinkdesc()==null?"":li.getLinkdesc());
			
//			map.put("picUrl", li.getPicurl());
			map.put("title", li.getLinktitle()==null?"":li.getLinktitle());
			map.put("linkUrl", li.getLinkurl()==null?"":li.getLinkurl());
			result.add(map);
		}
		return result;
	}
	/**
	 * 获取首页轮播图
	 * @return
	 */
	private List<Map<String,Object>> getIndexLuBoTu2(){
		List<Map<String,Object>> result=new ArrayList<Map<String,Object>>();
		//获取轮播图配置
		List<LinkInfo> list=FacadeFactory.INSTANCE.getLinkInfoBo().getValidteLinkInfoListByLinkLocId(LinkLocationIdConstant.XMP_LUBOTU2, 4, isPreView);
		if(list==null){
			return result;
		}
		for(int i=0;i<list.size();i++){
			LinkInfo li=list.get(i);
			String gameId=li.getGameidbytuijian();
			Games games=FacadeFactory.INSTANCE.getGamesBo().getGameByGameId(gameId);
			if(games==null){
				logger.info("gameid:"+gameId+"对应的游戏不存在");
				continue;
			}
			/**
			 * 获取最新区
			 */
			GameServers gs=FacadeFactory.INSTANCE.getGameServersBo().getLatestGameServerByGameId(li.getGameidbytuijian(), isPreView);
			if(gs==null){
				logger.info("gameId:"+li.getGameidbytuijian()+"对应的最新区不存在");
				continue;
			}
			Map<String,Object> map=new HashMap<String,Object>();
			map.put("picUrl", li.getPicurl());
			map.put("gameNo", games.getGameNo());
			map.put("gameName", games.getGameName());
			map.put("fenQuNum", gs.getFenQuNum());
			map.put("gameDesc",li.getLinkdesc()==null?"":li.getLinkdesc());
			
//			map.put("picUrl", li.getPicurl());
//			map.put("title", li.getLinktitle()==null?"":li.getLinktitle());
//			map.put("linkUrl", li.getLinkurl()==null?"":li.getLinkurl());
			result.add(map);
		}
		return result;
	}
	/**
	 * 获取滚动广告
	 * @return
	 */
	private List<Map<String,Object>> getScrollAdv(){
		List<Map<String,Object>> result=new ArrayList<Map<String,Object>>();
		//获取轮播图配置
		List<LinkInfo> list=FacadeFactory.INSTANCE.getLinkInfoBo().getValidteLinkInfoListByLinkLocId(LinkLocationIdConstant.XMP_SCROLLADV, 5, isPreView);
		if(list==null){
			return result;
		}
		for(int i=0;i<list.size();i++){
			LinkInfo li=list.get(i);
			Map<String,Object> map=new HashMap<String,Object>();
			map.put("title", li.getLinktitle());
			map.put("jumpUrl", li.getLinkurl());
			result.add(map);
		}
		return result;
	}
	/**
	 * 获取推荐游戏
	 * @return
	 */
	private List<Map<String,Object>> getTuiJianGame(){
		List<Map<String,Object>> result=new ArrayList<Map<String,Object>>();
		//获取轮播图配置
		List<LinkInfo> list=FacadeFactory.INSTANCE.getLinkInfoBo().getValidteLinkInfoListByLinkLocId(LinkLocationIdConstant.XMP_TUIJIANGAME, 3, isPreView);
		if(list==null){
			return result;
		}
		for(int i=0;i<list.size();i++){
			LinkInfo li=list.get(i);
			Games games=FacadeFactory.INSTANCE.getGamesBo().getGameByGameId(li.getGameidbytuijian());
			if(games==null){
				logger.info("gameId:"+li.getGameidbytuijian()+"对应的游戏不存在");
			}
			Map<String,Object> map=new HashMap<String,Object>();
			map.put("gameNo", games.getGameNo());
			map.put("gameName", games.getGameName());
			map.put("officialWebSite",games.getOfficialWebSite());
			GameServers latestgameserver=FacadeFactory.INSTANCE.getGameServersBo().getLatestGameServerByGameId(games.getGameId(), false);
			map.put("latestFenQuNum", latestgameserver==null?-1:latestgameserver.getFenQuNum());
			result.add(map);
		}
		return result;
	}
	/**
	 * 最新开服列表上的广告位
	 * @return
	 */
	private List<Map<String,Object>> getLatestEreaUpAdv(){
		List<Map<String,Object>> result=new ArrayList<Map<String,Object>>();
		LinkInfo li=FacadeFactory.INSTANCE.getLinkInfoBo().getValidteLinkInfoByLinkLocId(LinkLocationIdConstant.XMP_LATESTEREAUPADV, isPreView);
		if(li==null){
			return result;
		}
		Map<String,Object> map=new HashMap<String,Object>();
		map.put("title", li.getLinktitle());
		map.put("jumpUrl", li.getLinkurl());
		result.add(map);
		return result;
	}
	/**
	 * 获取你猜数据
	 * @return
	 */
	private List<Map<String,Object>> getNiChaiList(){
		List<Map<String,Object>> result=new ArrayList<Map<String,Object>>();
		List<LinkInfo> list=FacadeFactory.INSTANCE.getLinkInfoBo().getValidteLinkInfoListByLinkLocId(LinkLocationIdConstant.XMP_NICHAI, 3, isPreView);
		if(list==null){
			return result;
		}
		for(int i=0;i<list.size();i++){
			LinkInfo li=list.get(i);
			Games games=FacadeFactory.INSTANCE.getGamesBo().getGameByGameId(li.getGameidbytuijian());
			if(games==null){
				logger.info("gameId:"+li.getGameidbytuijian()+"对应的游戏不存在");
				continue;
			}
			/**
			 * 获取最新区
			 */
			GameServers gs=FacadeFactory.INSTANCE.getGameServersBo().getLatestGameServerByGameId(li.getGameidbytuijian(), isPreView);
			if(gs==null){
				logger.info("gameId:"+li.getGameidbytuijian()+"对应的最新区不存在");
				continue;
			}
			Map<String,Object> map=new HashMap<String,Object>();
			map.put("gameName", games.getGameName());
			map.put("gameNo", games.getGameNo());
			map.put("fenQuNum",gs.getFenQuNum());
			result.add(map);
		}
		return result;
	}
	/**
	 * 获取XMP的所有游戏
	 * @return
	 */
	private List<Map<String,Object>> getAllGameList(){
		List<Map<String,Object>> result=new ArrayList<Map<String,Object>>();
		List<LinkInfo> list=FacadeFactory.INSTANCE.getLinkInfoBo().getValidteLinkInfoListByLinkLocId(LinkLocationIdConstant.XMP_ALLGAME, 500, false);
		if(list==null){
			return result;
		}
		for(int i=0;i<list.size();i++){
			LinkInfo li=list.get(i);
			Games games=FacadeFactory.INSTANCE.getGamesBo().getGameByGameId(li.getGameidbytuijian());
			if(games==null){
				logger.info("gameId:"+li.getGameidbytuijian()+"对应的游戏不存在");
				continue;
			}
			Map<String,Object> map=new HashMap<String,Object>();
			map.put("picUrl", li.getPicurl());
			map.put("gameNo",games.getGameNo());
			map.put("gameName", games.getGameName());
			map.put("officialWebSite", games.getOfficialWebSite());
			//查询分区
			GameServers queryGs=new GameServers();
			queryGs.setGameId(li.getGameidbytuijian());
			queryGs.setOpenStatus("1");
			Page page=new Page();
			page.setPageNo(1);
			page.setPageSize(7);
			page.addOrder("fenQuNum", OrderType.DESC);
			List<GameServers> gsList=FacadeFactory.INSTANCE.getGameServersBo().find(queryGs, page);
			Integer latestFenQuNum=null;
			//解析分区
			List<Map<String,Object>> fenqulist=new ArrayList<Map<String,Object>>();
			for(GameServers gs:gsList){
				Map<String,Object> fenquMap=new HashMap<String,Object>();
				fenquMap.put("fenQuNum", gs.getFenQuNum());
				fenquMap.put("fenQuName", gs.getFenQuName());
				if(latestFenQuNum==null||latestFenQuNum<gs.getFenQuNum()){
					latestFenQuNum=gs.getFenQuNum();
				}
				fenqulist.add(fenquMap);
			}
			map.put("fenQuList",fenqulist);
			map.put("latestFenQuNum", latestFenQuNum==null?"":latestFenQuNum);
			result.add(map);
		}
		return result;
	}
}
