package com.xunlei.niux.manager.template.builder.xmp;

import com.ferret.common.dao.vo.Page;
import com.xunlei.common.facade.IFacadeCommon;
import com.xunlei.common.vo.LibClassD;
import com.xunlei.common.vo.LibClassM;
import com.xunlei.niux.data.vipgame.dto.game.GameDTO;
import com.xunlei.niux.data.vipgame.facade.FacadeFactory;
import com.xunlei.niux.data.vipgame.vo.Games;
import com.xunlei.niux.data.vipgame.vo.HtmlTemplate;
import com.xunlei.niux.data.vipgame.vo.LinkInfo;
import com.xunlei.niux.data.vipgame.vo.mobilegameapkversion.MobileChannel;
import com.xunlei.niux.easyutils.commonutils.NumParseUtil;
import com.xunlei.niux.manager.template.builder.AbstractTemplateBuilder;
import com.xunlei.niux.manager.web.cache.ApkSpreadCache;
import com.xunlei.niux.manager.web.cache.GameCache;
import com.xunlei.niux.manager.web.util.FreemarkerUtil;
import com.xunlei.util.StringTools;

import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * Created by jamesjxin on 14-6-30.
 */
public class XMPMoBileTemplateBuilder extends AbstractTemplateBuilder {
    private Map<String,String> gameFeaturesMap;
    private Map<String,GameDTO> appGamesMap;


    @Override
    public void executeShcema() throws Exception {
        initAllAppGameMap();
        initGameFeaturesMap();

        String htmlTemlateRoot = htmlTemplate.getTemplateroot();
        String roothtml = getHtmlRoot();

//        String htmlTemlateRoot = "D:\\XL工作记录\\20140630XMP手游页面/";
//        String roothtml = "D:\\XL工作记录\\20140630XMP手游页面/output/";


        Map<String,Object> rootMap  = new HashMap<String, Object>();
        rootMap.put("sliderImgList",getSliderImgList("1292"));
        rootMap.put("sliderYouxiList",getMobileYouxiList());
        rootMap.put("advList", getAdvMapList());

//        String qcodePath = IFacadeCommon.INSTANCE.getLibconfigValueByConfigNo("qcodePath");
//        rootMap.put("qrcodeImgPath", StringUtils.isEmpty(qcodePath)?"":qcodePath);
        rootMap.put("qrcodeImgPath", "");

        //XMP手游页面
        FreemarkerUtil.buildHtml(htmlTemlateRoot, "mobilegame.html", rootMap, roothtml,
                "mobilegame.html");



//        //迅雷7右边栏
        rootMap.put("sliderImgList",getSliderImgList("1293"));
        FreemarkerUtil.buildHtml(htmlTemlateRoot, "xl7mbgame.html", rootMap, roothtml,
                "xl7mbgame.html");



        //官网2.0手机专区
        rootMap.put("sliderImgList",getSliderImgList("1275"));
        rootMap.put("mobilesliderImgList",getSliderImgList("1277"));
        HtmlTemplate niu2_0htmlTemplate = FacadeFactory.INSTANCE.getHtmlTemplateBo().find("000060");
        String niu2_0TemplateRoot = niu2_0htmlTemplate.getTemplateroot();
        String niu2_0HtmlPath = niu2_0htmlTemplate.getHtmlroot();
        FreemarkerUtil.buildHtml(niu2_0TemplateRoot, "mobilegame_inner.html", rootMap, niu2_0HtmlPath,
                "mobilegame_inner.html");



//        //官网3.0手机专区 （暂不上线）
//        HtmlTemplate niu3_0htmlTemplate = FacadeFactory.INSTANCE.getHtmlTemplateBo().find("000058");
//        String niu3_0TemplateRoot = niu3_0htmlTemplate.getTemplateroot();
//        String niu3_0HtmlPath = niu3_0htmlTemplate.getHtmlroot();
//        FreemarkerUtil.buildHtml(niu3_0TemplateRoot, "mobilegame.html", rootMap, niu3_0HtmlPath,
//                "mobilegame.html");
    }

    private void initAllAppGameMap(){
        appGamesMap = new HashMap<String, GameDTO>();
        List<GameDTO> list = FacadeFactory.INSTANCE.getGamesBo().getAllValidAppGames();
        if(CollectionUtils.isEmpty(list)){
            return;
        }

        for(GameDTO gameDTO:list){
            appGamesMap.put(gameDTO.getGameId(),gameDTO);
        }
    }

    private void initGameFeaturesMap(){
        gameFeaturesMap = new HashMap<String, String>();

        List datas = LibClassM.getLibClassDList("gameFeatures");

        for (int i = 0; i < datas.size(); i++) {
            String typeid = ((LibClassD) datas.get(i)).getItemno().trim();
            gameFeaturesMap.put(typeid,((LibClassD) datas.get(i)).getItemname().trim());
        }
    }

    private List<Map<String,Object>> getSliderImgList(String linklocId){
        List<LinkInfo> lilist=FacadeFactory.INSTANCE.getLinkInfoBo().getValidteLinkInfoListByLinkLocId_V2(linklocId, 4, isPreView);
        List<Map<String,Object>> lunbotuList=new ArrayList<Map<String,Object>>();
        for(int i=0;i<lilist.size();i++){
            LinkInfo li=lilist.get(i);
            Map<String,Object> map=new HashMap<String,Object>();
            map.put("title", li.getLinktitle()==null?"":li.getLinktitle());
            map.put("description", li.getLinkdesc()==null?"":li.getLinkdesc());
            map.put("url", li.getLinkurl()==null?"":li.getLinkurl());
            map.put("img", li.getPicurl()==null?"":li.getPicurl());
            lunbotuList.add(map);
        }
        return lunbotuList;
    }

    private List<Map<String,Object>> getMobileYouxiList(){
        List<Map<String,Object>> downloadList=new ArrayList<Map<String,Object>>();
        List<LinkInfo> lilist= FacadeFactory.INSTANCE.getLinkInfoBo().getValidteLinkInfoListByLinkLocId_V2("1276", 400, isPreView);
        for(int i=0;i<lilist.size();i++){
            LinkInfo li=lilist.get(i);
            Map<String,Object> map=new HashMap<String,Object>();

            String gameId = li.getGameidbytuijian();
            if(StringUtils.isEmpty(gameId)) continue;

            GameDTO game = appGamesMap.get(gameId);
            if(game == null){
                Games query = new Games();
                query.setGameId(gameId);
                Games games = FacadeFactory.INSTANCE.getBaseSo().findObject(query);
                if(games==null){
                    continue;
                }
                game = getGameDTOByGames(games);
            }

            int downloadNum = 100000;
            if(game.getDownloadNum()!=null && game.getDownloadNum() > 0){
                downloadNum = game.getDownloadNum();
            }else if(StringUtils.isNotEmpty(li.getExt4())){
                downloadNum = Integer.parseInt(li.getExt4());
            }

            String appSize = "100.0M";
            if(StringUtils.isNotEmpty(game.getAppSize())){
                appSize = game.getAppSize();
            }else if(StringUtils.isNotEmpty(li.getExt2())){
                appSize = li.getExt2();
            }

            map.put("imgSrc",  game.getSmallPicUrl()==null?"":game.getSmallPicUrl());
            map.put("title",game.getGameName());
            map.put("clientType",game.getMobileGameType()==null?1:game.getMobileGameType().intValue());
            map.put("yxType",gameFeaturesMap.get(String.valueOf(game.getGameFeature()))==null?"":gameFeaturesMap.get(String.valueOf(game.getGameFeature())));
            map.put("yxSize", appSize);
            map.put("yxDownUrl", game.getDownLoadUrl()==null?"":game.getDownLoadUrl());
            map.put("yxDetail", game.getGameDesc()==null?"":game.getGameDesc());
            map.put("yxStar", li.getExt3()==null?0:Integer.valueOf(li.getExt3()));

            map.put("yxPeople", NumParseUtil.getDownloadNumStr(String.valueOf(downloadNum)));
            map.put("gameid", gameId);
            map.put("tmplDownUrl", game.getDownLoadUrl()==null?"":game.getDownLoadUrl());
            map.put("downNum",NumParseUtil.getDownloadNumStr(String.valueOf(downloadNum)));
            downloadList.add(map);
        }
        return downloadList;
    }

    private List<Map<String,Object>> getAdvMapList(){
        List<MobileChannel> mcList=FacadeFactory.INSTANCE.getBaseSo().findObjects(new MobileChannel(), new Page());
        List<Map<String,Object>> mcMapList=new ArrayList<Map<String,Object>>();
        for(MobileChannel mc:mcList){
            Map<String,Object> tempMap=new HashMap<String, Object>();
            tempMap.put("advNo", mc.getChannelId());
            mcMapList.add(tempMap);
        }
        return mcMapList;
    }

    private GameDTO getGameDTOByGames(Games games){
        GameDTO game = new GameDTO();
        game.setGameId(games.getGameId());
        game.setGameName(games.getGameName());
        game.setMobileGameType(games.getMobileGameType());
        game.setGameFeature(games.getGameFeature());
        game.setGameDesc(games.getGameDesc());
        return game;
    }
}
