package com.xunlei.niux.manager.template.builder.xmp;

import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import com.xunlei.httptool.util.JsonObjectUtil;
import com.xunlei.niux.data.vipgame.facade.FacadeFactory;
import com.xunlei.niux.data.vipgame.vo.Games;
import com.xunlei.niux.data.vipgame.vo.LinkInfo;
import com.xunlei.niux.data.vipgame.vo.LinkLocation;
import com.xunlei.niux.manager.template.builder.AbstractTemplateBuilder;
import com.xunlei.niux.manager.web.cache.GameCache;
import com.xunlei.niux.manager.web.util.FileUtil;

public class BoxGameFenQuBuilder  extends AbstractTemplateBuilder{
	public void executeShcema() throws Exception {
		LinkLocation query=new LinkLocation();
		query.setLinktype("llg_280");
		List<LinkLocation> list=FacadeFactory.INSTANCE.getLinkLocationBo().find(query);
		if(list==null){
			return;
		}
		for(LinkLocation ll:list){
			buildOne(ll);
		}
	}
	public void buildOne(LinkLocation pll){
		Map<String,String> map=new HashMap<String,String>();
		LinkInfo li=FacadeFactory.INSTANCE.getLinkInfoBo().getValidteLinkInfoByLinkLocId_V2(pll.getLinklocid()+"", isPreView);
		if(li==null){
			buildjs(pll, map);
			return;
		}
		Games games=GameCache.getInstance().getGameByGameId(li.getGameidbytuijian());
		if(games!=null){
			map.put("gameId", li.getGameidbytuijian()==null?"":li.getGameidbytuijian());
			map.put("fenQuNum", li.getExt1()==null?"":li.getExt1());
			map.put("picurl", li.getPicurl()==null?"":li.getPicurl());
			map.put("smallpicurl", li.getSmallpicurl()==null?"":li.getSmallpicurl());
			map.put("officialurl", games.getOfficialWebSite()==null?"":games.getOfficialWebSite());
		}
		buildjs(pll, map);
	}
	public void buildjs(LinkLocation pll,Map<String,String> map){
		String jsonStr = JsonObjectUtil.getDataJsonObject(map);
		jsonStr="var "+pll.getExt1()+"="+jsonStr;
		String htmlFilePath = isPreView ? htmlTemplate.getPreviewhtmlroot() : htmlTemplate.getHtmlroot();
		if (htmlFilePath.endsWith("/")) {
			htmlFilePath = htmlFilePath.substring(0, htmlFilePath.length() - 1);
		}
		File file = FileUtil.createFile(htmlFilePath + "/actives/box_common/js",pll.getExt1()+".js");
		FileUtil.writeByChar(file, jsonStr);
	}
}
