package com.xunlei.niux.manager.template.builder.viprebate;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import com.xunlei.httptool.util.JsonObjectUtil;
import com.xunlei.niux.data.vipgame.facade.FacadeFactory;
import com.xunlei.niux.data.vipgame.vo.Games;
import com.xunlei.niux.data.vipgame.vo.LinkInfo;
import com.xunlei.niux.manager.template.builder.AbstractTemplateBuilder;
import com.xunlei.niux.manager.web.cache.GameCache;
import com.xunlei.niux.manager.web.util.FileUtil;

public class RebateBuilder extends AbstractTemplateBuilder{

	@Override
	public void executeShcema() throws Exception {

		String htmlFilePath = isPreView ? htmlTemplate.getPreviewhtmlroot() : htmlTemplate.getHtmlroot();
		if (htmlFilePath.endsWith("/")) {
			htmlFilePath = htmlFilePath.substring(0, htmlFilePath.length() - 1);
		}
		List<LinkInfo> lilist=FacadeFactory.INSTANCE.getLinkInfoBo().getValidteLinkInfoListByLinkLocId_V2("618", 2, this.isPreView);
		List<Map<String,Object>> mapList=new ArrayList<Map<String,Object>>();
		for(int i=0;i<lilist.size();i++){
			LinkInfo li=lilist.get(i);
			Games game=GameCache.getInstance().getGameByGameId(li.getGameidbytuijian());
			if(game==null){
				continue;
			}
			Map<String,Object> map=new HashMap<String,Object>();
			map.put("gameId", li.getGameidbytuijian());
			map.put("gameNo",game.getGameNo());
			map.put("gameName", game.getGameName());
			map.put("officialUrl", game.getOfficialWebSite()==null?"":game.getOfficialWebSite());
			map.put("haoping",li.getExt1()==null?"":li.getExt1());
			map.put("playernum", li.getExt2()==null?"":li.getExt2());
			map.put("logo", li.getPicurl()==null?"":li.getPicurl());
			map.put("title", li.getLinktitle()==null?"":li.getLinktitle());
			mapList.add(map);
		}
		String jsonStr=JsonObjectUtil.getDataJsonObject(mapList);
		jsonStr="var jinka_rebate_xiaohuoban ="+jsonStr+";";
	    File file=FileUtil.createFile(htmlFilePath+"/gamedata/jinkarebate", "xiaohuoban.js");
	    FileUtil.writeByChar(file, jsonStr);
	}
}
