package com.xunlei.niux.manager.template.builder.tips;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import com.xunlei.niux.easyutils.propertyutils.EnvPropertyUtil;
import org.apache.log4j.Logger;

import com.ferret.common.dao.enums.OrderType;
import com.ferret.common.dao.vo.Page;
import com.xunlei.httptool.util.JsonObjectUtil;
import com.xunlei.niux.client.util.URLUtil;
import com.xunlei.niux.data.tips.vo.TaskConf;
import com.xunlei.niux.data.vipgame.facade.FacadeFactory;
import com.xunlei.niux.data.vipgame.vo.GameServers;
import com.xunlei.niux.data.vipgame.vo.tips.TipsGameConstraint;
import com.xunlei.niux.data.vipgame.vo.tips.TipsInfo;
import com.xunlei.niux.data.vipgame.vo.tips.TipsSkin;
import com.xunlei.niux.manager.template.builder.AbstractTemplateBuilder;

public class RefreshBoxTipsBuilder extends AbstractTemplateBuilder{
	private static final Logger logger=Logger.getLogger(RefreshBoxTipsBuilder.class.getName());
	private static SimpleDateFormat yyyy_MM_ddHhmmss=new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
	private static String tipsNoticeUrl1= EnvPropertyUtil.loadProperty("niux", "tipsnoticeurl1");
	private static String tipsNoticeUrl2=EnvPropertyUtil.loadProperty("niux","tipsnoticeurl2");
	@Override
	public void executeShcema() throws Exception {
		refresh(5);//刷新盒子消息
		refresh(6);//刷新金钻催费tips
	}
	
	private void refresh(int index) throws Exception{
		TaskConf taskConf=com.xunlei.niux.data.tips.facade.FacadeFactory.INSTANCE.getBaseSo().findById(TaskConf.class, index);
		if(taskConf==null){
//			throw new Exception("taskConf主键等于"+index+"的行不存在");
		}
		String extraInfo=getRefreshConent(index);
		taskConf.setExtraInfo(extraInfo);
		com.xunlei.niux.data.tips.facade.FacadeFactory.INSTANCE.getBaseSo().updateObjectById(taskConf);
		try{
			URLUtil.get(tipsNoticeUrl1);
		}catch(Exception e){
			logger.error("tips通知盒子失败1",e);
		}
		try{
			URLUtil.get(tipsNoticeUrl2);
		}catch(Exception e){
			logger.error("tips通知盒子失败2",e);
		}		
		
	}
	
	private String getRefreshConent(int index){
		List<Map<String,Object>> refreshList=new ArrayList<Map<String,Object>>();
		if(index == 5){
			refreshList.addAll(getWebShowMapList());
			refreshList.addAll(getBoxShowMapList());
			refreshList.addAll(getWebGameShowMapList());
			refreshList.addAll(getBoxGameShowMapList());
		}else if(index == 6){
			refreshList.addAll(getJinZuanMapList());
			refreshList.addAll(getJinZuanWebGameShowMapList());
		}
		return JsonObjectUtil.getDataJsonObject(refreshList);
	}
	
	private List<Map<String,Object>> getJinZuanWebGameShowMapList(){
		List<TipsInfo> tipsInfoList=getValidTipsInfo("web_diamond_reminder");
		List<Map<String,Object>> webShowList=new ArrayList<Map<String,Object>>();
		for(TipsInfo tipsinfo:tipsInfoList){
			Map<String,Object> webShowMap=new HashMap<String,Object>();
			webShowMap.put("business", "web_diamond_reminder");
			webShowMap.put("clusterid", tipsinfo.getClassifyNo());
			webShowMap.put("tipsid", tipsinfo.getTipsNo());
			webShowMap.put("validdays", tipsinfo.getValidDays()==null?"":String.valueOf(tipsinfo.getValidDays()));
			webShowMap.put("showtimes", tipsinfo.getShowTimes()==null?"":String.valueOf(tipsinfo.getShowTimes()));
			Map<String,Object> configMap=new HashMap<String,Object>();
			configMap.put("style", tipsinfo.getClassifyNo());
			configMap.put("tipsTitle",tipsinfo.getSubtitle());
			configMap.put("title", tipsinfo.getTitle());
			configMap.put("content", tipsinfo.getContent());
			configMap.put("img", tipsinfo.getImgUrl());
			configMap.put("btnUrl", tipsinfo.getJumpUrl());
			configMap.put("btnName", tipsinfo.getButtonText());
			configMap.put("poptime", tipsinfo.getDelayPopTime());
			configMap.put("tipsType", getSkinSrcNo(tipsinfo.getSkinNo()));
			webShowMap.put("config_data", configMap);
			webShowMap.put("gameinfos", getGameConstraintList(tipsinfo.getTipsNo()));
//			webShowListMap.put(key, webShowMap);
			webShowList.add(webShowMap);
		}
		
//		Set<String> keySet=webShowListMap.keySet();
//		Iterator<String> it=keySet.iterator();
//		while(it.hasNext()){
//			webShowList.add(webShowListMap.get(it.next()));
//		}
		return webShowList;
	}
	private List<Map<String,Object>> getJinZuanMapList(){
		List<TipsInfo> tipsInfoList=getValidTipsInfo("box_diamond_reminder");
		List<Map<String,Object>> boxShowList=new ArrayList<Map<String,Object>>();
		for(TipsInfo tipsInfo:tipsInfoList){
			TipsSkin tipsSkin=FacadeFactory.INSTANCE.getBaseSo().findById(TipsSkin.class, tipsInfo.getSkinNo());
			if(tipsSkin==null){
				continue;
			}
			Map<String,Object> webShowMap=new HashMap<String,Object>();
			webShowMap.put("business", "box_diamond_reminder");
			webShowMap.put("clusterid", tipsInfo.getClassifyNo());
			webShowMap.put("tipsid", tipsInfo.getTipsNo());
			webShowMap.put("validdays", tipsInfo.getValidDays()==null?"":String.valueOf(tipsInfo.getValidDays()));
			webShowMap.put("showtimes", tipsInfo.getShowTimes()==null?"":String.valueOf(tipsInfo.getShowTimes()));
			Map<String,Object> configMap=new HashMap<String,Object>();
			configMap.put("poptime", tipsInfo.getDelayPopTime());
			configMap.put("style", tipsInfo.getClassifyNo());
			configMap.put("xarurl", tipsSkin.getSkinUrl());
			configMap.put("type", tipsSkin.getSkinSrcNo());
			configMap.put("title", tipsInfo.getTitle());
			configMap.put("info", tipsInfo.getContent());
			configMap.put("imgurl", tipsInfo.getImgUrl());
			configMap.put("clickurl", tipsInfo.getJumpUrl());
			configMap.put("btntext", tipsInfo.getButtonText());
			configMap.put("subtitle", tipsInfo.getSubtitle());
			configMap.put("opentype", "2");
			configMap.put("gameid","");
			configMap.put("sid","");
			configMap.put("serverid","");
			configMap.put("tipsType",tipsSkin.getSkinSrcNo());
			webShowMap.put("config_data", configMap);
			boxShowList.add(webShowMap);
		}
		return boxShowList;
	}
	
	
	
	
	private List<Map<String,Object>> getBoxShowMapList(){
		List<TipsInfo> tipsInfoList=getValidTipsInfo("box_login_v2");
		List<Map<String,Object>> boxShowList=new ArrayList<Map<String,Object>>();
		for(TipsInfo tipsInfo:tipsInfoList){
			TipsSkin tipsSkin=FacadeFactory.INSTANCE.getBaseSo().findById(TipsSkin.class, tipsInfo.getSkinNo());
			if(tipsSkin==null){
				continue;
			}
			Map<String,Object> webShowMap=new HashMap<String,Object>();
			webShowMap.put("business", "box_login_v2");
			webShowMap.put("clusterid", tipsInfo.getClassifyNo());
			webShowMap.put("tipsid", tipsInfo.getTipsNo());
			webShowMap.put("validdays", tipsInfo.getValidDays()==null?"":String.valueOf(tipsInfo.getValidDays()));
			webShowMap.put("showtimes", tipsInfo.getShowTimes()==null?"":String.valueOf(tipsInfo.getShowTimes()));
			Map<String,Object> configMap=new HashMap<String,Object>();
			configMap.put("poptime", tipsInfo.getDelayPopTime());
			configMap.put("style", tipsInfo.getClassifyNo());
			configMap.put("xarurl", tipsSkin.getSkinUrl());
			configMap.put("type", tipsSkin.getSkinSrcNo());
			configMap.put("title", tipsInfo.getTitle());
			configMap.put("info", tipsInfo.getContent());
			configMap.put("imgurl", tipsInfo.getImgUrl());
			configMap.put("clickurl", tipsInfo.getJumpUrl());
			configMap.put("btntext", tipsInfo.getButtonText());
			configMap.put("subtitle", tipsInfo.getSubtitle());
			configMap.put("opentype", "2");
			configMap.put("gameid","");
			configMap.put("sid","");
			configMap.put("serverid","");
			configMap.put("tipsType",tipsSkin.getSkinSrcNo());
			webShowMap.put("config_data", configMap);
			boxShowList.add(webShowMap);
		}
		return boxShowList;
	}
	private List<Map<String,Object>> getBoxGameShowMapList(){
		List<TipsInfo> tipsInfoList=getValidTipsInfo("box_login_game_timeout");
		List<Map<String,Object>> boxShowList=new ArrayList<Map<String,Object>>();
		for(TipsInfo tipsInfo:tipsInfoList){
			TipsSkin tipsSkin=FacadeFactory.INSTANCE.getBaseSo().findById(TipsSkin.class, tipsInfo.getSkinNo());
			if(tipsSkin==null){
				continue;
			}
			Map<String,Object> webShowMap=new HashMap<String,Object>();
			webShowMap.put("business", "box_login_game_timeout");
			webShowMap.put("clusterid", tipsInfo.getClassifyNo());
			webShowMap.put("tipsid", tipsInfo.getTipsNo());
			webShowMap.put("validdays", tipsInfo.getValidDays()==null?"":String.valueOf(tipsInfo.getValidDays()));
			webShowMap.put("showtimes", tipsInfo.getShowTimes()==null?"":String.valueOf(tipsInfo.getShowTimes()));
			Map<String,Object> configMap=new HashMap<String,Object>();
			configMap.put("poptime", tipsInfo.getDelayPopTime());
			configMap.put("style", tipsInfo.getClassifyNo());
			configMap.put("xarurl", tipsSkin.getSkinUrl());
			configMap.put("type", tipsSkin.getSkinSrcNo());
			configMap.put("title", tipsInfo.getTitle());
			configMap.put("info", tipsInfo.getContent());
			configMap.put("imgurl", tipsInfo.getImgUrl());
			configMap.put("clickurl", tipsInfo.getJumpUrl());
			configMap.put("btntext", tipsInfo.getButtonText());
			configMap.put("subtitle", tipsInfo.getSubtitle());
			configMap.put("opentype", "2");
			configMap.put("gameid","");
			configMap.put("sid","");
			configMap.put("serverid","");
			configMap.put("tipsType",tipsSkin.getSkinSrcNo());
			webShowMap.put("config_data", configMap);
			webShowMap.put("gameinfos", getGameConstraintList(tipsInfo.getTipsNo()));
			boxShowList.add(webShowMap);
		}
		return boxShowList;
	}
	private GameServers getGameServer(String gameId,int fenQuNum){
		if(gameId==null||"".equals(gameId)){
			return null;
		}
		GameServers queryGs=new GameServers();
		queryGs.setGameId(gameId);
		queryGs.setFenQuNum(fenQuNum);
		return FacadeFactory.INSTANCE.getBaseSo().findObject(queryGs);
	}
	private List<Map<String,Object>> getWebShowMapList(){
		Map<String,Map<String,Object>> webShowListMap=new HashMap<String, Map<String,Object>>();
		List<TipsInfo> tipsInfoList=getValidTipsInfo("web_login");
		List<Map<String,Object>> webShowList=new ArrayList<Map<String,Object>>();
		for(TipsInfo tipsinfo:tipsInfoList){
//			String key="web_login"+tipsinfo.getClassifyNo();
//			if(webShowListMap.containsKey(key)){
//				continue;
//			}
			Map<String,Object> webShowMap=new HashMap<String,Object>();
			webShowMap.put("business", "web_login");
			webShowMap.put("clusterid", tipsinfo.getClassifyNo());
			webShowMap.put("tipsid", tipsinfo.getTipsNo());
			webShowMap.put("validdays", tipsinfo.getValidDays()==null?"":String.valueOf(tipsinfo.getValidDays()));
			webShowMap.put("showtimes", tipsinfo.getShowTimes()==null?"":String.valueOf(tipsinfo.getShowTimes()));
			Map<String,Object> configMap=new HashMap<String,Object>();
			configMap.put("style", tipsinfo.getClassifyNo());
			configMap.put("tipsTitle",tipsinfo.getSubtitle());
			configMap.put("title", tipsinfo.getTitle());
			configMap.put("content", tipsinfo.getContent());
			configMap.put("img", tipsinfo.getImgUrl());
			configMap.put("btnUrl", tipsinfo.getJumpUrl());
			configMap.put("btnName", tipsinfo.getButtonText());
			configMap.put("tipsType", getSkinSrcNo(tipsinfo.getSkinNo()));
			configMap.put("poptime", tipsinfo.getDelayPopTime());
			webShowMap.put("config_data", configMap);
//			webShowListMap.put(key, webShowMap);
			webShowList.add(webShowMap);
		}
		return webShowList;
	}
	private List<TipsInfo> getValidTipsInfo(String bussinessNo){
		TipsInfo queryTipsInfo=new TipsInfo();
		queryTipsInfo.setBussinessNo(bussinessNo);
		queryTipsInfo.setLtValidTime(yyyy_MM_ddHhmmss.format(new Date()));
		queryTipsInfo.setIsValid(true);
		Page page=new Page();
		page.addOrder("validTime", OrderType.DESC);
		return FacadeFactory.INSTANCE.getBaseSo().findObjects(queryTipsInfo, page);
	}
	private List<Map<String,Object>> getWebGameShowMapList(){
//		Map<String,Map<String,Object>> webShowListMap=new HashMap<String, Map<String,Object>>();
		List<TipsInfo> tipsInfoList=getValidTipsInfo("web_logingame");
		List<Map<String,Object>> webShowList=new ArrayList<Map<String,Object>>();
		for(TipsInfo tipsinfo:tipsInfoList){
//			String key="web_logingame"+tipsinfo.getClassifyNo();
//			if(webShowListMap.containsKey(key)){
//				continue;
//			}
			Map<String,Object> webShowMap=new HashMap<String,Object>();
			webShowMap.put("business", "web_logingame");
			webShowMap.put("clusterid", tipsinfo.getClassifyNo());
			webShowMap.put("tipsid", tipsinfo.getTipsNo());
			webShowMap.put("validdays", tipsinfo.getValidDays()==null?"":String.valueOf(tipsinfo.getValidDays()));
			webShowMap.put("showtimes", tipsinfo.getShowTimes()==null?"":String.valueOf(tipsinfo.getShowTimes()));
			Map<String,Object> configMap=new HashMap<String,Object>();
			configMap.put("style", tipsinfo.getClassifyNo());
			configMap.put("tipsTitle",tipsinfo.getSubtitle());
			configMap.put("title", tipsinfo.getTitle());
			configMap.put("content", tipsinfo.getContent());
			configMap.put("img", tipsinfo.getImgUrl());
			configMap.put("btnUrl", tipsinfo.getJumpUrl());
			configMap.put("btnName", tipsinfo.getButtonText());
			configMap.put("poptime", tipsinfo.getDelayPopTime());
			configMap.put("tipsType", getSkinSrcNo(tipsinfo.getSkinNo()));
			webShowMap.put("config_data", configMap);
			webShowMap.put("gameinfos", getGameConstraintList(tipsinfo.getTipsNo()));
//			webShowListMap.put(key, webShowMap);
			webShowList.add(webShowMap);
		}
		
//		Set<String> keySet=webShowListMap.keySet();
//		Iterator<String> it=keySet.iterator();
//		while(it.hasNext()){
//			webShowList.add(webShowListMap.get(it.next()));
//		}
		return webShowList;
	}
	private List<Map<String,String>> getGameConstraintList(String tipsNo){
		List<Map<String,String>> gameList=new ArrayList<Map<String,String>>();
		
		TipsGameConstraint queryTipsGameConstraint=new TipsGameConstraint();
		queryTipsGameConstraint.setTipsNo(tipsNo);
		List<TipsGameConstraint> list=FacadeFactory.INSTANCE.getBaseSo().findObjects(queryTipsGameConstraint, new Page());
		for(TipsGameConstraint constraint:list){
			Map<String,String> gameMap=new HashMap<String,String>();
			gameMap.put("gameid", constraint.getGameId());
			GameServers gs=getGameServer(constraint.getGameId(),constraint.getFenQuNum());
			gameMap.put("serverid", constraint.getFenQuNum()<=0?"*":gs.getServerId());
			gameList.add(gameMap);
		}
		return gameList;
	}
	private String getSkinSrcNo(String skinNo){
		TipsSkin tipsSkin=FacadeFactory.INSTANCE.getBaseSo().findById(TipsSkin.class, skinNo);
		return tipsSkin==null?"":tipsSkin.getSkinSrcNo();
	}
}
