package com.xunlei.niux.manager.template.builder.pay;

import com.xunlei.niux.data.vipgame.facade.FacadeFactory;
import com.xunlei.niux.data.vipgame.vo.GamePayInfo;
import com.xunlei.niux.data.vipgame.vo.Games;
import com.xunlei.niux.data.vipgame.vo.HtmlTemplate;
import com.xunlei.niux.data.vipgame.vo.TemplateSchema;
import com.xunlei.niux.manager.template.builder.AbstractTemplateBuilder;
import com.xunlei.niux.manager.web.util.FreemarkerUtil;
import org.apache.log4j.Logger;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author hezhong
 */
public class ActPayBuilder extends AbstractTemplateBuilder {
    private static final SimpleDateFormat sdf=new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    private static final Logger logger = Logger.getLogger(ActPayBuilder.class);

    @Override
    public void executeShcema() throws Exception {
        String gameId = this.schema.getExt1();

        executeById(gameId);
    }


    private void executeById(String gameId) {
        List<GamePayInfo> list = FacadeFactory.INSTANCE.getGamePayInfoBo().find(new GamePayInfo(), 0, 0);

        GamePayInfo gamePayInfo = null;
        for(GamePayInfo g : list) {
            if(g.getGameid().equals(gameId)) {
                
                Games query = new Games();
                query.setGameId(g.getGameid());
                Games game = FacadeFactory.INSTANCE.getBaseSo().findObject(query);
                if(game != null){
                    g.setSimpleName(game.getSimpleName()==null?"":game.getSimpleName());
                    g.setRunType(game.getRunType()==null?"0":game.getRunType());
                }else {
                    g.setSimpleName("");
                    g.setRunType("0");
                }
                
                gamePayInfo = g;
                
                break;
            }
        }

        if (gamePayInfo == null) {
            logger.error("游戏支付信息id：" + gameId + "没有有效的数据");
            throw new RuntimeException("游戏支付信息id：" + gameId + "没有有效的数据");
        }

        Map<String, Object> root = new HashMap<String, Object>();
        root.put("gamePayInfos", list);


        String tempPath = htmlTemplate.getTemplateroot();

        String htmlFilePath = isPreView ? htmlTemplate.getPreviewhtmlroot() : htmlTemplate.getHtmlroot() ;
        if(!htmlFilePath.endsWith("/")) {
            htmlFilePath = htmlFilePath + "/";
        }

        //生成JS
        FreemarkerUtil.buildHtml(tempPath, "config.ftl", root, htmlFilePath + "js/config", "baseConfig.js");

        root = new HashMap<String, Object>();
        root.put("gameno", gamePayInfo.getGameno());


        String gamePath = gamePayInfo.getGamepath();
        htmlFilePath = htmlFilePath + gamePath;

        String templateFileName = "act_index.ftl";
        String htmlFileName = "index.html";

        //生成页面
        FreemarkerUtil.buildHtml(tempPath, templateFileName, root, htmlFilePath, htmlFileName);
    }

    @Override
    public void addTeamplateSchema(HtmlTemplate ht, boolean isPreview) {

        List<GamePayInfo> list = FacadeFactory.INSTANCE.getGamePayInfoBo().find(new GamePayInfo(), 0, 0);

        for (GamePayInfo gamePayInfo : list) {
            String nowStr=sdf.format(new Date());
            //添加执行计划
            TemplateSchema ts=new TemplateSchema();
            ts.setTemplateid(ht.getTemplateid());
            ts.setSchematime(nowStr);
            ts.setIsexecuted(false);
            ts.setInputby("系统");
            ts.setInputtime(nowStr);
            ts.setIspreview(isPreview);
            ts.setExt1(gamePayInfo.getGameid());

            FacadeFactory.INSTANCE.getTemplateSchemaBo().insert(ts);
        }

    }
}
