package com.xunlei.niux.manager.template.builder.niuofficial3_0;

import com.ferret.common.dao.enums.OrderType;
import com.ferret.common.dao.vo.Page;
import com.xunlei.httptool.util.JsonObjectUtil;
import com.xunlei.niux.data.activity.dto.ActivityDTO;
import com.xunlei.niux.data.vipgame.facade.FacadeFactory;
import com.xunlei.niux.data.vipgame.vo.BonusProduct;
import com.xunlei.niux.data.vipgame.vo.GameServers;
import com.xunlei.niux.data.vipgame.vo.Games;
import com.xunlei.niux.data.vipgame.vo.LinkInfo;
import com.xunlei.niux.data.vipgame.vo.bonus.AuctionProduct;
import com.xunlei.niux.manager.constant.LinkLocationIdConstant;
import com.xunlei.niux.manager.web.cache.GameCache;
import com.xunlei.niux.manager.web.util.FileUploadUtil;
import com.xunlei.niux.manager.web.util.FileUtil;
import com.xunlei.niux.manager.web.util.FreemarkerUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

import java.io.File;
import java.net.URLEncoder;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.*;


public class UserCenterPageBuilder{

    private static final Logger logger=Logger.getLogger(UserCenterPageBuilder.class.getName());

    private String rootPath;
    private String htmlPath;
    private boolean isPreView;

    public UserCenterPageBuilder(String rootPath, String htmlPath,boolean isPreView) {
        this.rootPath = rootPath+"u/";
        this.htmlPath = htmlPath+"u/";
        this.isPreView = isPreView;
    }

    public void build() throws Exception {
        logger.info("=====开始生成我的地盘的推荐活动=====");
        buildMyArea();
        logger.info("=====我的地盘的推荐活动生成完毕=====");
        logger.info("=====开始生成我的地盘所有游戏js=====");
        buildAllGame();
        logger.info("=====我的地盘所有游戏js生成完毕=====");
    }

    /**
     * 生成我的地盘数据
     */
    private void buildMyArea(){

        Map<String,Object> rootMap=new HashMap<String,Object>();

        rootMap.put("productList",getBonusProductList());
        rootMap.put("gameList",getGameList());
//        rootMap.put("jifenActivityRcmd",getScoreActivityList());
        rootMap.put("actBonusMap",getJiFenAct());
//        rootMap.put("auctionList", getAuctionList());
        rootMap.put("recActList",getRecommendActList());
        FreemarkerUtil.buildHtml(rootPath, "index.html", rootMap, htmlPath, "index.html");
        FreemarkerUtil.buildHtml(rootPath, "jifen.html", rootMap, htmlPath, "jifen.html");
//        FreemarkerUtil.buildHtml(rootPath, "rebate.html", rootMap, htmlPath, "rebate.html");

//      zzfw/index.html，zzfw/qq.html, zzfw/repair.html, zzfw/service.html,  zzfw/stolen.html
        FreemarkerUtil.buildHtml(rootPath+"zzfw/", "index.html", rootMap, htmlPath+"zzfw/", "index.html");
        FreemarkerUtil.buildHtml(rootPath+"zzfw/", "qq.html", rootMap, htmlPath+"zzfw/", "qq.html");
        FreemarkerUtil.buildHtml(rootPath+"zzfw/", "repair.html", rootMap, htmlPath+"zzfw/", "repair.html");
        FreemarkerUtil.buildHtml(rootPath+"zzfw/", "service.html", rootMap, htmlPath+"zzfw/", "service.html");
        FreemarkerUtil.buildHtml(rootPath+"zzfw/", "stolen.html", rootMap, htmlPath+"zzfw/", "stolen.html");

    }

    private List<Map<String,Object>> getRecommendActList(){

        List<Map<String,Object>> resultList = new ArrayList<Map<String, Object>>();
        List<ActivityDTO> activityDTOList = com.xunlei.niux.data.activity.facade.FacadeFactory.INSTANCE.getActivityBo().getActivityPhotoInfoList("userCenter",10);

        if(CollectionUtils.isEmpty(activityDTOList)){
            return resultList;
        }


        for(ActivityDTO dto : activityDTOList){
            Map<String,Object> map = new HashMap<String, Object>();
            map.put("title",dto.getTitle()==null?"":dto.getTitle());
            map.put("img",dto.getPhoto()==null?"":dto.getPhoto());
            map.put("link",dto.getLinkUrl()==null?"":dto.getLinkUrl());
            map.put("content",dto.getActDesc()==null?"":dto.getActDesc());

            Calendar startCal = getTimeCalendar(dto.getStarttime());
            map.put("startTime",startCal==null?"":(startCal.get(Calendar.MONTH)+1)+"月"+startCal.get(Calendar.DAY_OF_MONTH)+"日");
            Calendar endCal = getTimeCalendar(dto.getEndtime());
            map.put("endTime",endCal==null?"":(endCal.get(Calendar.MONTH)+1)+"月"+endCal.get(Calendar.DAY_OF_MONTH)+"日");
            resultList.add(map);
        }

        return  resultList;
    }

    private Calendar getTimeCalendar(String timeStr){
        if(StringUtils.isEmpty(timeStr)){
            return null;
        }
        DateFormat sdf_time = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date dateTime = null;
        try {
            dateTime = sdf_time.parse(timeStr);
        } catch (ParseException e) {
            logger.error("getTimeCalendar time Parse Exception:",e);
            return null;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(dateTime);

        return calendar;
    }

    /**
     * 生成我的地盘所有游戏js
     */
    private void buildAllGame() throws Exception{
        //生成我的地盘所有游戏js
        String jsonStr= JsonObjectUtil.getDataJsonObject(getAllGame());
        jsonStr="var ACT_GAME_RECOMMEND="+jsonStr+";";
        File file= FileUtil.createFile(htmlPath + "/gamedata/", "gamerecommendact.js");
        FileUploadUtil.write(file, jsonStr);
    }

    /**
     * 获得我的地盘3个推荐游戏
     * @return
     */
    public List<Map<String,Object>> getGameList(){
        List<Map<String,Object>> templist=new ArrayList<Map<String,Object>>();
        List<LinkInfo> lilist= FacadeFactory.INSTANCE.getLinkInfoBo().getValidteLinkInfoListByLinkLocId_V2(LinkLocationIdConstant.NIUX_MYAREA_TUJIANGAME, 3, false, -1);
        if(lilist == null||lilist.size()==0)return null;
        List<Games> gamesList = GameCache.getInstance().getAllGames();
        GameServers qgs=new GameServers();
        for(LinkInfo li:lilist){
            String gameid = li.getGameidbytuijian();
            for(Games game:gamesList){
                if(gameid.trim().equals(game.getGameId().trim())){
                    qgs.setGameId(li.getGameidbytuijian());
                    qgs.setFenQuNum(Integer.valueOf(li.getExt1()));
                    List<GameServers> gsList=FacadeFactory.INSTANCE.getGameServersBo().find(qgs, new Page());
                    if(gsList==null||gsList.size()==0){
                        continue;
                    }
                    GameServers gs=gsList.get(0);
                    Map<String,Object> map=new HashMap<String,Object>();
                    map.put("gameName", game.getGameName());
                    map.put("gameNo", game.getGameNo());
                    map.put("photo",li.getPicurl());
                    map.put("url",li.getLinkurl());
                    LinkInfo linf = new LinkInfo();
                    linf.setLinklocid(LinkLocationIdConstant.NIUX_MYAREA_ACT_RECOMMEND);
                    linf.setGameidbytuijian(gameid);
                    List<LinkInfo> ll = FacadeFactory.INSTANCE.getLinkInfoBo().find(linf);
                    String content = "";
                    String acturl = "";
                    if(ll != null && ll.size()>0){
                        LinkInfo myinfo = ll.get(0);
                        if(myinfo != null){
                            content = myinfo.getLinktitle();
                            acturl = myinfo.getLinkurl();
                        }
                    }

                    map.put("content",content);
                    map.put("acturl",acturl);
                    map.put("gameBBSUrl", game.getForumUrl());
                    map.put("gameOfficialUrl",game.getOfficialWebSite());
                    map.put("gameServerName",gs.getFenQuName());
                    map.put("gameServerId",gs.getFenQuNum());
                    templist.add(map);
                }
            }

        }
        return templist;
    }


    /**
     * 更新我的游戏缓存
     */
    public Map<String,Object> getAllGame2() throws Exception{
        LinkInfo info = new LinkInfo();
        info.setLinklocid("227");
        //获得我的地盘所有推荐游戏
        List<LinkInfo> gamelist = FacadeFactory.INSTANCE.getLinkInfoBo().find(info);
        if(gamelist == null||gamelist.size()==0)return null;
        LinkInfo actinfo = new LinkInfo();
        actinfo.setLinklocid("228");
        //获得我的地盘所有游戏的推荐活动
        List<LinkInfo> actlist =  FacadeFactory.INSTANCE.getLinkInfoBo().find(actinfo);

        LinkInfo photoinfo = new LinkInfo();
        photoinfo.setLinklocid("232");
        //获得我的地盘所有游戏推荐的图片
        List<LinkInfo> photolist =  FacadeFactory.INSTANCE.getLinkInfoBo().find(photoinfo);
        Map<String,Object> map = new LinkedHashMap<String,Object>();
        for(LinkInfo game:gamelist){
            String gameid = game.getGameidbytuijian().trim();
            Games games = FacadeFactory.INSTANCE.getGamesBo().getGameByGameId(gameid);
            Map<String,Object> data = new HashMap<String,Object>();

            for(LinkInfo act:actlist){
                if(act.getGameidbytuijian().trim().equals(gameid)){
                    //data.put("gameName", URLEncoder.encode(games.getGameName(),"utf8"));
                    data.put("title", URLEncoder.encode(act.getLinktitle(), "utf8"));
                    data.put("url", act.getLinkurl());
                    //data.put("gameOfficialUrl", games.getOfficialWebSite());
                    String photourl = "";
                    for(LinkInfo photo:photolist){
                        if(photo.getGameidbytuijian().trim().equals(gameid)){
                            photourl = photo.getPicurl();
                        }
                    }
                    data.put("photo", photourl);
                }
            }

            map.put(games.getGameNo(), data);
        }
        return map;
    }


    /**
     * 更新我的游戏缓存
     */
    public Map<String,Object> getAllGame() throws Exception{
//		LinkInfo info = new LinkInfo();
//		info.setLinklocid("227");
//		//获得我的地盘所有推荐游戏
//		List<LinkInfo> gamelist = FacadeFactory.INSTANCE.getLinkInfoBo().find(info);
//		if(gamelist == null||gamelist.size()==0)return null;
        LinkInfo actinfo = new LinkInfo();
        actinfo.setLinklocid("228");
        //获得我的地盘所有游戏的推荐活动
        List<LinkInfo> actlist =  FacadeFactory.INSTANCE.getLinkInfoBo().find(actinfo);

        LinkInfo photoinfo = new LinkInfo();
        photoinfo.setLinklocid("232");
        //获得我的地盘所有游戏推荐的图片
        List<LinkInfo> photolist =  FacadeFactory.INSTANCE.getLinkInfoBo().find(photoinfo);
        Map<String,Object> map = new LinkedHashMap<String,Object>();

        for(LinkInfo photo:photolist){
            Map<String,Object> data = new HashMap<String,Object>();
            String gameid = photo.getGameidbytuijian().trim();
            for(LinkInfo act:actlist){
                if(act.getGameidbytuijian().trim().equals(gameid)){
                    data.put("title",act.getLinktitle()==null?"": URLEncoder.encode(act.getLinktitle(),"utf8"));
                    data.put("url", act.getLinkurl()==null?"":act.getLinkurl());
                }

            }
            data.put("photo", photo.getPicurl());
            Games games = GameCache.getInstance().getGameByGameId(gameid);
            map.put(games.getGameNo(), data);

        }

        return map;
    }

    /**
     * 获得我的地盘推荐活动
     * @return
     */
    public List<Map<String,Object>> getActivityList(){
        List<Map<String,Object>> templist=new ArrayList<Map<String,Object>>();
        List<LinkInfo> lilist=FacadeFactory.INSTANCE.getLinkInfoBo().getValidteLinkInfoListByLinkLocId_V2(LinkLocationIdConstant.NIUX_MYAREA_ACT_RECOMMEND, 3, false);
        if(lilist == null||lilist.size()==0)return null;
        for(LinkInfo li:lilist){
            Games game = FacadeFactory.INSTANCE.getGamesBo().getGameByGameId(li.getGameidbytuijian().trim());
            if(game == null)continue;
            Map<String,Object> map=new HashMap<String,Object>();
            map.put("gameLogo", li.getPicurl());
            map.put("cartoonImg", li.getExt2());
            map.put("gameName", game.getGameName());
            map.put("url", li.getLinkurl());
            map.put("peopleNumber", li.getExt2());
            templist.add(map);
        }
        return templist;
    }


    /**
     * 获得我的地盘获得积分活动
     * @return
     */
    public Map<String,Object> getScoreActivityList(){
        Map<String,Object> map=new HashMap<String,Object>();
        List<LinkInfo> lilist=FacadeFactory.INSTANCE.getLinkInfoBo().getValidteLinkInfoListByLinkLocId_V2(LinkLocationIdConstant.NIUX_MYAREA_GETSCORE, 1, false);
        if(lilist == null||lilist.size()==0)return null;
        LinkInfo info = lilist.get(0);
        map.put("url", info.getLinkurl());
        map.put("title", info.getLinktitle());
        return map;
    }

    /**
     * 获得积分兑换奖品列表
     * @return
     */
    public List<Map<String,Object>> getBonusProductList(){
        List<Map<String,Object>> templist=new ArrayList<Map<String,Object>>();
        LinkInfo linkinfo = new LinkInfo();
        Page page = new Page();
        page.addOrder("validdatetime", OrderType.DESC);
        linkinfo.setLinklocid(LinkLocationIdConstant.NIUX_OFFICIAL_AWARDPRODUCT);
        List<LinkInfo> lilist=FacadeFactory.INSTANCE.getLinkInfoBo().find(linkinfo,page);
        //getValidteLinkInfoListByLinkLocId(LinkLocationIdConstant.NIUX_OFFICIAL_AWARDPRODUCT, 8, isPreView);
        if(lilist == null||lilist.size()==0)return null;
        for(LinkInfo li:lilist){
            Map<String,Object> map=new HashMap<String,Object>();
            map.put("photo", li.getPicurl());
            map.put("url", li.getLinkurl());
            BonusProduct product = FacadeFactory.INSTANCE.getBonusProductBo().findBonusProductById(Long.parseLong(li.getLinktitle()));
            map.put("vipPrice", product.getVipPrice());
            map.put("price", product.getPrice());
            map.put("pid", product.getSeqId());
            map.put("productNo", product.getProductNo());
            map.put("productName", product.getProductName());
            map.put("minGameLevel", product.getMinGameLevel());
            map.put("giveOutType", product.getGiveOutType()==null?"":product.getGiveOutType());
            map.put("isSelectServer", (product.getIsQuFenServer()!=null&&product.getIsQuFenServer())?"1":"0");
            map.put("isSelectRole", (product.getIsSelectRole()!=null&&product.getIsSelectRole())?"1":"0");
            map.put("gameId", product.getGameId()==null?"":product.getGameId());
            map.put("gameName",getGameName(product.getGameId()));
            map.put("exchangeDirect", product.getExchangeDirect()==null?"":product.getExchangeDirect());
            templist.add(map);
        }
        return templist;
    }

    /**
     * 获得我的游戏图片
     * @return
     */
    private List<Map<String,Object>> getBigPhoto(){
        List<Map<String,Object>> result = new ArrayList<Map<String,Object>>();
        List<LinkInfo> lilist=FacadeFactory.INSTANCE.getLinkInfoBo().getValidteLinkInfoListByLinkLocId_V2(LinkLocationIdConstant.NIUX_ACT_LUNBO, 3, false);
        if(lilist == null||lilist.size()==0)return null;
        for(LinkInfo info:lilist){
            Map<String,Object> map = new HashMap<String,Object>();
            map.put("title", info.getLinktitle());
            map.put("content", info.getLinkdesc());
            map.put("url", info.getLinkurl());
            map.put("img", info.getPicurl());
            result.add(map);
        }
        return result;
    }


    /**
     * 我的地盘积分攻略参与活动
     */
    private Map<String,Object> getJiFenAct(){
        List<LinkInfo> lilist=FacadeFactory.INSTANCE.getLinkInfoBo().getValidteLinkInfoListByLinkLocId_V2(LinkLocationIdConstant.NIUX_MYAREA_JFFENACT, 1, false);
        if(lilist == null||lilist.size()==0)return null;
        LinkInfo info = lilist.get(0);
        Map<String,Object> map = new HashMap<String,Object>();
        map.put("title", info.getLinktitle());
        map.put("url", info.getLinkurl());
        return map;
    }
    private static String getGameName(String gameId){
        if(gameId==null||"".equals(gameId)){
            return "";
        }
        Games query=new Games();
        query.setGameId(gameId);
        Page page=new Page();
        List<Games> list=FacadeFactory.INSTANCE.getGamesBo().findGames(query, page);
        return (list==null||list.size()==0)?"":list.get(0).getGameName();
    }
    private List<Map<String,Object>> getAuctionList(){
        List<Map<String,Object>> list=new ArrayList<Map<String,Object>>();
        AuctionProduct query=new AuctionProduct();
        query.setIsDisplay(true);
        Page page=new Page();
        page.addOrder("displaySort", OrderType.ESC);
        List<AuctionProduct> apList=FacadeFactory.INSTANCE.getAuctionProductBo().finds(query, page);
        apList=apList==null?new ArrayList<AuctionProduct>():apList;
        for(AuctionProduct product:apList){
            Map<String,Object> map=new HashMap<String,Object>();
            map.put("auctionProductId", product.getAuctionProductId());
            map.put("photo", product.getPicUrl()==null?"":product.getPicUrl());
            map.put("saleNum", product.getAuctionProductNum());
            map.put("basePrice", product.getBaseBonusNum());
            map.put("gridPrice", product.getOneAddBonusNum());
            map.put("beginTime", product.getStartAuctionTime()==null?"":product.getStartAuctionTime());
            map.put("endTime", product.getEndAuctionTime()==null?"":product.getEndAuctionTime());
            list.add(map);
        }
        return list;
    }
}
