package com.xunlei.niux.manager.template.builder.niuofficial3_0;

import java.io.File;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.apache.log4j.Logger;

import com.ferret.common.dao.enums.OrderType;
import com.ferret.common.dao.vo.Page;
import com.xunlei.common.facade.IFacadeCommon;
import com.xunlei.common.util.DatetimeUtil;
import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import com.xunlei.gamepay.facade.IFacade;
import com.xunlei.gamepay.vo.ChargeDayend;
import com.xunlei.httptool.util.JsonObjectUtil;
import com.xunlei.niux.data.vipgame.facade.FacadeFactory;
import com.xunlei.niux.data.vipgame.vo.GameServers;
import com.xunlei.niux.data.vipgame.vo.Games;
import com.xunlei.niux.data.vipgame.vo.LinkInfo;
import com.xunlei.niux.gameoffical.template.v2.builder.DataUtil;
import com.xunlei.niux.manager.constant.LinkLocationIdConstant;
import com.xunlei.niux.manager.template.builder.AbstractTemplateBuilder;
import com.xunlei.niux.manager.template.builder.niuoffical.GameServerBuilder;
import com.xunlei.niux.manager.web.cache.GameCache;
import com.xunlei.niux.manager.web.util.DateUtil;
import com.xunlei.niux.manager.web.util.FileUploadUtil;
import com.xunlei.niux.manager.web.util.FileUtil;
import com.xunlei.niux.manager.web.util.FreemarkerUtil;
import com.xunlei.util.StringTools;

/**
 * Created by jamesjxin on 14-6-24.
 */
public class OpenServerPageBuilder extends AbstractTemplateBuilder {

    private boolean ispreview=false;
    private static final Logger logger = Logger.getLogger(OpenServerPageBuilder.class);
    private static boolean isCreateIncomeamt = false;
    private static String dataStr  ="";


    public void executeShcema() throws Exception {
        buildGameServer();//生成牛x官网开服列表
        buildGameServerJs();//生成盒子开服列表js文件
        bulidBoxNewGameServerJs();//生成盒子最新开服列表js

    	bulidBoxNewTenGameServerJs();//生成最新游戏列表js（里面的信息为区服信息）
    	bulidBoxIncomeamtTopTenGamesJs();//生成营收额最高的10款游戏
    	
    }


    /**
     * 开服列表
     */
    private void buildGameServer()  throws Exception {
        Map<String, Object> rootMap = new HashMap<String, Object>();
        GameServerBuilder gsb = new GameServerBuilder();

        rootMap.put("newGameServerList", gsb.getNewPreviewGameServer());
        rootMap.put("oldGameServerList", gsb.getNewOldGameServer());

        //生成JS文件
        markJs("latest_and_coming_servers",gsb.getLatestAndComingOneGameServer());

        String root = htmlTemplate.getTemplateroot();
        String roothtml = getHtmlRoot();
//        String rootPath = "/Users/jamesjxin/Work/XL工作目录/20140607牛x官网3.0/模版/templatefiles";
//        String htmlPath = "/Users/jamesjxin/Work/XL工作目录/20140607牛x官网3.0/模版/output";
//        String root=rootPath;
//        String roothtml= htmlPath;
        FreemarkerUtil.buildHtml(root, "openservice.html", rootMap, roothtml,
                "openservice.html");
    }

    private void markJs(String jsName, Object jsonObject) throws Exception{
        String jsonStr = JsonObjectUtil.getDataJsonObject(jsonObject);
        jsonStr = jsName+" = "+jsonStr+";";
        String niuOfficialJsPath = IFacadeCommon.INSTANCE.getLibconfigValueByConfigNo("niuOfficialJsPath");
        if (niuOfficialJsPath.endsWith("/")) {
            niuOfficialJsPath = niuOfficialJsPath.substring(0, niuOfficialJsPath.length() - 1);
        }

        File file = FileUtil.createFile(niuOfficialJsPath + "/gamedata/", jsName+".js");
        FileUploadUtil.write(file, jsonStr);
    }

    /**
     * 旧版盒子用的开服列表
     * @throws Exception
     */
    private void buildGameServerJs() throws Exception{
        String jsonStr = JsonObjectUtil.getDataJsonObject(getGameServerJs());
        jsonStr = "latest_server_list = "+jsonStr+";";
//        String htmlFilePath = isPreView ? htmlTemplate.getPreviewhtmlroot()
//                : htmlTemplate.getHtmlroot();
//        String htmlFilePath= "/Users/jamesjxin/Work/XL工作目录/20140607牛x官网3.0/模版/output";

        String niuOfficialJsPath = IFacadeCommon.INSTANCE.getLibconfigValueByConfigNo("niuOfficialJsPath");
        if (niuOfficialJsPath.endsWith("/")) {
            niuOfficialJsPath = niuOfficialJsPath.substring(0, niuOfficialJsPath.length() - 1);
        }

        File file = FileUtil.createFile(niuOfficialJsPath + "/gamedata/", "lastestgameserver.js");
        FileUploadUtil.write(file, jsonStr);
    }

    /**
     * 新版盒子用的开服列表
     * @throws Exception
     */
    private void bulidBoxNewGameServerJs() throws Exception{
        String jsonStr = JsonObjectUtil.getDataJsonObject(getTomorrowLatestEreaList());
        jsonStr = "latest_server_list = "+jsonStr+";";
//        String htmlFilePath = isPreView ? htmlTemplate.getPreviewhtmlroot()
//                : htmlTemplate.getHtmlroot();
//        String htmlFilePath= "/Users/jamesjxin/Work/XL工作目录/20140607牛x官网3.0/模版/output";

        String niuOfficialJsPath = IFacadeCommon.INSTANCE.getLibconfigValueByConfigNo("niuOfficialJsPath");
        if (niuOfficialJsPath.endsWith("/")) {
            niuOfficialJsPath = niuOfficialJsPath.substring(0, niuOfficialJsPath.length() - 1);
        }

        File file = FileUtil.createFile(niuOfficialJsPath + "/gamedata/","newlastestgameserver.js");
        FileUploadUtil.write(file, jsonStr);
    }

    /**
     * 获得明天的最新开服列表
     * @return
     */
    private List<Map<String,Object>> getTomorrowLatestEreaList(){
    	  List<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
		    String pattern = "yyyy-MM-dd";
	        Calendar calendar = Calendar.getInstance();
	        Date today = calendar.getTime();
	        String todayStr = DateUtil.format(today, pattern);
	        
	        calendar.add(Calendar.DAY_OF_YEAR,1);
	        Date tomorrow = calendar.getTime();
	        String tomorrowStr = DateUtil.format(tomorrow,pattern);

	        List<GameServers> tomorrowServersList = FacadeFactory.INSTANCE.getGameServersBo()
	                .getNewOpenServersByFromDateAndToDate(todayStr,tomorrowStr,false);
	        for(GameServers server:tomorrowServersList){		
	        	Games game=GameCache.getInstance().getGameByGameId(server.getGameId());
	        	//获取logo图片
				LinkInfo logoli=FacadeFactory.INSTANCE.getLinkInfoBo().getGameValidteLinkInfoByLinkLocId(LinkLocationIdConstant.GAME_LOGO,game.getGameId(), ispreview);           				
				Map<String,Object> map=new HashMap<String,Object>();
				String opentime = server.getOpenTime();
				map.put("sid", server.getSeqId());
				map.put("serverid", server.getServerId());
				map.put("openTime", opentime);
				map.put("gameName", game.getGameName());
				map.put("gameno", game.getGameNo());
				map.put("gameid", game.getGameId());
				map.put("officialurl",game.getOfficialWebSite());
				map.put("fenQuNum", server.getFenQuNum());
				map.put("clientType", game.getLoadClientType()==null?"0":game.getLoadClientType()+"");
				map.put("picurl", logoli==null?"":logoli.getPicurl());
				result.add(map);
	        }
	        return result;
    }



    /**
     * 获得开服列表的json数据
     * @return
     */
    private List<Map<String,Object>> getGameServerJs(){
        List<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
	    String pattern = "yyyy-MM-dd";
        Calendar calendar = Calendar.getInstance();
        Date today = calendar.getTime();
        String todayStr = DateUtil.format(today, pattern);	        
        calendar.add(Calendar.DAY_OF_YEAR,1);
        Date tomorrow = calendar.getTime();
        String tomorrowStr = DateUtil.format(tomorrow,pattern);

        List<GameServers> tomorrowServersList = FacadeFactory.INSTANCE.getGameServersBo()
                .getNewOpenServersByFromDateAndToDate(todayStr,tomorrowStr,false);
        boolean flag = true;
        int jj = 0;
        for(GameServers server:tomorrowServersList){		
        	if(flag){
        		Games game = GameCache.getInstance().getGameByGameId(server.getGameId());
        		//获取logo图片
				LinkInfo logoli=FacadeFactory.INSTANCE.getLinkInfoBo().getGameValidteLinkInfoByLinkLocId(LinkLocationIdConstant.GAME_LOGO, game.getGameId(), ispreview);               					
				Map<String,Object> map=new HashMap<String,Object>();
				String opentime = server.getOpenTime();
				map.put("openTime", opentime);
				map.put("gameName", game.getGameName());
				map.put("gameno", game.getGameNo());
				map.put("gameid", game.getGameId());
				map.put("officialurl",game.getOfficialWebSite());
				map.put("fenQuNum", server.getFenQuNum());
				map.put("clientType", game.getLoadClientType()==null?"0":game.getLoadClientType()+"");
				map.put("picurl", logoli==null?"":logoli.getPicurl());
				result.add(map);
				jj ++;
				if(jj>=20){
					flag = false;
					break;//取其中20条记录
				}
        	}
        }
        return result;
    }


    /**
     * 获得开服预告
     * @return
     */
    public List<Map<String, Object>> getPreviewGameServer() {
        logger.info("开始获取开服预告");
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        SimpleDateFormat sdf2 = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Calendar cal = Calendar.getInstance();
        String fromtime = sdf2.format(cal.getTime());//当前时间
        cal.add(Calendar.DAY_OF_MONTH, 1);
        //String fromtime = sdf.format(cal.getTime());
        cal.add(Calendar.DAY_OF_MONTH, 1);//生效时间是后一天
        String totime = sdf.format(cal.getTime());
        logger.info("fromtime============>" + fromtime);
        logger.info("totime============>" + totime);
        List<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        LinkInfo linkInfo = new LinkInfo();
        linkInfo.setLinklocid("1240");
        Page page = new Page();
        page.addOrder("validdatetime", OrderType.DESC);
        List<LinkInfo> list = FacadeFactory.INSTANCE.getLinkInfoBo().find(
                linkInfo, page);
        if(list == null||list.size()==0)return result;
        //取得游戏集合
        Games games = new Games();
        List<Games> gamesList = FacadeFactory.INSTANCE.getGamesBo().findGames(
                games, 0, 0);

        //取得游戏区服集合
        GameServers qgs = new GameServers();
        qgs.setFromopentime(fromtime);
        qgs.setToopentime(totime + " 00:00:00");
        Page page1 = new Page();
        page1.addOrder("openTime", OrderType.DESC);
        List<GameServers> serverList = FacadeFactory.INSTANCE
                .getGameServersBo().find(qgs, page1);

        //取得新手卡集合
        LinkInfo cardinfo = new LinkInfo();
        cardinfo.setLinklocid("233");
        List<LinkInfo> cardList = FacadeFactory.INSTANCE.getLinkInfoBo().find(
                cardinfo);
        for (GameServers server : serverList) {
            //游戏分区
            for (LinkInfo info : list) {
                String gameid = info.getGameidbytuijian().trim();//获得游戏id
                if (server.getGameId().trim().equals(gameid)
                        && (server.getFenQuNum() + "").equals(info.getExt1()
                        .trim())) {//如果最新开服的游戏，在游戏列表中
                    Map<String, Object> map = new HashMap<String, Object>();
                    for (Games game : gamesList) {//取得游戏相关信息
                        if (game.getGameId().trim().equals(gameid)) {
                            map.put("gameName", game.getGameName());
                            map.put("gameNo", game.getGameNo());
                            map.put("gameOfficialUrl", game
                                    .getOfficialWebSite());
                            String url = "";
                            for (LinkInfo card : cardList) {
                                if (card.getGameidbytuijian().trim().equals(
                                        gameid.trim())) {
                                    url = card.getLinkurl();
                                }
                            }
                            map.put("newCardUrl", url);
                            map.put("serverId", (server.getFenQuNum() + ""));
                            map.put("serverName", server.getFenQuName());
                            map.put("date", server.getOpenTime());
                            result.add(map);
                        }
                    }
                }
            }
        }
        return result;
    }

    /**
     * 获得今日和历史开服记录
     * @return
     */
    public List<List<Map<String, Object>>> getGameServer() {
        int pagesize = 15;
        logger.info("开始获取今日和历史开服记录");
        List<List<Map<String, Object>>> returndata = new ArrayList<List<Map<String, Object>>>();
        List<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        SimpleDateFormat sdf2 = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Calendar cal = Calendar.getInstance();
        String totime = sdf2.format(cal.getTime());
        cal.add(Calendar.DAY_OF_MONTH, 1);//结束时间是明天
        //String totime = sdf.format(cal.getTime());
        cal.add(Calendar.DAY_OF_MONTH, -8);//开始时间是100年前
        String fromtime = sdf.format(cal.getTime());
        logger.info("fromtime============>" + fromtime);
        logger.info("totime============>" + totime);
        LinkInfo linkInfo = new LinkInfo();
        linkInfo.setLinklocid("1240");
        Page page = new Page();
        page.addOrder("validdatetime", OrderType.DESC);
        List<LinkInfo> list = FacadeFactory.INSTANCE.getLinkInfoBo().find(
                linkInfo, page);
        if(list == null||list.size()==0)return null;
        //取得游戏集合
        Games games = new Games();
        List<Games> gamesList = FacadeFactory.INSTANCE.getGamesBo().findGames(
                games, 0, 0);

        //取得游戏区服集合
        GameServers qgs = new GameServers();
        qgs.setFromopentime(fromtime + " 00:00:00");
        qgs.setToopentime(totime);
        Page page1 = new Page();
        page1.addOrder("openTime", OrderType.DESC);
        List<GameServers> serverList = FacadeFactory.INSTANCE
                .getGameServersBo().find(qgs, page1);

        //取得新手卡集合
        LinkInfo cardinfo = new LinkInfo();
        cardinfo.setLinklocid("233");//按照开服时间逆序
        List<LinkInfo> cardList = FacadeFactory.INSTANCE.getLinkInfoBo().find(
                cardinfo);
        for (GameServers server : serverList) {
            //游戏分区
            for (LinkInfo info : list) {
                String gameid = info.getGameidbytuijian().trim();//获得游戏id
                if (server.getGameId().trim().equals(gameid)
                        && (server.getFenQuNum() + "").equals(info.getExt1()
                        .trim())) {//如果最新开服的游戏，在游戏列表中
                    Map<String, Object> map = new HashMap<String, Object>();
                    for (Games game : gamesList) {//取得游戏相关信息
                        if (game.getGameId().trim().equals(gameid)) {
                            map.put("gameName", game.getGameName());
                            map.put("gameNo", game.getGameNo());
                            map.put("gameOfficialUrl", game
                                    .getOfficialWebSite());
                            String url = "";
                            for (LinkInfo card : cardList) {
                                if (card.getGameidbytuijian().trim().equals(
                                        gameid.trim())) {
                                    url = card.getLinkurl();
                                }
                            }
                            map.put("newCardUrl", url);
                            map.put("serverId", (server.getFenQuNum() + ""));
                            map.put("serverName", server.getFenQuName());
                            map.put("date", server.getOpenTime());
                            result.add(map);
                        }
                    }
                }
            }
        }
        String now = sdf.format(new Date());
        now = now + " 00:00:00";
        int index = 0;
        for (int i = 0; i < result.size(); i++) {
            Map<String, Object> data = result.get(i);
            String time = (String) (data.get("date"));
            if (compareTime(now, time) > 0) {
                index = i;
                break;
            }
        }

        List<Map<String, Object>> alists = new ArrayList<Map<String, Object>>();
        for (int i = 0; i < result.size(); i++) {
            Map<String, Object> data = result.get(i);
            if (index == 0) {
                data.put("isLastToday", "0");
                alists.add(data);
            } else {
                if (i == index - 1) {
                    data.put("isLastToday", "1");
                    alists.add(data);
                } else {
                    data.put("isLastToday", "0");
                    alists.add(data);
                }
            }
        }
        int j = 0;
        List<Map<String, Object>> templist = null;
        for (int i = 0; i < alists.size(); i++) {
            if (i % pagesize == 0) {
                templist = new ArrayList<Map<String, Object>>();
            }
            templist.add(alists.get(i));
            j++;
            if (j == pagesize || (alists.size()-i<pagesize &&j == alists.size()%pagesize)) {
                returndata.add(templist);
                j = 0;
            }
        }
        return returndata;
    }

    /**
     * 比较两个时间相隔多少秒
     * @param time1
     * @param time2
     * @return
     */
    public long compareTime(String time1, String time2) {
        DateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date d1 = null;
        Date d2 = null;
        try {
            d1 = df.parse(time1);
            d2 = df.parse(time2);
        } catch (ParseException e) {
            e.printStackTrace();
        }
        long diff = d1.getTime() - d2.getTime();
        return diff / 1000;
    }
    
    
    /**
     * 新版盒子最新的十款游戏
     * @throws Exception
     */
    private void bulidBoxNewTenGameServerJs() throws Exception{
        String jsonStr = JsonObjectUtil.getDataJsonObject(getNewTenGamesList());
        jsonStr = "var NEW_GAME_RANK_LIST = "+jsonStr+";";

        String niuOfficialJsPath = IFacadeCommon.INSTANCE.getLibconfigValueByConfigNo("niuOfficialJsPath");
        if (niuOfficialJsPath.endsWith("/")) {
            niuOfficialJsPath = niuOfficialJsPath.substring(0, niuOfficialJsPath.length() - 1);
        }
        
        File file = FileUtil.createFile(niuOfficialJsPath + "/gamedata/","new_game_rank_list.js");
        FileUploadUtil.write(file, jsonStr);
    }
    
   
    
    /**
     * @return 获得最新的10款游戏按照时间逆序排列
     */
    private List<Map<String,Object>> getNewTenGamesList(){
    	  List<Map<String, Object>> result = new ArrayList<Map<String, Object>>();

	      List<GameServers> tomorrowServersList = FacadeFactory.INSTANCE.getGameServersBo().getNewGamesList();
	      GameCache instance = GameCache.getInstance();
	        for(GameServers server:tomorrowServersList){		
	        	Games game=instance.getGameByGameId(server.getGameId());
	        	//获取logo图片
				LinkInfo logoli=FacadeFactory.INSTANCE.getLinkInfoBo().getGameValidteLinkInfoByLinkLocId(LinkLocationIdConstant.GAME_LOGO,game.getGameId(), ispreview);           				
				Map<String,Object> map=new HashMap<String,Object>();
				String opentime = server.getOpenTime();
				map.put("sid", server.getSeqId());
				map.put("serverid", server.getServerId());
				map.put("openTime", opentime);
				map.put("gameName", game.getGameName());
				map.put("gameno", game.getGameNo());
				map.put("gameid", game.getGameId());
				map.put("officialurl",game.getOfficialWebSite());
				map.put("fenQuNum", server.getFenQuNum());
				map.put("clientType", game.getLoadClientType()==null?"0":game.getLoadClientType()+"");
				map.put("picurl", logoli==null?"":logoli.getPicurl());
				result.add(map);
	        }
	        return result;
    }
    
    
    
    /**
     * 新版盒子最新的十款游戏
     * @throws Exception
     */
    private void bulidBoxIncomeamtTopTenGamesJs() throws Exception{
    	String formatDay = DatetimeUtil.formatDay(new Date());
    	if(dataStr.equals(formatDay)){
    		return ;
    	}

    	List<Map<String, Object>> result = getTopTenChargeDayEnd();
    	
    	if(result==null||result.size()==0){
    		return ;
    	}
    	
    	dataStr = formatDay;
        String jsonStr = JsonObjectUtil.getDataJsonObject(result);
        jsonStr = "var COMPREHENSIVE_GAME_RANK_LIST = "+jsonStr+";";

        String niuOfficialJsPath = IFacadeCommon.INSTANCE.getLibconfigValueByConfigNo("niuOfficialJsPath");
        if (niuOfficialJsPath.endsWith("/")) {
            niuOfficialJsPath = niuOfficialJsPath.substring(0, niuOfficialJsPath.length() - 1);
        }
        
        File file = FileUtil.createFile(niuOfficialJsPath + "/gamedata/","comprehensive_game_rank_list.js");
        FileUploadUtil.write(file, jsonStr);
    }
    
    private  List<Map<String,Object>>  getTopTenChargeDayEnd(){
    	List<Map<String,Object>> result = new ArrayList<Map<String,Object>>(10);
    	
    	List<ChargeDayend> allChargeDayend = getAllChargeDayEnd();
    	
    	 GameCache instance = GameCache.getInstance();
    	
    	if(null==allChargeDayend||allChargeDayend.isEmpty())
    		return result;
    	
    	for(ChargeDayend dayend : allChargeDayend){
    		String gameid = dayend.getGameid();
    		gameid = "0"+gameid;
    		Games dto = instance.getGameByGameId(gameid);
    		if(dto!=null&&(dto.getClientType().intValue()==0||dto.getClientType().intValue()==1)){
    			Map<String , Object> map = new HashMap<String, Object>();
    			map.put("gameName", dto.getGameName());
    			map.put("gameNo", dto.getGameNo());
    			map.put("gameId", dto.getGameId());
    			map.put("bgImg", dto.getPicUrl()==null?"":dto.getPicUrl());
    			map.put("gameOfficialUrl", dto.getOfficialWebSite());
    			map.put("isNew", dto.getIsNew()?1:0);
    			map.put("isHot", dto.getIsHot()?1:0);
    			map.put("recommendIndex", dto.getRecommendIndex());
    			map.put("gameTypeId", dto.getGameType());
    			map.put("gameFeatureId", dto.getGameFeature());
    			map.put("difficultyId", dto.getPlayLevel());
    			String simpleName = dto.getSimpleName();
    			if(StringTools.isEmpty(simpleName)){
    				simpleName = simpleName.substring(0,1);
    				simpleName = simpleName.toUpperCase();
    			}
    			map.put("aleph", simpleName);
    			
    			//营收额
    			map.put("incomeamt", dayend.getIncomeamt());
	            result.add(map);
    		}
    		
    		if(result.size()==10){
    			break;
    		}
    	}
    	
    	return result;
    }
    
    
    private List<ChargeDayend> getAllChargeDayEnd(){
    	IFacade instance = IFacade.INSTANCE;
    	ChargeDayend chargeDayend = new ChargeDayend();
    	chargeDayend.setDsname("3");
    	chargeDayend.setFromday(DatetimeUtil.addDate(DatetimeUtil.today(), "D", -1));
    	chargeDayend.setToday(DatetimeUtil.today());
    	
    	PagedFliper fliper = new PagedFliper();
    	fliper.setSortColumn(" incomeamt desc");
    	fliper.setPageSize(-1);
    	Sheet<ChargeDayend> sheet = instance.queryChargeDayend(chargeDayend, fliper);
    	List<ChargeDayend> queryChargeDayends = (List<ChargeDayend>) sheet.getDatas();
    	return queryChargeDayends;
    }
    
}
