package com.xunlei.niux.manager.template.builder.niuofficial3_0;

import com.xunlei.niux.data.activity.dto.ActivityDTO;
import com.xunlei.niux.data.activity.facade.FacadeFactory;
import com.xunlei.niux.manager.web.util.FreemarkerUtil;
import org.apache.commons.collections.CollectionUtils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * Created by jamesjxin on 14-6-24.
 */
public class ActivityPageBuilder {

    private String rootPath;
    private String htmlPath;
    private boolean isPreView;

    public ActivityPageBuilder(String rootPath, String htmlPath, boolean isPreView) {
        this.rootPath = rootPath;
        this.htmlPath = htmlPath;
        this.isPreView = isPreView;
    }

    public void build(){
        Map<String,Object> rootMap = new HashMap<String, Object>();
        rootMap.put("bannerList",getActivityList());

        FreemarkerUtil.buildHtml(rootPath, "activity.html", rootMap, htmlPath, "activity.html");
    }

    private List<Map<String,Object>> getActivityList(){
        List<Map<String,Object>> resultList = new ArrayList<Map<String, Object>>();
        List<ActivityDTO> activityDTOList = FacadeFactory.INSTANCE.getActivityBo().getActivityPhotoInfoList("activity");

        if(CollectionUtils.isEmpty(activityDTOList)){
            return resultList;
        }

        for(ActivityDTO dto : activityDTOList){
            Map<String,Object> map = new HashMap<String, Object>();
            map.put("title",dto.getTitle()==null?"":dto.getTitle());
            map.put("pic",dto.getPhoto()==null?"":dto.getPhoto());
            map.put("url",dto.getLinkUrl()==null?"":dto.getLinkUrl());
            resultList.add(map);
        }

        return  resultList;
    }
}
