package com.xunlei.niux.manager.template.builder.niuoffical.indexbuilderthread;

import com.xunlei.niux.data.vipgame.facade.FacadeFactory;
import com.xunlei.niux.data.vipgame.vo.GameServers;
import com.xunlei.niux.data.vipgame.vo.Games;
import com.xunlei.niux.data.vipgame.vo.LinkInfo;
import com.xunlei.niux.manager.constant.LinkLocationIdConstant;
import com.xunlei.niux.manager.web.cache.GameCache;
import com.xunlei.niux.manager.web.util.FreemarkerUtil;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;

/**
 * Created by jamesjxin on 14-7-31.
 */
public class BuildUserCardThread implements Callable {

    private String tempPath;
    private String htmlFilePath;
    private boolean isPreview;

    public BuildUserCardThread(String tempPath, String htmlFilePath, boolean isPreview) {
        this.tempPath = tempPath;
        this.htmlFilePath = htmlFilePath;
        this.isPreview = isPreview;
    }

    @Override
    public Object call() throws Exception {
        buildUserCard();
        return "";
    }

    /**
     * 新手卡列表
     */
    private void buildUserCard() {
        Map<String, Object> rootMap = new HashMap<String, Object>();
        rootMap.put("latestplaygamesideadvdata", getLatestPlayGameSideAdv());
        rootMap.put("newCardList", getNewCardBoxList());

        //				        String root = "d:/tmp/office";
        //				        String roothtml = "d:/tmp/offical";
        FreemarkerUtil.buildHtml(tempPath, "side_playedGame.html", rootMap,
                htmlFilePath + "/include/", "side_playedGame.html");

    }

    /**
     * 最近玩过的游戏旁广告
     * @return
     */
    private Map<String, Object> getLatestPlayGameSideAdv() {
        Map<String, Object> map = new HashMap<String, Object>();
        //获取广告
        LinkInfo li = FacadeFactory.INSTANCE
                .getLinkInfoBo()
                .getValidteLinkInfoByLinkLocId(
                        LinkLocationIdConstant.NIUX_COMMON_GAMEADV,
                        isPreview);
        if (li == null) {
            return null;
        }
        //获取游戏信息
        Games g = GameCache.getInstance().getGameByGameId(li.getGameidbytuijian());//FacadeFactory.INSTANCE.getGamesBo().getGameByGameId(li.getGameidbytuijian());
        if(g == null)return null;
        //获取最新开区
        GameServers gstemp = FacadeFactory.INSTANCE
                .getGameServersBo()
                .getLatestGameServerByGameId(li.getGameidbytuijian(), isPreview);
        if (g == null || gstemp == null) {
            return null;
        }
        map.put("gameName", g.getGameName());
        map.put("serverId", gstemp.getFenQuNum());
        map.put("gameNo", g.getGameNo());
        map.put("gameOfficialUrl", g.getOfficialWebSite());
        return map;
    }

    public List<Map<String, Object>> getNewCardBoxList() {
        List<Map<String, Object>> templist = new ArrayList<Map<String, Object>>();
        LinkInfo info = new LinkInfo();
        info.setLinklocid(LinkLocationIdConstant.NIUX_OFFICIAL_NEWCARD);
        List<LinkInfo> lilist = FacadeFactory.INSTANCE.getLinkInfoBo().find(
                info);
        if(lilist == null || lilist.size()==0)return null;
        for (LinkInfo ll : lilist) {
            String gameid = ll.getGameidbytuijian().trim();
            Games games = GameCache.getInstance().getGameByGameId(gameid);
            Map<String, Object> m = new HashMap<String, Object>();
            m.put("gameName", games.getGameName());
            m.put("newCardUrl", ll.getLinkurl());
            templist.add(m);
        }
        return templist;
    }
}
