package com.xunlei.niux.manager.template.builder.niuoffical.indexbuilderthread;

import com.ferret.common.dao.enums.OrderType;
import com.ferret.common.dao.vo.Page;
import com.xunlei.common.util.StringTools;
import com.xunlei.common.vo.LibClassD;
import com.xunlei.common.vo.LibClassM;
import com.xunlei.niux.data.vipgame.facade.FacadeFactory;
import com.xunlei.niux.data.vipgame.vo.GameCategory;
import com.xunlei.niux.data.vipgame.vo.GameServers;
import com.xunlei.niux.data.vipgame.vo.Games;
import com.xunlei.niux.data.vipgame.vo.LinkInfo;
import com.xunlei.niux.manager.constant.LinkLocationIdConstant;
import com.xunlei.niux.manager.web.cache.GameCache;
import com.xunlei.niux.manager.web.util.FreemarkerUtil;

import java.util.*;
import java.util.concurrent.Callable;

/**
 * Created by jamesjxin on 14-7-31.
 */
public class BuildIndexThread implements Callable{
    private static final String ENTERURL = "http://niu.xunlei.com/entergame/";

    private String tempPath;
    private String htmlFilePath;
    private boolean isPreview;

    public BuildIndexThread(String tempPath, String htmlFilePath, boolean isPreview) {
        this.tempPath = tempPath;
        this.htmlFilePath = htmlFilePath;
        this.isPreview = isPreview;
    }

    @Override
    public Object call() throws Exception {
        buildIndex();
        return "";
    }

    /**
     * 生成官网主页
     */
    private void buildIndex() {
        Map<String, Object> rootMap = new HashMap<String, Object>();
        rootMap.put("sliderImgList", getLunBoList());
        rootMap.put("hotServiceList", getHotServiceList());
        rootMap.put("recommendedList", getRecommendedList());
        rootMap.put("noticeadvdata", getNoticeAdv());
        List<Map<String, Object>> gameCategoryList = getGameCategoryList();
        rootMap.put("gameTypeList", gameCategoryList);
        rootMap.put("activityList", getActivityList());
        rootMap.put("noticeList", getNoticeList());
        Map<String, Object> gameMap = new LinkedHashMap<String, Object>();
        gameMap.put("100", getAllGameList());
        for (Map<String, Object> gameType : gameCategoryList) {
            String type = (String) (gameType.get("typeId"));
            if(!"100".equals(type))
                gameMap.put(type, getGameList(type));
        }
        Map<String,Object> laMuMap=getLaMuAdv();
        if(laMuMap!=null){
            rootMap.put("bigTopAd", laMuMap);
        }
        Map<String,Object> coupletAd = getCoupletAd();
        if(coupletAd!=null){
            rootMap.put("coupletAd",coupletAd);
        }
        rootMap.put("gameMap", gameMap);

        FreemarkerUtil.buildHtml(tempPath, "index.html", rootMap, htmlFilePath,
                "index.html");
    }

    /**
     * 获取轮播图信息
     * @return
     */
    public List<Map<String, Object>> getLunBoList() {
        List<Map<String, Object>> templist = new ArrayList<Map<String, Object>>();
        LinkInfo info = new LinkInfo();
        info.setLinklocid(LinkLocationIdConstant.NIUX_ACT_ACTIONPHOTO);
        Page page = new Page();
        page.setPageNo(1);//第一页
        page.setPageSize(6);//只取前6个
        page.addOrder("displayorder", OrderType.DESC);//按照降序排
        page.addOrder("validdatetime", OrderType.DESC);//生效时间
        List<LinkInfo> lilist = FacadeFactory.INSTANCE.getLinkInfoBo().find(info, page);
        if(lilist == null||lilist.size()==0)return null;
        for (LinkInfo li : lilist) {
            Map<String, Object> map = new HashMap<String, Object>();
            map.put("title", li.getLinktitle());
            map.put("bigImg", li.getPicurl());
            map.put("smallImg", li.getExt1());
            String gameid = li.getGameidbytuijian();
            if(!StringTools.isEmpty(gameid)){//如果选择了游戏，则取官网地址
                Games games = GameCache.getInstance().getGameByGameId(gameid);
                GameServers servers = new GameServers();
                servers.setGameId(gameid);
                servers.setOpenStatus("1");//已开区
                Page gspage = new Page();
                gspage.setPageNo(1);
                gspage.setPageSize(1);
                gspage.addOrder("openTime", OrderType.DESC);
                List<GameServers> gslist = FacadeFactory.INSTANCE.getGameServersBo().find(servers, gspage);
                if(gslist !=null&&gslist.size()>0){
                    GameServers gs = gslist.get(0);//最新区
                    map.put("url",ENTERURL+games.getGameNo()+"/?fenQuNum="+gs.getFenQuNum());
                }else{
                    map.put("url", li.getLinkurl());
                }
            }else{
                map.put("url", li.getLinkurl());
            }
            templist.add(map);
        }
        return templist;
    }

    /**
     * 获得火爆开服信息
     * @return
     */
    public List<Map<String, Object>> getHotServiceList() {
        List<Map<String, Object>> templist = new ArrayList<Map<String, Object>>();
        List<LinkInfo> lilist = FacadeFactory.INSTANCE.getLinkInfoBo()
                .getValidteLinkInfoListByLinkLocId(
                        LinkLocationIdConstant.NIUX_OFFICIAL_HOTAREA, 6,
                        isPreview);
        if(lilist == null||lilist.size()==0)return null;
        GameServers qgs = new GameServers();
        for (LinkInfo li : lilist) {
            Map<String, Object> map = new HashMap<String, Object>();
            map.put("bgImg", li.getPicurl());
//			Games game = FacadeFactory.INSTANCE.getGamesBo().getGameByGameId(
//					li.getGameidbytuijian().trim());
            Games game=GameCache.getInstance().getGameByGameId(li.getGameidbytuijian().trim());
            map.put("gameId", game.getGameNo());
            qgs.setGameId(li.getGameidbytuijian());
            qgs.setFenQuNum(Integer.valueOf(li.getExt1()));
            List<GameServers> gsList = FacadeFactory.INSTANCE
                    .getGameServersBo().find(qgs, new Page());
            if (gsList == null || gsList.size() == 0) {
                continue;
            }
            GameServers gs = gsList.get(0);
            map.put("gameOfficialUrl", game.getOfficialWebSite());
            map.put("gameName", game.getGameName());
            map.put("gameLogo", li.getExt2());
            map.put("gameServerId", li.getExt1());
            map.put("gameServerName", gs.getFenQuName());
            map.put("title", li.getExt3());//火爆开服的游戏可以自定义标题
            map.put("dateTime", getFormatDay(li.getValiddatetime()));
            templist.add(map);
        }
        return templist;

    }

    /**
     * 获得牛友推荐信息
     * @return
     */
    public List<Map<String, Object>> getRecommendedList() {
        List<Map<String, Object>> templist = new ArrayList<Map<String, Object>>();
        List<LinkInfo> lilist = FacadeFactory.INSTANCE.getLinkInfoBo()
                .getValidteLinkInfoListByLinkLocId(
                        LinkLocationIdConstant.NIUX_OFFICIAL_COMMONAREA, 6,
                        isPreview);
        if(lilist == null||lilist.size()==0)return null;
        GameServers qgs = new GameServers();
        Map<String, String> gameCategoryMap = getGameCategoryMap();
        for (LinkInfo li : lilist) {
            Map<String, Object> map = new HashMap<String, Object>();
            map.put("bgImg", li.getPicurl());
//			Games game = FacadeFactory.INSTANCE.getGamesBo().getGameByGameId(
//					li.getGameidbytuijian().trim());
            Games game=GameCache.getInstance().getGameByGameId(li.getGameidbytuijian());
            map.put("gameId", game.getGameNo());
            GameCategory gc = new GameCategory();
            gc.setGameid(li.getGameidbytuijian());
            qgs.setGameId(li.getGameidbytuijian());
            qgs.setFenQuNum(Integer.valueOf(li.getExt1()));
            List<GameServers> gsList = FacadeFactory.INSTANCE
                    .getGameServersBo().find(qgs, new Page());
            if (gsList == null || gsList.size() == 0) {
                continue;
            }
            GameServers gs = gsList.get(0);
            map.put("gameName", game.getGameName());
            map.put("gameOfficialUrl", game.getOfficialWebSite());
            map.put("gameType", (String) (gameCategoryMap.get(li.getExt3())));
            map.put("gameServerId", li.getExt1());
            map.put("gameServerName", gs.getServerName());
            map.put("content", li.getExt2());
            map.put("gameServerName", gs.getFenQuName());
            map.put("peopleNumber", li.getDisplayorder());
            map.put("dateTime", getFormatDay(li.getValiddatetime()));
            templist.add(map);
        }
        return templist;
    }

    /**
     * 获得首页广播消息
     * @return
     */
    public List<LinkInfo> getNoticeAdv() {
        List<LinkInfo> list = FacadeFactory.INSTANCE.getLinkInfoBo()
                .getValidteLinkInfoListByLinkLocId(
                        LinkLocationIdConstant.NIUX_COMMON_MESSAGE, 10,
                        isPreview);
        return list;
    }

    public List<Map<String, Object>> getGameCategoryList() {
        List<Map<String, Object>> gameTypeList = new ArrayList<Map<String, Object>>();
        List datas = LibClassM.getLibClassDList("gamecategory");
        Map<String, Object> map1 = new HashMap<String, Object>();
        map1.put("typeId", "100");
        map1.put("typeName", "全部游戏");
        gameTypeList.add(map1);
        for (int i = 0; i < datas.size(); i++) {
            Map<String, Object> map = new HashMap<String, Object>();
            map.put("typeId", ((LibClassD) datas.get(i)).getItemno().trim());
            map.put("typeName", ((LibClassD) datas.get(i)).getItemname());
            gameTypeList.add(map);
        }
        return gameTypeList;
    }

    /**
     * 获得首页推荐活动
     * @return
     */
    public List<Map<String, Object>> getActivityList() {
        List<Map<String, Object>> templist = new ArrayList<Map<String, Object>>();
        List<LinkInfo> lilist = FacadeFactory.INSTANCE
                .getLinkInfoBo()
                .getValidteLinkInfoListByLinkLocId(
                        LinkLocationIdConstant.NIUX_ACT_RECOMMEND, 3, isPreview);
        if(lilist == null||lilist.size()==0)return null;
        for (LinkInfo li : lilist) {
            Map<String, Object> map = new HashMap<String, Object>();
            map.put("gameLogo", li.getExt1());
            map.put("cartoonImg", li.getPicurl());
            map.put("title", li.getLinktitle()==null?"":li.getLinktitle());
//			Games game = FacadeFactory.INSTANCE.getGamesBo().getGameByGameId(
//					li.getGameidbytuijian().trim());
            Games game=GameCache.getInstance().getGameByGameId(li.getGameidbytuijian().trim());
            map.put("gameName", game.getGameName());
            map.put("url", li.getLinkurl());
            map.put("peopleNumber", li.getExt2());
            templist.add(map);
        }
        return templist;
    }

    /**
     * 获得首页广播消息
     * @return
     */
    public List<Map<String, Object>> getNoticeList() {
        List<Map<String, Object>> templist = new ArrayList<Map<String, Object>>();
        List<LinkInfo> lilist = FacadeFactory.INSTANCE.getLinkInfoBo()
                .getValidteLinkInfoListByLinkLocId(
                        LinkLocationIdConstant.NIUX_COMMON_MESSAGE, 10,
                        isPreview);
        if(lilist == null||lilist.size()==0)return null;
        for (LinkInfo li : lilist) {
            Map<String, Object> map = new HashMap<String, Object>();
            map.put("content", li.getLinktitle());
            map.put("url", li.getLinkurl());
            map.put("date", li.getValiddatetime() == null ? "" : li
                    .getValiddatetime().split(" ")[0]);
            templist.add(map);
        }
        return templist;
    }

    /**
     * 获得所有推荐游戏
     * @param
     * @return
     */
    public List<Map<String, Object>> getAllGameList() {
        List<Map<String, Object>> templist = new ArrayList<Map<String, Object>>();
        LinkInfo info = new LinkInfo();
        info.setLinklocid(LinkLocationIdConstant.NIUX_OFFICIAL_TUJIANGAME);
        Page page = new Page();
        page.addOrder("validdatetime", OrderType.DESC);//生效时间
        List<LinkInfo> lilist = FacadeFactory.INSTANCE.getLinkInfoBo().find(info, page);
        if(lilist == null||lilist.size()==0)return null;
//		Games games = new Games();
//		List<Games> gamesList = FacadeFactory.INSTANCE.getGamesBo().findGames(games, 0, 10000);
        List<Games> gamesList =GameCache.getInstance().getAllGames();
        for (LinkInfo li : lilist) {
            String gameid = li.getGameidbytuijian();
            for (Games game : gamesList) {
                if (gameid.trim().equals(game.getGameId().trim())) {
                    Map<String, Object> map = new HashMap<String, Object>();
                    map.put("gameId", game.getGameId());
                    map.put("gameName", game.getGameName());
                    map.put("gameOfficialUrl", game.getOfficialWebSite());
                    map.put("firstLetter", game.getSimpleName().substring(0,1)); //首字母
                    map.put("gameLogo", li.getPicurl());
                    templist.add(map);
                }
            }

        }
        return templist;
    }

    /**
     * 获得指定类型的所有推荐游戏
     * @return
     */
    public List<Map<String, Object>> getGameList(String type) {
        List<Map<String, Object>> templist = new ArrayList<Map<String, Object>>();
        LinkInfo info = new LinkInfo();
        info.setLinklocid(LinkLocationIdConstant.NIUX_OFFICIAL_TUJIANGAME);
        Page page = new Page();
        page.addOrder("validdatetime", OrderType.DESC);//生效时间
        List<LinkInfo> lilist = FacadeFactory.INSTANCE.getLinkInfoBo().find(info, page);
        if(lilist == null||lilist.size()==0)return null;
        Games games = new Games();
        games.setGameType(type);
        List<Games> gamesList = FacadeFactory.INSTANCE.getGamesBo().findGames(
                games, 0, 10000);
        for (LinkInfo li : lilist) {
            String gameid = li.getGameidbytuijian();
            for (Games game : gamesList) {
                if (gameid.trim().equals(game.getGameId().trim())) {
                    Map<String, Object> map = new HashMap<String, Object>();
                    map.put("gameId", game.getGameId());
                    map.put("gameName", game.getGameName());
                    map.put("firstLetter", game.getSimpleName().substring(0,1)); //首字母
                    map.put("gameOfficialUrl", game.getOfficialWebSite());
                    map.put("gameLogo", li.getPicurl());
                    templist.add(map);
                }
            }

        }
        return templist;
    }

    public Map<String,Object> getLaMuAdv(){
        LinkInfo li=FacadeFactory.INSTANCE.getLinkInfoBo().getValidteLinkInfoByLinkLocId_V2("619", isPreview);
        if(li==null){
            return null;
        }
        Map<String,Object> map=new HashMap<String,Object>();
        map.put("url", li.getLinkurl()==null?"":li.getLinkurl());
        map.put("img", li.getPicurl()==null?"":li.getPicurl());
        map.put("bgColor",li.getExt1()==null?"":li.getExt1());
        return map;
    }

    public Map<String,Object> getCoupletAd(){
        LinkInfo leftli=FacadeFactory.INSTANCE.getLinkInfoBo().getValidteLinkInfoByLinkLocId_V2("620", isPreview);
        LinkInfo rightli=FacadeFactory.INSTANCE.getLinkInfoBo().getValidteLinkInfoByLinkLocId_V2("621", isPreview);
        if(leftli == null ||rightli == null){
            return null;
        }
        String type = "img";
        if(leftli.getPicurl().endsWith(".swf")){
            type = "flash";
        }
        Map<String,Object> map=new HashMap<String,Object>();
        map.put("type",type);
        map.put("leftSrc", leftli.getPicurl()==null?"":leftli.getPicurl());
        map.put("leftUrl", leftli.getLinkurl()==null?"":leftli.getLinkurl());
        map.put("rightSrc", rightli.getPicurl()==null?"":rightli.getPicurl());
        map.put("rightUrl", rightli.getLinkurl()==null?"":rightli.getLinkurl());
        return map;
    }

    /**
     * 获得 MM.dd 格式的时间
     * @param time
     * @return
     */
    public String getFormatDay(String time) {
        time = time.split(" ")[0];
        time = time.substring(5);
        return time;
    }

    public Map<String, String> getGameCategoryMap() {
        Map<String, String> tempMap = new HashMap<String, String>();
        List datas = LibClassM.getLibClassDList("gamecategory");
        for (int i = 0; i < datas.size(); i++) {
            tempMap.put(((LibClassD) datas.get(i)).getItemno(),
                    ((LibClassD) datas.get(i)).getItemname());
        }
        return tempMap;
    }
}
