package com.xunlei.niux.manager.template.builder.niuoffical.indexbuilderthread;

import com.ferret.common.dao.enums.OrderType;
import com.ferret.common.dao.vo.Page;
import com.xunlei.common.util.StringTools;
import com.xunlei.common.vo.LibClassD;
import com.xunlei.common.vo.LibClassM;
import com.xunlei.niux.client.util.HttpClientUtil;
import com.xunlei.niux.data.vipgame.facade.FacadeFactory;
import com.xunlei.niux.data.vipgame.vo.Games;
import com.xunlei.niux.data.vipgame.vo.LinkInfo;
import com.xunlei.niux.manager.web.cache.GameCache;
import com.xunlei.niux.manager.web.util.FreemarkerUtil;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;

/**
 * Created by jamesjxin on 14-7-31.
 */
public class BuildGameGiftThread implements Callable{

    private String tempPath;
    private String htmlFilePath;
    private boolean isPreview;

    private Map<String,String> gameTypeMap;


    public BuildGameGiftThread(String tempPath, String htmlFilePath, boolean isPreview) {
        this.tempPath = tempPath;
        this.htmlFilePath = htmlFilePath;
        this.isPreview = isPreview;
        init();
    }

    private void init(){
        if(gameTypeMap == null){
            gameTypeMap = new HashMap<String,String>();
            List datas = LibClassM.getLibClassDList("gamecategory");
            for (int i = 0; i < datas.size(); i++) {
                gameTypeMap.put(( (LibClassD) datas.get(i)).getItemno().trim(), ((LibClassD) datas.get(i)).getItemname());
            }
        }
    }

    @Override
    public Object call() throws Exception {
        buildGameGift();
        return "";
    }

    /**
     * 游戏礼包
     */
    private void buildGameGift() {
        //        String root = "d:/tmp/office";
        //        String roothtml = "d:/tmp/offical";
        Map<String, Object> rootMap = new HashMap<String, Object>();
        //rootMap.put("title", get404PageTitle());
        rootMap.put("hotNewCardList", getGameHotGifts());
        rootMap.put("allNewCardList", getGameGifts());
        FreemarkerUtil.buildHtml(tempPath, "newcard.html", rootMap, htmlFilePath,
                "newcard.html");
    }

    /**
     * 获得游戏热门礼包
     * @return
     */
    private List<Map<String,Object>> getGameHotGifts(){
        List<Map<String,Object>> list = new ArrayList<Map<String,Object>>();
        LinkInfo info = new LinkInfo();
        info.setLinklocid("666");
        Page page = new Page();
        page.setPageNo(1);
        page.setPageSize(6);
        page.addOrder("displayorder", OrderType.DESC);
        page.addOrder("validdatetime", OrderType.DESC);
        List<LinkInfo> lilist = FacadeFactory.INSTANCE.getLinkInfoBo().find(info, page);

        for(LinkInfo link:lilist){
            if(StringTools.isEmpty(link.getExt1()))continue;
            Map<String,Object> map = new HashMap<String,Object>();
            LinkInfo mygift = FacadeFactory.INSTANCE.getLinkInfoBo().find(Integer.valueOf(link.getExt1()));
            if(mygift==null)continue;
            String gameid = mygift.getGameid();
            Games games = GameCache.getInstance().getGameByGameId(gameid);
            if(games == null)continue;
            map.put("giftId", link.getExt1());
            if(StringTools.isEmpty(link.getPicurl())){
                continue;
            }
            map.put("giftImg", link.getPicurl());
            map.put("gameId", games.getGameId());
            map.put("gameNo", games.getGameNo());
            map.put("giftDesc", mygift.getLinkdesc());
            map.put("gameName", games.getGameName());
            String simpleName = games.getSimpleName();
            simpleName = simpleName.substring(0,1);
            simpleName = simpleName.toUpperCase();
            map.put("gameFirstLetter", simpleName);
            map.put("gameType", gameTypeMap.get(games.getGameType()));
            list.add(map);
        }
        return list;
    }

    /**
     * 获得游戏礼包
     * @return
     */
    private List<Map<String,Object>>  getGameGifts(){
        List<Map<String,Object>> list = new ArrayList<Map<String,Object>>();
        LinkInfo info = new LinkInfo();
        info.setLinklocid("251");
        Page page = new Page();
        page.addOrder("validdatetime", OrderType.DESC);
        List<LinkInfo> lilist = FacadeFactory.INSTANCE.getLinkInfoBo().find(info, page);
        for(int i=(int)'A';i<'A'+26;i++){
            char ch = (char)i;
            for(LinkInfo link:lilist){
                String gameid = link.getGameid();
                Games games = GameCache.getInstance().getGameByGameId(gameid);
                if(games == null)continue;
                String simpleName = games.getSimpleName();
                simpleName = simpleName.substring(0,1);
                simpleName = simpleName.toUpperCase();
                if(simpleName.equalsIgnoreCase(""+ch)){
                    Map<String,Object> map = new HashMap<String,Object>();
                    map.put("giftId", link.getLinkid());
                    if(StringTools.isEmpty(link.getPicurl())){
                        continue;
                    }
                    map.put("giftImg", link.getPicurl());
                    map.put("gameId", games.getGameId());
                    map.put("gameNo", games.getGameNo());
                    map.put("giftDesc", link.getLinkdesc());
                    map.put("gameName", games.getGameName());
                    map.put("gameFirstLetter", simpleName);
                    map.put("gameType", gameTypeMap.get(games.getGameType()));
                    list.add(map);
                }
            }
        }

        return list;
    }
}
