package com.xunlei.niux.manager.template.builder.niuoffical.indexbuilderthread;

import com.ferret.common.dao.enums.OrderType;
import com.ferret.common.dao.vo.Page;
import com.xunlei.niux.data.vipgame.facade.FacadeFactory;
import com.xunlei.niux.data.vipgame.vo.Games;
import com.xunlei.niux.data.vipgame.vo.LinkInfo;
import com.xunlei.niux.data.vipgame.vo.SeoAdvice;
import com.xunlei.niux.manager.constant.LinkLocationIdConstant;
import com.xunlei.niux.manager.web.cache.GameCache;
import com.xunlei.niux.manager.web.util.FreemarkerUtil;
import org.apache.commons.collections.CollectionUtils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;

/**
 * Created by jamesjxin on 14-7-31.
 */
public class BuildFooterAnd404PageThread implements Callable{

    private String tempPath;
    private String htmlFilePath;
    private boolean isPreview;

    public BuildFooterAnd404PageThread(String tempPath, String htmlFilePath, boolean isPreview) {
        this.tempPath = tempPath;
        this.htmlFilePath = htmlFilePath;
        this.isPreview = isPreview;
    }

    @Override
    public Object call() throws Exception {
        buildFooter();
        build404Page();
        return "";
    }

    /**
     * 生成尾部文件
     */
    private void buildFooter() {
        Map<String, Object> rootMap = new HashMap<String, Object>();
        rootMap.put("friendLinkList", getFriendLink());
        rootMap.put("seoLinkList",getSEOLink());

        //String root = "d:/tmp/office";
        FreemarkerUtil.buildHtml(tempPath, "friendlink.html", rootMap, htmlFilePath
                + "/include/", "friendlink.html");
    }

    public List<Map<String, Object>> getFriendLink() {
        List<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        List<LinkInfo> llist = FacadeFactory.INSTANCE.getLinkInfoBo()
                .getValidteLinkInfoListByLinkLocId(
                        LinkLocationIdConstant.NIUX_COMMON_FRIENDLINK, 30,
                        isPreview);
        if(llist == null||llist.size()==0)return null;
        for (LinkInfo linkinfo : llist) {
            Map<String, Object> map = new HashMap<String, Object>();
            map.put("title", linkinfo.getLinktitle() == null ? "" : linkinfo
                    .getLinktitle());
            map.put("url", linkinfo.getLinkurl() == null ? "" : linkinfo
                    .getLinkurl());
            list.add(map);
        }
        return list;
    }

    public List<Map<String,Object>> getSEOLink(){
        List<Map<String,Object>> resultList = new ArrayList<Map<String,Object>>();
        List<SeoAdvice> seoAdviceList = FacadeFactory.INSTANCE.getSeoLinkBo().getValidLatestSEOLink(20);
        if(CollectionUtils.isEmpty(seoAdviceList)){
            return resultList;
        }

        for(SeoAdvice seoAdvice : seoAdviceList){
            Map<String,Object> map = new HashMap<String,Object>();
            map.put("title",seoAdvice.getTitle()==null?"":seoAdvice.getTitle());

            Games game= GameCache.getInstance().getGameByGameId(seoAdvice.getGameId());
            map.put("gameNo",game.getGameNo()==null?"":game.getGameNo());
            map.put("id",seoAdvice.getSeqid());
            resultList.add(map);
        }
        return resultList;
    }

    private void build404Page() {

        //        String root = "d:/tmp/office";
        //        String roothtml = "d:/tmp/offical";
        Map<String, Object> rootMap = new HashMap<String, Object>();
        //rootMap.put("title", get404PageTitle());
        rootMap.put("notFoundPageADList", get404PageGameList());
        FreemarkerUtil.buildHtml(tempPath, "404.html", rootMap, htmlFilePath,
                "404.html");
    }

    /**
     * 404页面游戏列表
     * @return
     */
    public List<Map<String,Object>> get404PageGameList(){
        List<Map<String, Object>> templist = new ArrayList<Map<String, Object>>();
        LinkInfo info = new LinkInfo();
        info.setLinklocid(LinkLocationIdConstant.NIUX_ACTIVITY_404PAGE);
        Page page = new Page();
        page.setPageNo(1);//第一页
        page.setPageSize(2);//只取前2个
        page.addOrder("displayorder", OrderType.DESC);//按照降序排
        page.addOrder("validdatetime", OrderType.DESC);//生效时间
        List<LinkInfo> lilist = FacadeFactory.INSTANCE.getLinkInfoBo().find(info, page);
        if(lilist == null||lilist.size()==0)return null;
        for (LinkInfo li : lilist) {
            Map<String, Object> map = new HashMap<String, Object>();
            map.put("title", li.getExt3());
            map.put("img", li.getPicurl());
            map.put("url", li.getLinkurl());
            templist.add(map);
        }
        return templist;
    }

    /**
     * 404页面游戏列表
     * @return
     */
    public Map<String,Object> get404PageTitle(){
        Map<String,Object> map = new HashMap<String,Object>();
        LinkInfo info = new LinkInfo();
        info.setLinklocid(LinkLocationIdConstant.NIUX_ACTIVITY_TITLE);
        info.setExt1("0001");
        Page page = new Page();
        List<LinkInfo> lilist = FacadeFactory.INSTANCE.getLinkInfoBo().find(info, page);
        if(lilist == null||lilist.size()==0)return null;
        LinkInfo linkino = lilist.get(0);
        map.put("title", linkino.getLinkcontents());
        return map;
    }
}
