package com.xunlei.niux.manager.template.builder.niuoffical.indexbuilderthread;

import com.xunlei.niux.client.util.HttpClientUtil;
import com.xunlei.niux.data.vipgame.facade.FacadeFactory;
import com.xunlei.niux.data.vipgame.vo.Advice;
import com.xunlei.niux.manager.template.builder.niuoffical.AdviceDetail;
import com.xunlei.niux.manager.web.util.FreemarkerUtil;
import org.apache.log4j.Logger;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;

/**
 * Created by jamesjxin on 14-7-31.
 */
public class BuildAdviceDetailThread implements Callable{
    private static final Logger logger = Logger.getLogger(BuildAdviceDetailThread.class);

    private String tempPath;
    private String htmlFilePath;
    private boolean isPreview;

    public BuildAdviceDetailThread(String tempPath, String htmlFilePath, boolean isPreview) {
        this.tempPath = tempPath;
        this.htmlFilePath = htmlFilePath;
        this.isPreview = isPreview;
    }

    @Override
    public Object call() throws Exception {
        buildAdviceDetail();
        return "";
    }

    /**
     * 公告列表
     */
    private void buildAdviceDetail() {
        List<AdviceDetail> result = getAdviceDetails();

        //        String root = "d:/tmp/office";
        //        String roothtml = "d:/tmp/offical";
        if(result == null || result.size()==0)return;
        for (AdviceDetail detail : result) {
            Map<String, Object> rootMap = new HashMap<String, Object>();
            rootMap.put("detail", detail);
            FreemarkerUtil.buildHtml(tempPath, "noticeDetail.html", rootMap,
                    htmlFilePath + "/notice/", detail.getId() + ".html");
        }
    }

    /**
     * 获得游戏类和平台类公告详情
     * @return
     */
    public List<AdviceDetail> getAdviceDetails() {
        String sql = "select * from advice where platformno in ('game','platform','activity') and adviceType in ('1','2','3') order by displayOrder asc";
        List<Advice> list = FacadeFactory.INSTANCE.getAdviceBo().executeQuery(
                Advice.class, sql, new ArrayList());
        if(list == null||list.size()==0)return null;
        List<AdviceDetail> result = new ArrayList<AdviceDetail>();
        logger
                .info("getAdviceDetails.size=====================>"
                        + list.size());

        for (Advice info : list) {
            AdviceDetail detail = new AdviceDetail();
            detail.setId(info.getSeqId());
            detail.setTitle(info.getTitle());
            detail.setContent(info.getContent());
            if(info.getPlatformno().equals("activity")){
                detail.setType("act");
            }else {
                detail.setType("gg");
            }
            result.add(detail);
        }

        return result;
    }
}
