package com.xunlei.niux.manager.template.builder.niuoffical.indexbuilderthread;

import com.xunlei.niux.data.vipgame.facade.FacadeFactory;
import com.xunlei.niux.data.vipgame.vo.Advice;
import com.xunlei.niux.data.vipgame.vo.Games;
import com.xunlei.niux.manager.web.cache.GameCache;
import com.xunlei.niux.manager.web.util.FreemarkerUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;

/**
 * Created by jamesjxin on 14-7-31.
 */
public class BuildAdviceAndActivityListThread implements Callable{
    private static final Logger logger = Logger.getLogger(BuildAdviceAndActivityListThread.class);

    private String tempPath;
    private String htmlFilePath;
    private boolean isPreview;

    public BuildAdviceAndActivityListThread(String tempPath, String htmlFilePath, boolean isPreview) {
        this.tempPath = tempPath;
        this.htmlFilePath = htmlFilePath;
        this.isPreview = isPreview;
    }

    @Override
    public Object call() throws Exception {
        buildAdviceAndActivityList();
        return "";
    }

    /**
     * 公告，活动列表
     */
    private void buildAdviceAndActivityList(){
        Map<String,List<Advice>> resultMap = getActivityAndActList();
        if(MapUtils.isEmpty(resultMap)){
            return;
        }
        List<Advice> activityList = resultMap.get("activity");
        List<Advice> adviceList = resultMap.get("advice");

        if(CollectionUtils.isNotEmpty(activityList)){
            buildAdviceListPages(activityList,"act");
        }
        if(CollectionUtils.isNotEmpty(adviceList)){
            buildAdviceListPages(adviceList,"gg");
        }
    }

    private Map<String,List<Advice>> getActivityAndActList(){
        Map<String,List<Advice>> resultMap = new HashMap<String, List<Advice>>();
        String sql = "select * from advice where platformno in ('game','platform','activity','gameact') and adviceType in ('1','2','3') order by displayOrder asc";
        List<Advice> list = FacadeFactory.INSTANCE.getAdviceBo().executeQuery(
                Advice.class, sql, new ArrayList());
        logger.info("getAdviceAdv.size=====================>" + list.size());

        if(CollectionUtils.isEmpty(list)){
            return resultMap;
        }

        List<Advice> activityList = new ArrayList<Advice>();
        List<Advice> adviceList = new ArrayList<Advice>();
        for(Advice advice : list){
            if(advice.getPlatformno().equals("activity")||advice.getPlatformno().equals("gameact")){
                activityList.add(advice);
            }else {
                adviceList.add(advice);
            }
        }

        resultMap.put("activity",activityList);
        resultMap.put("advice",adviceList);

        return resultMap;
    }

    private void buildAdviceListPages(List<Advice> adviceList,String noticeType){
        int pageSize = 20;
        int pageCount = 0;

        List<Advice> printList = new ArrayList<Advice>();
        if(CollectionUtils.isNotEmpty(adviceList)){
            int totalCount = adviceList.size();
            int pageIndex = 0;
            if(totalCount%pageSize == 0){
                pageCount = totalCount/pageSize;
            }else {
                pageCount = totalCount/pageSize + 1;
            }
            String path = "/notice/";
            if(noticeType.equals("act")){
                path += "alist/";
            }else if(noticeType.equals("gg")){
                path += "glist/";
            }
            int startindex = 0, endIndex = 0;
            for(int i=0;i<pageCount;i++){
                startindex = i*pageSize;
                endIndex = (((i+1)*pageSize) > totalCount) ? totalCount : ((i+1)*pageSize);
                printList = adviceList.subList(startindex,endIndex);

                Map<String, Object> rootMap = new HashMap<String, Object>();
                rootMap.put("noticeType",noticeType);
                rootMap.put("noticeList",getNoticeMapList(printList));
                rootMap.put("pageInfo", getPageInfoMap(pageCount,pageIndex+1));

//                String root = "/Users/jamesjxin/Work/XL工作目录/20131219官网1.2.2/模版/niuofficial/";
//                String roothtml = "/Users/jamesjxin/Work/XL工作目录/20131219官网1.2.2/模版/niuofficial/";
                pageIndex++;
                FreemarkerUtil.buildHtml(tempPath, "noticeList.html", rootMap,
                        htmlFilePath + path, String.valueOf(pageIndex) + ".html");
            }
        }
    }

    private List<Map<String,Object>> getNoticeMapList(List<Advice> adviceList){
        List<Map<String,Object>> resultList = new ArrayList<Map<String, Object>>();
        if(CollectionUtils.isEmpty(adviceList)){
            return resultList;
        }
        for(Advice advice : adviceList){
            Map<String,Object> map = new HashMap<String,Object>();
            String gameId = advice.getGameId();

            //游戏信息
            logger.info("gameid================>" + gameId);
//            Games game = FacadeFactory.INSTANCE.getGamesBo().getGameByGameId(
//                    gameId);
            Games game= GameCache.getInstance().getGameByGameId(gameId);
            map.put("gameName",game==null?"":game.getGameName());
            map.put("gameId",gameId);
            map.put("gameOfficialUrl",game==null?"":game.getOfficialWebSite());
            map.put("id",advice.getSeqId()==null?"":advice.getSeqId());
            map.put("title",advice.getTitle()==null?"":advice.getTitle());
            map.put("url",advice.getJumpUrl()==null?"":advice.getJumpUrl());
            map.put("date", StringUtils.isEmpty(advice.getPublishDate()) ? "" : advice.getPublishDate().substring(0, 10));

            resultList.add(map);
        }

        return resultList;
    }

    private Map<String,Integer> getPageInfoMap(int totalNum,int curPage){
        Map<String,Integer> map = new HashMap<String, Integer>();
        map.put("totalNum",totalNum);
        map.put("curPage",curPage);
        return map;
    }
}
