package com.xunlei.niux.manager.template.builder.niuoffical;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.apache.log4j.Logger;

import com.ferret.common.dao.enums.OrderType;
import com.ferret.common.dao.vo.Page;
import com.xunlei.niux.data.vipgame.facade.FacadeFactory;
import com.xunlei.niux.data.vipgame.vo.GameServers;
import com.xunlei.niux.data.vipgame.vo.Games;
import com.xunlei.niux.data.vipgame.vo.LinkInfo;
import com.xunlei.niux.manager.constant.LinkLocationIdConstant;
import com.xunlei.niux.manager.template.builder.AbstractTemplateBuilder;
import com.xunlei.niux.manager.web.util.FreemarkerUtil;

public class ServiceBuilder extends AbstractTemplateBuilder{
	private boolean ispreview=false;
	private static final Logger logger = Logger.getLogger(ServiceBuilder.class);
	
	public static void main(String args[]){
		try {
			new ServiceBuilder().executeShcema();
		} catch (Exception e) {
			e.printStackTrace();
		}
	}
	
	public void executeShcema() throws Exception {
		buildService();
	}
	 /**
	 * 生成最新开服列表
	 */
	private void buildService(){
		Map<String,Object> rootMap=new HashMap<String,Object>();
        rootMap.put("yesterdayServiceList", getYesterdayLatestEreaList());
        rootMap.put("todayServiceList", getTodayLatestEreaList());
        rootMap.put("tomorrowServiceList", getTomorrowLatestEreaList());
        String root = htmlTemplate.getTemplateroot();
        String roothtml = getHtmlRoot();
        //String root = "d:/tmp/office";
		FreemarkerUtil.buildHtml(root,"side_newServiceList.html", rootMap, roothtml+"/include/", "side_newServiceList.html");
	}
	
	/**
	 * 获得昨天的最新开服列表
	 * @return
	 */
	private List<Map<String,Object>> getYesterdayLatestEreaList(){
		SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
		Calendar cal = Calendar.getInstance();
		String today = sdf.format(cal.getTime());
		cal.add(Calendar.DAY_OF_MONTH, -1);	
		String yesterday = sdf.format(cal.getTime());
		
		LinkInfo linkInfo = new LinkInfo();
	    linkInfo.setLinklocid("1240");
	    Page page = new Page();
	    page.addOrder("validdatetime", OrderType.DESC);
	    List<LinkInfo> list = FacadeFactory.INSTANCE.getLinkInfoBo().find(linkInfo, page);
	    
		//游戏分区
		GameServers qgs=new GameServers();
		qgs.setFromopentime(yesterday+" 00:00:00");
		qgs.setToopentime(today+" 00:00:00");
		Page page1 = new Page();
		page1.addOrder("openTime", OrderType.DESC);
		List<GameServers> serverList=FacadeFactory.INSTANCE.getGameServersBo().find(qgs, new Page());
	    
		List<Map<String,Object>> result=new ArrayList<Map<String,Object>>();
		int jj = 0;
		for(GameServers server:serverList){		
			for(int i=0;i<list.size();i++){				
				LinkInfo li=list.get(i);
			    if(server.getGameId().trim().equals(li.getGameidbytuijian().trim())&&(server.getFenQuNum()+"").equals(li.getExt1().trim())){
			    	//获取logo图片
					LinkInfo logoli=FacadeFactory.INSTANCE.getLinkInfoBo().getGameValidteLinkInfoByLinkLocId(LinkLocationIdConstant.GAME_LOGO, li.getGameidbytuijian(), ispreview);
					//游戏信息
					Games game=FacadeFactory.INSTANCE.getGamesBo().getGameByGameId(li.getGameidbytuijian());	               
					
					Map<String,Object> map=new HashMap<String,Object>();
					map.put("time", formatTime(server.getOpenTime()));
					map.put("gameName", game.getGameName());
					map.put("gameId", game.getGameNo());
					map.put("gameOfficialUrl",game.getOfficialWebSite());
					map.put("gameServerId", server.getFenQuNum());
					map.put("gameServerName", server.getFenQuName());
					map.put("gameImg", logoli==null?"":logoli.getPicurl());
					result.add(map);
					jj ++;
					if(jj>=6)break;//取其中5条记录
			    }												
			}
		}
		
		return result;
	}
	
	/**
	 * 获得明天的最新开服列表
	 * @return
	 */
	private List<Map<String,Object>> getTomorrowLatestEreaList(){
		SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
		Calendar cal = Calendar.getInstance();
		cal.add(Calendar.DAY_OF_MONTH, 1);	
		String tomorrow = sdf.format(cal.getTime());
		cal.add(Calendar.DAY_OF_MONTH, 1);
		String after = sdf.format(cal.getTime());		
		
		LinkInfo linkInfo = new LinkInfo();
	    linkInfo.setLinklocid("1240");
	    Page page = new Page();
	    page.addOrder("validdatetime", OrderType.DESC);
	    List<LinkInfo> list = FacadeFactory.INSTANCE.getLinkInfoBo().find(linkInfo, page);
	    
		//游戏分区
		GameServers qgs=new GameServers();
		qgs.setFromopentime(tomorrow+" 00:00:00");
		qgs.setToopentime(after+" 00:00:00");
		Page page1 = new Page();
		page1.addOrder("openTime", OrderType.DESC);
		List<GameServers> serverList=FacadeFactory.INSTANCE.getGameServersBo().find(qgs, new Page());
	    
		List<Map<String,Object>> result=new ArrayList<Map<String,Object>>();
		int jj = 0;
		for(GameServers server:serverList){		
			for(int i=0;i<list.size();i++){
				
				LinkInfo li=list.get(i);
			    if(server.getGameId().trim().equals(li.getGameidbytuijian().trim())&&(server.getFenQuNum()+"").equals(li.getExt1().trim())){
			    	//获取logo图片
					LinkInfo logoli=FacadeFactory.INSTANCE.getLinkInfoBo().getGameValidteLinkInfoByLinkLocId(LinkLocationIdConstant.GAME_LOGO, li.getGameidbytuijian(), ispreview);
					//游戏信息
					Games game=FacadeFactory.INSTANCE.getGamesBo().getGameByGameId(li.getGameidbytuijian());
	               
					
					Map<String,Object> map=new HashMap<String,Object>();
					map.put("time", formatTime(server.getOpenTime()));
					map.put("gameName", game.getGameName());
					map.put("gameId", game.getGameNo());
					map.put("gameOfficialUrl",game.getOfficialWebSite());
					map.put("gameServerId", server.getFenQuNum());
					map.put("gameServerName", server.getFenQuName());
					map.put("gameImg", logoli==null?"":logoli.getPicurl());
					result.add(map);
					jj ++;
					if(jj>=6)break;//取其中5条记录
			    }												
			}
		}
		return result;
	}
	
	public String formatTime(String time){
		if(time == null)return "";
		if(time.length() == 19){
			time = time.split(" ")[0];
		}
		if(time.length() == 10){
			time = time.substring(5);
		}
		return time;
	}
	
	/**
	 * 获得今天的最新开服列表
	 * @return
	 */
	private List<Map<String,Object>> getTodayLatestEreaList(){
		SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
		Calendar cal = Calendar.getInstance();
		String today = sdf.format(cal.getTime());
		cal.add(Calendar.DAY_OF_MONTH, 1);	
		String tomorrow = sdf.format(cal.getTime());
		
		LinkInfo linkInfo = new LinkInfo();
	    linkInfo.setLinklocid("1240");
	    Page page = new Page();
	    page.addOrder("validdatetime", OrderType.DESC);
	    List<LinkInfo> list = FacadeFactory.INSTANCE.getLinkInfoBo().find(linkInfo, page);
	    
		//游戏分区
		GameServers qgs=new GameServers();
		qgs.setFromopentime(today+" 00:00:00");
		qgs.setToopentime(tomorrow+" 00:00:00");
		Page page1 = new Page();
		page1.addOrder("openTime", OrderType.DESC);
		List<GameServers> serverList=FacadeFactory.INSTANCE.getGameServersBo().find(qgs, new Page());
	    
		List<Map<String,Object>> result=new ArrayList<Map<String,Object>>();
		int jj = 0;
		for(GameServers server:serverList){		
			for(int i=0;i<list.size();i++){
				
				LinkInfo li=list.get(i);
			    if(server.getGameId().trim().equals(li.getGameidbytuijian().trim())&&(server.getFenQuNum()+"").equals(li.getExt1().trim())){
			    	//获取logo图片
					LinkInfo logoli=FacadeFactory.INSTANCE.getLinkInfoBo().getGameValidteLinkInfoByLinkLocId(LinkLocationIdConstant.GAME_LOGO, li.getGameidbytuijian(), ispreview);
					//游戏信息
					Games game=FacadeFactory.INSTANCE.getGamesBo().getGameByGameId(li.getGameidbytuijian());
	               					
					Map<String,Object> map=new HashMap<String,Object>();
					map.put("time", formatTime(server.getOpenTime()));
					map.put("gameName", game.getGameName());
					map.put("gameId", game.getGameNo());
					map.put("gameOfficialUrl",game.getOfficialWebSite());
					map.put("gameServerId", server.getFenQuNum());
					map.put("gameServerName", server.getFenQuName());
					map.put("gameImg", logoli==null?"":logoli.getPicurl());
					result.add(map);
					jj ++;
					if(jj>=6)break;//取其中5条记录
			    }												
			}
		}
		return result;
	}
}
