package com.xunlei.niux.manager.template.builder.niuoffical;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import com.ferret.common.dao.enums.OrderType;
import com.ferret.common.dao.vo.Page;
import com.xunlei.niux.data.vipgame.facade.FacadeFactory;
import com.xunlei.niux.data.vipgame.vo.Advice;
import com.xunlei.niux.data.vipgame.vo.Games;
import com.xunlei.niux.manager.template.builder.AbstractTemplateBuilder;
import com.xunlei.niux.manager.web.util.FreemarkerUtil;

public class OrderBuilder extends AbstractTemplateBuilder{
	private boolean ispreview=false;
	private static final Logger logger = Logger.getLogger(OrderBuilder.class);
	
	public static void main(String args[]){
		try {
			new OrderBuilder().executeShcema();
		} catch (Exception e) {
			e.printStackTrace();
		}
	}

	public void executeShcema() throws Exception {
		buildOrder();
	}
	 /**
	 * 生成充值中心数据
	 */
	private void buildOrder(){
		Map<String,Object> rootMap=new HashMap<String,Object>();
        rootMap.put("questionList", getOrderQuestionList());
        rootMap.put("gameMap", getGameMap());
        String root = htmlTemplate.getTemplateroot();
        String roothtml = getHtmlRoot();
//      String root = "d:/tmp/office";
//      String roothtml = "d:/tmp/offical";
		FreemarkerUtil.buildHtml(root,"order.html", rootMap, roothtml, "order.html");
	}
	
	/**
	 * 获得充值相关的问题
	 * @return
	 */
	private List<Map<String,Object>> getOrderQuestionList(){
		List<Map<String,Object>> result = new ArrayList<Map<String,Object>>();
		String sql = "select * from advice where platformno='question' and adviceType in ('1','2','3') order by displayOrder asc limit 0,10";
	    List<Advice> list = FacadeFactory.INSTANCE.getAdviceBo().executeQuery(Advice.class, sql, new ArrayList());
	    for(Advice info:list){
    		Map<String,Object> map = new HashMap<String,Object>();
    		map.put("title", info.getTitle());
    		map.put("url", info.getJumpUrl());
    		map.put("id", info.getSeqId());
    		result.add(map);
        }
		return result;
	}
	
	/**
	 * 获得对应游戏的列表
	 * @return
	 */
	private Map<String,Object> getGameMap(){
		Map<String,Object> result = new LinkedHashMap<String,Object>();
		Games games = new Games();
		games.setStatus("1");
		Page page = new Page();
		page.setPageNo(0);
		page.setPageSize(0);
		page.addOrder("simpleName", OrderType.ESC);//按照游戏缩写升序排列
		List<Games> gameList = FacadeFactory.INSTANCE.getGamesBo().findGames(games,page);
		if(gameList == null)return result;
		int len = gameList.size();	
//		int count = len%5==0?len/5:len/5+1;//9		
//		int j = 0;
//		int k = 0;
//		List<Map<String,Object>> list = null;
//		for(int i=0;i<len;i++){		
//			if(i==0) list = new ArrayList<Map<String,Object>>();
//			if(j == count){
//				j = 0;
//				k++;
//				switch(k){
//				   case 1:result.put("ABCDE", list);
//				          break;
//				   case 2:result.put("FGHIJ", list);
//			          break;
//				   case 3:result.put("KLMNO", list);
//			          break;
//				   case 4:result.put("PQRST", list);
//			          break;
//				}
//				list = new ArrayList<Map<String,Object>>();
//			}
//			Games game = gameList.get(i);
//			Map<String,Object> map = new HashMap<String,Object>();
//			map.put("gameId", game.getGameNo());
//			map.put("gameName", game.getGameName());
//			list.add(map);
//			if(i == len -1){
//				result.put("UVWXTZ", list);
//			}
//			j++;
//		}
		List<Map<String,Object>> alist = new ArrayList<Map<String,Object>>();
		List<Map<String,Object>> flist = new ArrayList<Map<String,Object>>();
		List<Map<String,Object>> mlist = new ArrayList<Map<String,Object>>();
		List<Map<String,Object>> rlist = new ArrayList<Map<String,Object>>();
		List<Map<String,Object>> wlist = new ArrayList<Map<String,Object>>();
		for(Games game:gameList){
			if(game.getClientType().intValue()==3)continue;
			String simpleName = game.getSimpleName();
			if(simpleName==null||"".equals(simpleName))continue;
			char name = simpleName.charAt(0);
			Map<String,Object> map = new HashMap<String,Object>();
			map.put("gameId", game.getGameNo());
			map.put("gameName", game.getGameName());
			switch(name){
			   case 'a':alist.add(map);break;
			   case 'A':alist.add(map);break;
			   case 'b':alist.add(map);break;
			   case 'B':alist.add(map);break;
			   case 'c':alist.add(map);break;
			   case 'C':alist.add(map);break;
			   case 'd':alist.add(map);break;
			   case 'D':alist.add(map);break;
			   case 'e':alist.add(map);break;
			   case 'E':alist.add(map);break;
			   case 'f':flist.add(map);break;
			   case 'F':flist.add(map);break;
			   case 'g':flist.add(map);break;
			   case 'G':flist.add(map);break;
			   case 'h':flist.add(map);break;
			   case 'H':flist.add(map);break;
			   case 'i':flist.add(map);break;
			   case 'I':flist.add(map);break;
			   case 'j':flist.add(map);break;
			   case 'J':flist.add(map);break;
			   case 'k':mlist.add(map);break;
			   case 'K':mlist.add(map);break;
			   case 'l':mlist.add(map);break;
			   case 'L':mlist.add(map);break;
			   case 'm':mlist.add(map);break;
			   case 'M':mlist.add(map);break;
			   case 'n':mlist.add(map);break;
			   case 'N':mlist.add(map);break;
			   case 'o':mlist.add(map);break;
			   case 'O':mlist.add(map);break;
			   case 'p':rlist.add(map);break;
			   case 'P':rlist.add(map);break;
			   case 'q':rlist.add(map);break;
			   case 'Q':rlist.add(map);break;
			   case 'r':rlist.add(map);break;
			   case 'R':rlist.add(map);break;
			   case 's':rlist.add(map);break;
			   case 'S':rlist.add(map);break;
			   case 't':rlist.add(map);break;
			   case 'T':rlist.add(map);break;
			   case 'u':wlist.add(map);break;
			   case 'U':wlist.add(map);break;
			   case 'v':wlist.add(map);break;
			   case 'V':wlist.add(map);break;
			   case 'w':wlist.add(map);break;
			   case 'W':wlist.add(map);break;
			   case 'x':wlist.add(map);break;
			   case 'X':wlist.add(map);break;
			   case 'y':wlist.add(map);break;
			   case 'Y':wlist.add(map);break;
			   case 'z':wlist.add(map);break;
			   case 'Z':wlist.add(map);break;
			}
		}
		result.put("ABCDE", alist);
		result.put("FGHIJ", flist);
		result.put("KLMNO", mlist);
		result.put("PQRST", rlist);
		result.put("UVWXYZ", wlist);
		return result;
	}
}
