package com.xunlei.niux.manager.template.builder.niuoffical;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import com.xunlei.niux.data.vipgame.facade.FacadeFactory;
import com.xunlei.niux.data.vipgame.vo.LinkInfo;
import com.xunlei.niux.manager.constant.LinkLocationIdConstant;
import com.xunlei.niux.manager.template.builder.AbstractTemplateBuilder;
import com.xunlei.niux.manager.web.util.FreemarkerUtil;

public class FooterBuilder extends AbstractTemplateBuilder{
	private boolean ispreview=false;
	
	public void executeShcema() throws Exception {
		buildFooter();
	}
	 /**
	 * 生成尾部文件
	 */
	private void buildFooter(){
		Map<String,Object> rootMap=new HashMap<String,Object>();
        rootMap.put("friendLinkList", getFriendLink());
        String root = htmlTemplate.getTemplateroot();
        String roothtml = getHtmlRoot();
        //String root = "d:/tmp/office";
		FreemarkerUtil.buildHtml(root,"friendlink.html", rootMap, roothtml+"/include/", "friendlink.html");
	}
	
	 public List<Map<String,Object>> getFriendLink() {
	        List<Map<String,Object>> list=new ArrayList<Map<String,Object>>();
	        List<LinkInfo> llist=FacadeFactory.INSTANCE.getLinkInfoBo().getValidteLinkInfoListByLinkLocId(LinkLocationIdConstant.NIUX_OFFICIA_FRIENDLINK, 30, ispreview);
	        for(LinkInfo linkinfo:llist){
	            Map<String,Object> map=new HashMap<String,Object>();
	            map.put("title", linkinfo.getLinktitle()==null?"":linkinfo.getLinktitle());
	            map.put("url", linkinfo.getLinkurl()==null?"":linkinfo.getLinkurl());
	            list.add(map);
	        }
	        return list;
	    }
}
