package com.xunlei.niux.manager.template.builder.mobilegameofficial.v1;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;

import com.xunlei.httptool.util.JsonObjectUtil;
import com.xunlei.niux.data.vipgame.bo.LinkInfoBo;
import com.xunlei.niux.data.vipgame.dto.game.GameDTO;
import com.xunlei.niux.easyutils.commonutils.NumParseUtil;
import org.aspectj.weaver.ast.Call;
import org.springframework.util.CollectionUtils;
import com.ferret.common.dao.enums.OrderType;
import com.ferret.common.dao.vo.Page;
import com.xunlei.common.vo.LibClassD;
import com.xunlei.common.vo.LibClassM;
import com.xunlei.niux.data.activity.vo.Activity;
import com.xunlei.niux.data.vipgame.dto.MobileGameDTO;
import com.xunlei.niux.data.vipgame.facade.FacadeFactory;
import com.xunlei.niux.data.vipgame.vo.Games;
import com.xunlei.niux.data.vipgame.vo.LinkInfo;
import com.xunlei.niux.manager.template.builder.AbstractTemplateBuilder;
import com.xunlei.niux.manager.web.cache.GameCache;
import com.xunlei.niux.manager.web.util.FreemarkerUtil;


public class SearchGameBuilderThread implements Callable{
    private String inputPath;
    private String outputPath;
    private boolean isPreview;
    private Map<String, LinkInfo> mobileGameDownloadInfoMap;


    public SearchGameBuilderThread(String inputPath, String outputPath, boolean isPreview, Map<String, LinkInfo> mobileGameDownloadInfoMap) {
        this.inputPath = inputPath;
        this.isPreview = isPreview;
        this.mobileGameDownloadInfoMap = mobileGameDownloadInfoMap;
        this.outputPath = outputPath;
    }

    @Override
	public Object call(){
	    buildActivity();//手游活动页模版
	    buildSearchGame();//搜索页模版
	    buildGiftList();//礼包页模版
        return "";
	}
	
	private void buildGiftList(){
		Map<String,Object> rootMap=new HashMap<String,Object>();
		LinkInfo query = new LinkInfo();
		query.setLinklocid("251");
		Page page = new Page();
		page.addOrder("validdatetime", OrderType.DESC);
		List<LinkInfo> lilist=FacadeFactory.INSTANCE.getLinkInfoBo().find(query,page);	
		List<Map<String,Object>> giftList = new ArrayList<Map<String,Object>>();
		for(int i=0;i<lilist.size();i++){
			LinkInfo li=lilist.get(i);
			String gameid = li.getGameid();
			Games games = GameCache.getInstance().getGameByGameId(gameid);
			if(games == null)continue;//如果游戏不存在
			if(!"1".equals(games.getStatus())||games.getClientType().intValue()!=3)continue;//如果不是手游或未接入
			Map<String,Object> map=new HashMap<String,Object>();
			map.put("icon", li.getPicurl());
			map.put("giftId", li.getLinkid());
			map.put("giftName", li.getLinktitle());
			map.put("gameName", li.getLinktitle());
			map.put("gameOfficialLink",games.getOfficialWebSite());
			map.put("gameNo", games.getGameNo());
			map.put("gameId",games.getGameId());
			map.put("giftContent",li.getLinkdesc());
			//map.put("addTime",li.getValiddatetime());
			map.put("addTime", li.getExt4());//过期时间
			map.put("isNeedSelectServer", 1);
			giftList.add(map);
		}
		rootMap.put("giftList", giftList);
		FreemarkerUtil.buildHtml(inputPath, "gift.html", rootMap, outputPath , "gift.html");
	}
	
	
	

	
	/**
	 * 活动页模版
	 */
	private void buildActivity(){
		Map<String,Object> rootMap=new HashMap<String,Object>();   
		rootMap.put("actList", getActivityList());    		
		FreemarkerUtil.buildHtml(inputPath,"activity.html", rootMap, outputPath, "activity.html");
	}
	
	private List<Map<String,String>> getActivityList(){
		List<Activity> actlist = com.xunlei.niux.data.activity.facade.FacadeFactory.INSTANCE.getActivityBo().getAllActivityList(2);
		if(CollectionUtils.isEmpty(actlist))return null;
	    List<Map<String,String>> list = new ArrayList<Map<String,String>>();
	    for(Activity act:actlist){
	    	Map<String,String> map = new HashMap<String,String>();
	    	map.put("img", act.getPicUrl());
	    	map.put("title", act.getTitle());
	    	map.put("startTime", act.getStarttime());
	    	map.put("endTime", act.getEndtime());
	    	map.put("desc", act.getDescription());
	    	map.put("url", act.getLink());
	    	list.add(map);
	    }
	    return list;
	}
	
	/**
	 * 搜索游戏模版
	 */
	private void buildSearchGame(){
		Map<String,Object> rootMap=new HashMap<String,Object>();
		rootMap.put("conditions", getConditions());
        List<Map<String,Object>> allMobileGameList = getAllGameList();
		rootMap.put("allGameList", allMobileGameList);
        rootMap.put("allMobileGameJson",JsonObjectUtil.getDataJsonObject(allMobileGameList));
		FreemarkerUtil.buildHtml(inputPath,"gamecenter.html", rootMap, outputPath, "gamecenter.html");
        FreemarkerUtil.buildHtml(inputPath+"gamebox/","allMobileGame.js", rootMap, outputPath+"gamebox/", "allMobileGame.js");
	}

	private Map<String,Object> getConditions(){
		Map<String,Object> conditions = new HashMap<String,Object>();		
		 List<Map<String,String>> gameTypeList =  getGameTypeList();
		 conditions.put("gameTypeList", gameTypeList);		 
		 List<Map<String,String>> gameFeatureList = getGameFeatureList();
		 conditions.put("gameFeatureList", gameFeatureList);		 
		return conditions;
	}
	private List<Map<String,String>> getGameTypeList(){
		 List<Map<String,String>> gameTypeList = new ArrayList<Map<String,String>>();
		 List adatas = LibClassM.getLibClassDList("gamecategory");
		 for(int i = 0; i < adatas.size(); i++){
			Map<String,String> map = new HashMap<String,String>();
			map.put("typeId", ((LibClassD)adatas.get(i)).getItemno());
			map.put("typeName", ((LibClassD)adatas.get(i)).getItemname());
			gameTypeList.add(map);
        }	  
		 return gameTypeList;
	}
	
	private List<Map<String,String>> getGameFeatureList(){
		 List<Map<String,String>> gameFeatureList = new ArrayList<Map<String,String>>();
		 List bdatas = LibClassM.getLibClassDList("gameFeatures");
		 for(int i = 0; i < bdatas.size(); i++){
			Map<String,String> map = new HashMap<String,String>();
			map.put("featureId", ((LibClassD)bdatas.get(i)).getItemno());
			map.put("featureName", ((LibClassD)bdatas.get(i)).getItemname());
			gameFeatureList.add(map);
        }	  
		 return gameFeatureList;
	}
	private List<Map<String,Object>> getAllGameList(){
		List<GameDTO> appList = FacadeFactory.INSTANCE.getGamesBo().getAllValidAppGames();
        List<Map<String,Object>> resultList = new ArrayList<Map<String, Object>>();

        for(GameDTO appGame : appList){
            resultList.add(appGame.generateAppGameMap(mobileGameDownloadInfoMap));
        }
		return resultList;
	}
}
