package com.xunlei.niux.manager.template.builder.mobilegameofficial.v1;

import com.xunlei.niux.data.vipgame.facade.FacadeFactory;
import com.xunlei.niux.data.vipgame.vo.LinkInfo;
import com.xunlei.niux.manager.template.builder.AbstractTemplateBuilder;
import org.apache.commons.collections.CollectionUtils;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

/**
* Created by jamesjxin on 14-8-14.
*/
public class MobileWebBuilder extends AbstractTemplateBuilder{
    private Map<String, LinkInfo> mobileGameDownloadInfoMap;
    private ExecutorService executorService;


    @Override
    public void executeShcema() throws Exception {
        executorService = Executors.newCachedThreadPool();
        initMobileGameDownloadInfoMap();

        String templatePath = htmlTemplate.getTemplateroot();
        if(!templatePath.endsWith("/")){
            templatePath = templatePath+"/";
        }
        String htmlPath = htmlTemplate.getHtmlroot();
        if(!htmlPath.endsWith("/")){
            htmlPath = htmlPath+"/";
        }

        Future future1 = executorService.submit(new IndexPageBuilderThread(templatePath, htmlPath,"index.html",isPreView, mobileGameDownloadInfoMap));
        Future future2 = executorService.submit(new SearchGameBuilderThread(templatePath,htmlPath,isPreView,mobileGameDownloadInfoMap));

        future1.get();
        future2.get();
    }

    private void initMobileGameDownloadInfoMap(){
        mobileGameDownloadInfoMap = new HashMap<String, LinkInfo>();
        List<LinkInfo> gameDownloadInfoList = FacadeFactory.INSTANCE.getLinkInfoBo().getAllLinkListByLinkLocId("1601", isPreView);
        if (CollectionUtils.isEmpty(gameDownloadInfoList)) {
            return;
        }

        for (LinkInfo linkInfo : gameDownloadInfoList) {
            mobileGameDownloadInfoMap.put(linkInfo.getGameidbytuijian(), linkInfo);
        }
    }
}
