package com.xunlei.niux.manager.template.builder.mobilegameofficial.v1;

import com.xunlei.niux.data.vipgame.facade.FacadeFactory;
import com.xunlei.niux.data.vipgame.vo.LinkInfo;
import com.xunlei.niux.manager.template.builder.AbstractTemplateBuilder;
import org.apache.commons.collections.CollectionUtils;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
* Created by jamesjxin on 14-8-14.
*/
public class MobileWebBoxBuilder extends AbstractTemplateBuilder{
    private Map<String, LinkInfo> mobileGameDownloadInfoMap;


    @Override
    public void executeShcema() throws Exception {
        initMobileGameDownloadInfoMap();
        String templatePath = htmlTemplate.getTemplateroot();
        if(!templatePath.endsWith("/")){
            templatePath = templatePath+"/";
        }
        String htmlPath = htmlTemplate.getHtmlroot();
        if(!htmlPath.endsWith("/")){
            htmlPath = htmlPath+"/";
        }

        new IndexPageBuilderThread(templatePath,htmlPath,"index4box.html",false,mobileGameDownloadInfoMap).call();
    }

    private void initMobileGameDownloadInfoMap(){
        mobileGameDownloadInfoMap = new HashMap<String, LinkInfo>();
        List<LinkInfo> gameDownloadInfoList = FacadeFactory.INSTANCE.getLinkInfoBo().getAllLinkListByLinkLocId("1601", isPreView);
        if (CollectionUtils.isEmpty(gameDownloadInfoList)) {
            return;
        }

        for (LinkInfo linkInfo : gameDownloadInfoList) {
            mobileGameDownloadInfoMap.put(linkInfo.getGameidbytuijian(), linkInfo);
        }
    }
}
