package com.xunlei.niux.manager.template.builder.mobilegameofficial;

import com.ferret.common.dao.vo.Page;
import com.xunlei.niux.data.vipgame.facade.FacadeFactory;
import com.xunlei.niux.data.vipgame.vo.LinkInfo;
import com.xunlei.niux.manager.template.builder.AbstractTemplateBuilder;
import com.xunlei.niux.manager.web.util.FreemarkerUtil;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * Created by lizeyu on 2015/12/7.
 */
public class ShouleiTuijianBuilder extends AbstractTemplateBuilder{

    private String inputPath;
    private String outputPath;

    /**
     * 获取displaySort中最大的一批linkinfo，生成目标文件
     * @throws Exception
     */
    @Override
    public void executeShcema() throws Exception{
        inputPath = htmlTemplate.getTemplateroot();
        outputPath = htmlTemplate.getHtmlroot();

//        inputPath = "d:\\test";
//        outputPath = "d:\\test2";

        int maxDisplaySort = getMaxDisplaySort();
        List<LinkInfo> linkshouleiTuijianLinksInfos = queryShouleiTuijianLinksInfos(maxDisplaySort);
        Map<String, Object> rootMap = getRootMap(linkshouleiTuijianLinksInfos);

        /*生成的文件命名方式为mobilegametuijian_ +　时间戳，例：mobilegametuijian_1449457157.sql
        * 此处是和手雷方的约定*/
        String outputFileName = "mobilegametuijian_" + System.currentTimeMillis() / 1000 + ".sql";
        FreemarkerUtil.buildHtml(inputPath, "mobilegametuijian.sql", rootMap, outputPath, outputFileName);
    }

    private Map<String, Object> getRootMap(List<LinkInfo> linkshouleiTuijianLinksInfos){
        List<Map<String, Object>> shouleiTuijianList = new ArrayList<Map<String, Object>>();

        for(LinkInfo link : linkshouleiTuijianLinksInfos){
            Map<String, Object> map = new HashMap<String, Object>();
            map.put("gameName", link.getLinkdesc());
            map.put("gameUrl", link.getLinkurl());

            shouleiTuijianList.add(map);
        }

        Map<String, Object> rootMap = new HashMap<String, Object>();
        rootMap.put("shouleituijianlist", shouleiTuijianList);

        return rootMap;
    }

    private List<LinkInfo> queryShouleiTuijianLinksInfos(int maxDisplaySort){
        LinkInfo query = new LinkInfo();
        query.setLinklocid("838");
        query.setDisplaysort(maxDisplaySort);

        List<LinkInfo> linkshouleiTuijianLinksInfos = FacadeFactory.INSTANCE.getBaseSo().findObjects(query, new Page());

        return linkshouleiTuijianLinksInfos;
    }

    public int getMaxDisplaySort(){
        String maxDisplaySortSql = "select max(displaysort) from linkinfo where linklocid='838';";
        int maxDisplaySort = FacadeFactory.INSTANCE.getBaseSo().count(maxDisplaySortSql, null);

        return maxDisplaySort;
    }
}
