
package com.xunlei.niux.manager.template.builder.mobilegameofficial;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

import com.ferret.common.dao.enums.OrderType;
import com.ferret.common.dao.vo.Page;
import com.xunlei.niux.data.vipgame.facade.FacadeFactory;
import com.xunlei.niux.data.vipgame.vo.Advice;
import com.xunlei.niux.data.vipgame.vo.Games;
import com.xunlei.niux.data.vipgame.vo.LinkInfo;
import com.xunlei.niux.manager.template.builder.AbstractTemplateBuilder;
import com.xunlei.niux.manager.web.cache.GameCache;
import com.xunlei.niux.manager.web.util.FreemarkerUtil;

/**
 * 生成游戏官网
 * 
 * @author Administrator
 * 
 */
public class MobileGameOfficialBuilder extends AbstractTemplateBuilder {
	private static SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
	private Games games = null;

	@Override
	public void executeShcema() throws Exception {
		games = GameCache.getInstance().getGameByGameId(schema.getExt1());
		int pageSize = 10;
		buildArticleList("zonghe", pageSize, false);
		buildArticleList("gonggao", pageSize, true);
		buildArticleList("huodong", pageSize, true);
		buildArticleList("gonglue", pageSize, true);
		buildArticleList("ziliao", pageSize, false);
		buildArticleList("xinshou", pageSize, true);
		buildArticleList("gaoshou", pageSize, true);
		buildArticleList("tese", pageSize, true);
		
		buildGiftList();
		
		 buildGiftDetail();
		
	}
	private Map<String,String> getGameInfoMap(){
		Map<String,String> map=new HashMap<String,String>();
		map.put("gameNo",games.getGameNo());
		map.put("gameId",games.getGameId());
		map.put("gameName", games.getGameName());
		LinkInfo logoli=FacadeFactory.INSTANCE.getLinkInfoBo().getGameValidteLinkInfoByLinkLocId("300", games.getGameId(), isPreView);
		if(logoli==null||logoli.getPicurl()==null){
			map.put("img", "");
		}else{
			map.put("img", logoli.getPicurl());
		}
		return map;
	}
	private void buildGiftDetail(){
		Map<String,Object> rootMap=new HashMap<String,Object>();
		rootMap.put("gameInfo", getGameInfoMap());
		List<LinkInfo> lilist=FacadeFactory.INSTANCE.getLinkInfoBo().getGameValidteLinkInfoListByLinkLocId_v2("251",games.getGameId(), 1000, isPreView);
		String htmlFilePath = isPreView ? htmlTemplate.getPreviewhtmlroot() : htmlTemplate.getHtmlroot();
		String htmlFilePath1 = htmlFilePath + "/official/" + games.getGameNo();
		for(int i=0;i<lilist.size();i++){
			LinkInfo li=lilist.get(i);
			Map<String,String> map=new HashMap<String,String>();
			map.put("id",li.getLinkid()+"");
			map.put("name", li.getLinktitle());
			map.put("img", li.getPicurl()==null?"":li.getPicurl());
			map.put("content", li.getLinkdesc()==null?"":li.getLinkdesc());
			map.put("validPeriod", li.getExt4()==null?"":li.getExt4());
			map.put("usage", li.getExt5()==null?"":li.getExt5());
			rootMap.put("giftInfoMap", map);
			FreemarkerUtil.buildHtml(htmlTemplate.getTemplateroot(), "giftDetail.html", rootMap, htmlFilePath1
					+ "/gift" ,  li.getLinkid()+".html");
		}
	}
	
	private void buildGiftList(){
		Map<String,Object> rootMap=new HashMap<String,Object>();
		rootMap.put("gameInfo", getGameInfoMap());
		List<LinkInfo> lilist=FacadeFactory.INSTANCE.getLinkInfoBo().getGameValidteLinkInfoListByLinkLocId_v2("251",games.getGameId(), 1000, isPreView);
		rootMap.put("totalGiftNum", lilist.size());
		
	
		Map<String,List<Map<String,Object>>> tempMap=new HashMap<String,List<Map<String,Object>>>();
		for(int i=0;i<lilist.size();i++){
			LinkInfo li=lilist.get(i);
			List<Map<String,Object>> templist=tempMap.get(li.getExt3());
			templist=templist==null?new ArrayList<Map<String,Object>>():templist;
			
			Map<String,Object> map1=new HashMap<String,Object>();
			map1.put("id", li.getLinkid());
			map1.put("name", li.getLinktitle());
			
			templist.add(map1);
			
			tempMap.put(li.getExt3(), templist);
		}
		
		List<Map<String,Object>> giftList=new ArrayList<Map<String,Object>>();
		Iterator<String> it=tempMap.keySet().iterator();
		while(it.hasNext()){
			String key=it.next();
			Map<String,Object> map2=new HashMap<String,Object>();
			map2.put("typeName", key);
			map2.put("list", tempMap.get(key));
			giftList.add(map2);
		}
		rootMap.put("giftList", giftList);
		
		String htmlFilePath = isPreView ? htmlTemplate.getPreviewhtmlroot() : htmlTemplate.getHtmlroot();
		String htmlFilePath1 = htmlFilePath + "/official/" + games.getGameNo();
		
		FreemarkerUtil.buildHtml(htmlTemplate.getTemplateroot(), "giftList.html", rootMap, htmlFilePath1
				+ "/gift" ,  "list.html");
		FreemarkerUtil.buildHtml(htmlTemplate.getTemplateroot(), "mygift.html", rootMap, htmlFilePath1 + "/gift",  "mygift.html");
		FreemarkerUtil.buildHtml(htmlTemplate.getTemplateroot(), "ok.html", rootMap, htmlFilePath1 + "/gift",  "ok.html");
	}
	private void buildArticleList(String type, int pageSize, boolean isSingle) {
		int zonghecount = buildArticleListCount(type, isSingle);
		int count = zonghecount / pageSize;
		if (zonghecount % pageSize > 0) {
			count++;
		}
		if (count == 0) {
			count = 1;
		}
		String htmlFilePath = isPreView ? htmlTemplate.getPreviewhtmlroot() : htmlTemplate.getHtmlroot();
		String htmlFilePath1 = htmlFilePath + "/official/" + games.getGameNo();
		for (int page = 0; page < count; page++) {
			List<Map<String, String>> list = buildArticleList(page + 1, pageSize, type, isSingle);
			Map<String, Object> listInfoMap = new HashMap<String, Object>();
			listInfoMap.put("type", type);
			listInfoMap.put("gameName", games.getGameName());
			listInfoMap.put("totalPageNum", count);
			
			Map<String, Object> root = new HashMap<String, Object>();
			root.put("listMap", listInfoMap);
			root.put("articleList", list);
			if(page==0){
				FreemarkerUtil.buildHtml(htmlTemplate.getTemplateroot(), "listIndex.html", root, htmlFilePath1
						+ "/" + type,  "list.html");
			}else{
				FreemarkerUtil.buildHtml(htmlTemplate.getTemplateroot(), "listContent.html", root, htmlFilePath1
						+ "/" + type, (page + 1) + ".html");
			}
		}
	}
	private int buildArticleListCount(String type, boolean isSingle) {
		Advice advice = new Advice();
		advice.setAdviceType("3");
		advice.setGameId(games.getGameId());
		advice.setLePublishDate(sdf.format(new Date()));
		if (isSingle) {
			advice.setPlatformno(type);
		} else {
			advice.setExt1(type);
		}
		return FacadeFactory.INSTANCE.getAdviceBo().count(advice);
	}
	private List<Map<String, String>> buildArticleList(int pageNo, int pageSize, String type, boolean isSingle) {
		Advice advice = new Advice();
		advice.setAdviceType("3");
		advice.setGameId(games.getGameId());
		if (isSingle) {
			advice.setPlatformno(type);
		} else {
			advice.setExt1(type);
		}
		advice.setLePublishDate(sdf.format(new Date()));
		Page page = new Page();
		page.setPageNo(pageNo);
		page.setPageSize(pageSize);
		page.addOrder("displayOrder", OrderType.ESC);
		page.addOrder("publishDate", OrderType.DESC);
		List<Advice> list = FacadeFactory.INSTANCE.getAdviceBo().findAdvice(advice, page);

		List<Map<String, String>> mapList = new ArrayList<Map<String, String>>();
		for (Advice ad : list) {
			Map<String, String> map = new HashMap<String, String>();
			map.put("typeId", ad.getPlatformno());
			map.put("aid", ad.getSeqId() + "");
			map.put("title", ad.getTitle());
			map.put("url", ad.getJumpUrl() + "");
			map.put("date", ad.getPublishDate().substring(0, 10));
			map.put("isColor", ad.getRed() ? "yes" : "no");
			map.put("isStrong", ad.getBold() ? "yes" : "no");
			mapList.add(map);
		}
		return mapList;
	}
}

