package com.xunlei.niux.manager.template.builder.mobilegameofficial;

import com.xunlei.common.vo.LibClassD;
import com.xunlei.common.vo.LibClassM;
import com.xunlei.httptool.util.JsonObjectUtil;
import com.xunlei.niux.data.vipgame.dto.game.GameDTO;
import com.xunlei.niux.data.vipgame.facade.FacadeFactory;
import com.xunlei.niux.data.vipgame.vo.CpsGames;
import com.xunlei.niux.data.vipgame.vo.Games;
import com.xunlei.niux.data.vipgame.vo.LinkInfo;
import com.xunlei.niux.data.vipgame.vo.games.MobileGamePic;
import com.xunlei.niux.easyutils.commonutils.EasyCollectionUtil;
import com.xunlei.niux.easyutils.commonutils.NumParseUtil;
import com.xunlei.niux.manager.template.builder.AbstractTemplateBuilder;
import com.xunlei.niux.manager.web.util.FreemarkerUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

import java.util.*;

/**
 * Created with IntelliJ IDEA.
 * User: admin
 * Date: 15-5-12
 * Time: 下午12:06
 * To change this template use File | Settings | File Templates.
 */
public class MobileGameCenterBuilder extends AbstractTemplateBuilder {
    private static final Logger logger = Logger.getLogger(MobileGameCenterBuilder.class.getName());

    private static final String Fine_GameLinkLocId = "1303";
    private static final String DayRecommend_GameLinkLocId = "1304";
    private static final String SearchRecommend_GameLinkLocId = "1305";

    private Map<String,String> gameFeaturesMap;
    private Map<String,GameDTO> appGamesMap;

    private String inputPath;
    private String outputPath;


    @Override
    public void executeShcema() throws Exception {
        initAllAppGameMap();
        initGameFeaturesMap();
        inputPath = htmlTemplate.getTemplateroot();
        outputPath = htmlTemplate.getHtmlroot();

//        inputPath = "d:\\test";
//        outputPath = "d:\\test2";

        List<Map<String,Object>> allMobileGameList = new ArrayList<Map<String, Object>>();
        List<Map<String,Object>> mobileWebGameList = new ArrayList<Map<String, Object>>();
        List<Map<String,Object>> mobileAloneGameList = new ArrayList<Map<String, Object>>();

        getMobileWebGameList(mobileWebGameList);
        getAloneMobileWebGameList(mobileAloneGameList);

        allMobileGameList.addAll(mobileWebGameList);
        allMobileGameList.addAll(mobileAloneGameList);

        List<Map<String,Object>> allFineGamelist = getFineGameList(Fine_GameLinkLocId);
        List<Map<String,Object>> dayRecommendGamelist = getFineGameList(DayRecommend_GameLinkLocId);
        List<Map<String,Object>> searchRecommendGamelist = getFineGameList(SearchRecommend_GameLinkLocId);

        buildIndexPageJs(mobileWebGameList,allFineGamelist);
        buildMobileGameList(mobileWebGameList,mobileAloneGameList);
        buildAllGameDetailPage(allFineGamelist);
        buildRankGamePage();
        buildDayRecommendJS(dayRecommendGamelist);
        buildSearchRecommendJS(searchRecommendGamelist);//
        buildAllSearchGamesJs(appGamesMap);

    }

    private void initAllAppGameMap(){
        appGamesMap = new HashMap<String, GameDTO>();
        List<GameDTO> list = FacadeFactory.INSTANCE.getGamesBo().getAllValidAppGames();
        if(CollectionUtils.isEmpty(list)){
            return;
        }

        for(GameDTO gameDTO:list){
            appGamesMap.put(gameDTO.getGameId(),gameDTO);
        }
    }
    private void initGameFeaturesMap(){

        gameFeaturesMap = new HashMap<String, String>();

        List datas = LibClassM.getLibClassDList("gameFeatures");

        for (int i = 0; i < datas.size(); i++){
            String typeid = ((LibClassD) datas.get(i)).getItemno().trim();
            gameFeaturesMap.put(typeid,((LibClassD) datas.get(i)).getItemname().trim());
        }
//        gameFeaturesMap.put("0","其他");
//        gameFeaturesMap.put("1","三国");
//        gameFeaturesMap.put("2","卡牌");
//        gameFeaturesMap.put("3","仙侠");
//        gameFeaturesMap.put("4","武侠");
//        gameFeaturesMap.put("5","魔幻");
//        gameFeaturesMap.put("6","塔防");
//        gameFeaturesMap.put("7","奇幻");
//        gameFeaturesMap.put("8","历史");
//        gameFeaturesMap.put("9","热血");
//        gameFeaturesMap.put("10","休闲");
    }

    private void buildIndexPageJs(List<Map<String,Object>> mobileWebGameList,List<Map<String,Object>> fineGameList) throws Exception{
        Map<String,Object> rootMap = new HashMap<String, Object>();
        rootMap.put("slider_data",getIndexPageLunBoString());
        rootMap.put("excellent_data",getIndexFineGameListString(fineGameList));
        rootMap.put("recommand_data",getIndexRecommendListString(mobileWebGameList));

        FreemarkerUtil.buildHtml(inputPath, "slider_data.js", rootMap, outputPath,"slider_data.js");
        FreemarkerUtil.buildHtml(inputPath, "excellent_data.js", rootMap, outputPath,"excellent_data.js");
        FreemarkerUtil.buildHtml(inputPath, "recommand_data.js", rootMap, outputPath,"recommand_data.js");
    }

    private String getIndexPageLunBoString(){
        //获取轮播图
        List<LinkInfo> lilist=FacadeFactory.INSTANCE.getLinkInfoBo().getValidteLinkInfoListByLinkLocId_V2("1277", 4, isPreView);
        List<Map<String,String>> lunbotuList=new ArrayList<Map<String,String>>();
        for(int i=0;i<lilist.size();i++){
            LinkInfo li=lilist.get(i);
            Map<String,String> map=new HashMap<String,String>();
            map.put("name", li.getLinktitle()==null?"":li.getLinktitle());
            map.put("content", li.getLinkdesc()==null?"":li.getLinkdesc());
            map.put("url", li.getLinkurl()==null?"":li.getLinkurl());
            map.put("imgurl", li.getPicurl()==null?"":li.getPicurl());
            lunbotuList.add(map);
        }
        String result = " var slider_data = "+ JsonObjectUtil.getDataJsonObject(lunbotuList);
        return result;
    }

    private String getIndexFineGameListString(List<Map<String,Object>> fineGameList){
        List<Map<String,Object>> resultList;
        if(fineGameList.size() > 8){
            resultList = fineGameList.subList(0,8);
        }else {
            resultList = fineGameList;
        }
        String result = "var excellent_data = "+JsonObjectUtil.getDataJsonObject(resultList);
        return result;
    }

    private String getIndexRecommendListString(List<Map<String,Object>> mobileWebGameList) throws Exception{
        Map<String,Object> resultMap = new HashMap<String, Object>();

        //获取轮播图
        List<LinkInfo> lilist=FacadeFactory.INSTANCE.getLinkInfoBo().getValidteLinkInfoListByLinkLocId_V2("1275",4,isPreView);
        Map<String,Object> adMap = new HashMap<String, Object>();
        if(lilist.size()>0){
            LinkInfo li=lilist.get(0);
            adMap.put("name", li.getLinktitle()==null?"":li.getLinktitle());
            adMap.put("content", li.getLinkdesc()==null?"":li.getLinkdesc());
            adMap.put("url", li.getLinkurl()==null?"":li.getLinkurl());
            adMap.put("imgurl", li.getPicurl()==null?"":li.getPicurl());
        }

        List<Map<String, Object>> tuijianGameList = new ArrayList<Map<String, Object>>();
        if(CollectionUtils.isNotEmpty(mobileWebGameList)){
            if(mobileWebGameList.size() > 50){
                tuijianGameList = mobileWebGameList.subList(0,50);
            }else {
                tuijianGameList = mobileWebGameList;
            }
        }

        List<Map<String, Object>> resultList = resortGameList(tuijianGameList);
        resultMap.put("ad",adMap);
        resultMap.put("game",resultList);

        String result = "var recommand_data = "+JsonObjectUtil.getDataJsonObject(resultMap);
        return result;
    }

    private void buildMobileGameList(List<Map<String, Object>> mobileWebGameList, List<Map<String, Object>> mobileAloneGameList) throws Exception{
        Map<String, Object> rootMap = new HashMap<String, Object>();

        List<Map<String,Object>> sortedMobileWebGameList = resortGameList(mobileWebGameList);
        List<Map<String,Object>> sortedMobileAloneGameList = resortGameList(mobileAloneGameList);

        rootMap.put("webgame_data","var webgame_data = "+JsonObjectUtil.getDataJsonObject(sortedMobileWebGameList));
        rootMap.put("alonegame_data","var alonegame_data = "+JsonObjectUtil.getDataJsonObject(sortedMobileAloneGameList));

        FreemarkerUtil.buildHtml(inputPath, "webgame_data.js", rootMap, outputPath,"webgame_data.js");
        FreemarkerUtil.buildHtml(inputPath, "alonegame_data.js", rootMap, outputPath,"alonegame_data.js");

    }

    /**
     *
     * 前5个按照displaysort排序，后面的按照收入排序
     *
     * 1、mobileGameList放到temp中；
     * 2、mobileGameList排序，前5放到resultMobileGameList中;
     * 3、tempMobileGameLis剔除，合并到resultMobileGameList
     * @param mobileGameList
     * @return
     */
    private List<Map<String, Object>> resortGameList(List<Map<String, Object>> mobileGameList) throws Exception{
        List<Map<String, Object>> resultMobileGameList = new ArrayList<Map<String, Object>>();
        List<Map<String, Object>> tempMobileGameList = new ArrayList<Map<String, Object>>();

        tempMobileGameList.addAll(mobileGameList);
        sortMobileGameList(tempMobileGameList);

        List<Map<String, Object>> firstFiveGameListSortBySortNum = new ArrayList<Map<String, Object>>();
        if(tempMobileGameList.size() < 5){
            firstFiveGameListSortBySortNum = tempMobileGameList;
        }else{
            firstFiveGameListSortBySortNum = tempMobileGameList.subList(0, 5);
        }

        resultMobileGameList.addAll(firstFiveGameListSortBySortNum);

        for(Map<String, Object> map : mobileGameList){
            if(!firstFiveGameListSortBySortNum.contains(map)){
                resultMobileGameList.add(map);
            }
        }

        return resultMobileGameList;
    }

    /**
     * 对mobileGameList按照displaysort进行降序排序
     * 注：这里用Collecions.sort排序，放到正式环境会卡住且无报错，暂时不明原因，猜测可能
     * 跟环境有关
     * @param mobileGameList
     * @return
     */
    private List<Map<String, Object>> sortMobileGameList(List<Map<String, Object>> mobileGameList){
        Map<String, Object> temp = new HashMap<String, Object>();
        
        for(int i = 0; i < mobileGameList.size(); i++){
            for(int j = i + 1; j < mobileGameList.size(); j++){
                Map<String, Object> map1 = mobileGameList.get(i);
                Map<String, Object> map2 = mobileGameList.get(j);
                int number1 = (Integer) map1.get("displaysort");
                int number2 = (Integer) map2.get("displaysort");

                if(number1 < number2){
                    temp = map1;
                    mobileGameList.set(i, mobileGameList.get(j));
                    mobileGameList.set(j, temp);
                }
            }
        }

        return mobileGameList;
    }

    private void getMobileWebGameList(List<Map<String,Object>> mobileWebGameList){
        //获取下载链接
        Set<String> gameIdSet = new HashSet<String>();
//        List<LinkInfo> lilist=FacadeFactory.INSTANCE.getLinkInfoBo().getValidteLinkInfoListByLinkLocId_V2("1276", 400, isPreView);
        List<LinkInfo> lilist=FacadeFactory.INSTANCE.getLinkInfoBo().getValidteLinkInfoListByLinkLocId_V2("1276", 400, isPreView, 1, "ext8");
        for(int i=0;i<lilist.size();i++){
            LinkInfo li=lilist.get(i);
            Map<String,Object> map=new HashMap<String,Object>();

            String gameId = li.getGameidbytuijian();
            if(StringUtils.isEmpty(gameId)) continue;

            if(gameIdSet.contains(gameId)){
                continue;
            }else {
                gameIdSet.add(gameId);
            }

            GameDTO game = appGamesMap.get(gameId);

            if(game == null){
                Games query = new Games();
                query.setGameId(gameId);
                Games games = FacadeFactory.INSTANCE.getBaseSo().findObject(query);
                if(games==null){
                    continue;
                }
                game = getGameDTOByGames(games);
            }else{
                //cps游戏
                if(gameId.startsWith("c")){
                    CpsGames queryCps = new CpsGames();
                    queryCps.setGameId(gameId);
                    CpsGames cpsGames = FacadeFactory.INSTANCE.getBaseSo().findObject(queryCps);
                    if(cpsGames == null){
                        continue;
                    }else{
                        int gameFeature = 0;
                        if(cpsGames.getGameFeature() != null){
                            gameFeature = cpsGames.getGameFeature();
                        }

                        map.put("iconUrl", cpsGames.getIconUrl());
                        map.put("gameName", cpsGames.getGameName());
                        map.put("gameFeature", gameFeaturesMap.get(String.valueOf(gameFeature)) == null ? "" : gameFeaturesMap.get(String.valueOf(gameFeature)));
                        map.put("appSize", cpsGames.getCpsSize());
                        map.put("downloadUrl", cpsGames.getDownLoadUrl() == null ? "" : cpsGames.getDownLoadUrl());
                        map.put("gameDesc", cpsGames.getGameDesc() == null ? "" : cpsGames.getGameDesc());
                        map.put("gameStar", li.getExt3() == null ? 0 : Integer.valueOf(li.getExt3()));
                        map.put("summary", cpsGames.getSummary() == null ? "" : cpsGames.getSummary());
                        map.put("downloadNum", String.valueOf(cpsGames.getDownloadNum()));
                        map.put("gameId", cpsGames.getGameId());
                        map.put("gameDetailUrl", getGameDetailUrl(gameId));
                        map.put("packageName", cpsGames.getPackageName() == null ? "" : cpsGames.getPackageName());
                        map.put("displaysort", li.getDisplaysort());
                        map.put("ext8", li.getExt8());
                        map.put("runType", "");
                        map.put("hasGift", false);

                        Integer mobileGameType = cpsGames.getMobileGameType();
                        //cps网游
                        if(mobileGameType == 1){
                            mobileWebGameList.add(map);
                        }
                        continue;
                    }
                }
            }

            int downloadNum = 100000;
            if(game.getDownloadNum()!=null && game.getDownloadNum() > 0){
                downloadNum = game.getDownloadNum();
            }else if(StringUtils.isNotEmpty(li.getExt4())){
                downloadNum = Integer.parseInt(li.getExt4());
            }

            String appSize = "100.0M";
            if(StringUtils.isNotEmpty(game.getAppSize())){
                appSize = game.getAppSize();
            }else if(StringUtils.isNotEmpty(li.getExt2())){
                appSize = li.getExt2();
            }

            int clientType = game.getMobileGameType()==null?1:game.getMobileGameType().intValue();

            int gameFeature=0;
            if(game.getGameFeature() != null){
                gameFeature = game.getGameFeature();
            }

            map.put("iconUrl",  game.getSmallPicUrl()==null?"":game.getSmallPicUrl());
            map.put("gameName",game.getGameName()==null?"":game.getGameName());
            map.put("gameFeature",gameFeaturesMap.get(String.valueOf(gameFeature))==null?"":gameFeaturesMap.get(String.valueOf(gameFeature)));
            map.put("appSize", appSize);
            map.put("downloadUrl", game.getDownLoadUrl()==null?"":game.getDownLoadUrl());
            map.put("gameDesc", game.getGameDesc()==null?"":game.getGameDesc());
            map.put("gameStar", li.getExt3()==null?0:Integer.valueOf(li.getExt3()));
            map.put("summary",game.getSummary()==null?"":game.getSummary());
            map.put("downloadNum", NumParseUtil.getDownloadNumStr(String.valueOf(downloadNum)));
            map.put("gameId", gameId);
            map.put("gameDetailUrl",getGameDetailUrl(gameId));
            map.put("packageName",game.getPackageName()==null?"":game.getPackageName());
            map.put("displaysort", li.getDisplaysort());
            map.put("ext8", li.getExt8());


            //增加是否独运
            map.put("runType", game.getRunType()==null?"":game.getRunType());
            //增加是否有礼包
            map.put("hasGift", game.getHasGift());

            if(clientType == 1){
                mobileWebGameList.add(map);
            }
            //只生成mobileWebGameList的列表注释对mobileAloneGameList的影响
//            else if(clientType ==2){
//                mobileAloneGameList.add(map);
//            }
        }
    }

    private void getAloneMobileWebGameList(List<Map<String, Object>> mobileAloneGameList){
        //获取下载链接
        Set<String> gameIdSet = new HashSet<String>();
        List<LinkInfo> lilist = FacadeFactory.INSTANCE.getLinkInfoBo().getValidteLinkInfoListByLinkLocId_V2("1276", 400, isPreView);
        for(int i = 0; i < lilist.size(); i++){
            LinkInfo li = lilist.get(i);
            Map<String, Object> map = new HashMap<String, Object>();

            String gameId = li.getGameidbytuijian();
            if(StringUtils.isEmpty(gameId)) continue;

            if(gameIdSet.contains(gameId)){
                continue;
            }else{
                gameIdSet.add(gameId);
            }

            GameDTO game = appGamesMap.get(gameId);
            if(game == null){
                Games query = new Games();
                query.setGameId(gameId);
                Games games = FacadeFactory.INSTANCE.getBaseSo().findObject(query);
                if(games == null){
                    continue;
                }
                game = getGameDTOByGames(games);
            }else{
                if(gameId.startsWith("c")){
                    CpsGames queryCps = new CpsGames();
                    queryCps.setGameId(gameId);
                    CpsGames cpsGames = FacadeFactory.INSTANCE.getBaseSo().findObject(queryCps);
                    if(cpsGames == null){
                        continue;
                    }else{
                        int gameFeature = 0;
                        if(cpsGames.getGameFeature() != null){
                            gameFeature = cpsGames.getGameFeature();
                        }

                        map.put("iconUrl", cpsGames.getIconUrl());
                        map.put("gameName", cpsGames.getGameName());
                        map.put("gameFeature", gameFeaturesMap.get(String.valueOf(gameFeature)) == null ? "" : gameFeaturesMap.get(String.valueOf(gameFeature)));
                        map.put("appSize", cpsGames.getCpsSize());
                        map.put("downloadUrl", cpsGames.getDownLoadUrl() == null ? "" : cpsGames.getDownLoadUrl());
                        map.put("gameDesc", cpsGames.getGameDesc() == null ? "" : cpsGames.getGameDesc());
                        map.put("gameStar", li.getExt3() == null ? 0 : Integer.valueOf(li.getExt3()));
                        map.put("summary", cpsGames.getSummary() == null ? "" : cpsGames.getSummary());
                        map.put("downloadNum", String.valueOf(cpsGames.getDownloadNum()));
                        map.put("gameId", cpsGames.getGameId());
                        map.put("gameDetailUrl", getGameDetailUrl(gameId));
                        map.put("packageName", cpsGames.getPackageName() == null ? "" : cpsGames.getPackageName());
                        map.put("displaysort", li.getDisplaysort());
                        map.put("ext8", li.getExt8());
                        map.put("runType", "");
                        map.put("hasGift", false);

                        Integer mobileGameType = cpsGames.getMobileGameType();
                        if(mobileGameType == 2){
                            mobileAloneGameList.add(map);
                        }
                        continue;
                    }
                }
            }

            int downloadNum = 100000;
            if(game.getDownloadNum() != null && game.getDownloadNum() > 0){
                downloadNum = game.getDownloadNum();
            }else if(StringUtils.isNotEmpty(li.getExt4())){
                downloadNum = Integer.parseInt(li.getExt4());
            }

            String appSize = "100.0M";
            if(StringUtils.isNotEmpty(game.getAppSize())){
                appSize = game.getAppSize();
            }else if(StringUtils.isNotEmpty(li.getExt2())){
                appSize = li.getExt2();
            }

            int clientType = game.getMobileGameType() == null ? 1 : game.getMobileGameType().intValue();

            int gameFeature = 0;
            if(game.getGameFeature() != null){
                gameFeature = game.getGameFeature();
            }

            map.put("iconUrl", game.getSmallPicUrl() == null ? "" : game.getSmallPicUrl());
            map.put("gameName", game.getGameName() == null ? "" : game.getGameName());
            map.put("gameFeature", gameFeaturesMap.get(String.valueOf(gameFeature)) == null ? "" : gameFeaturesMap.get(String.valueOf(gameFeature)));
            map.put("appSize", appSize);
            map.put("downloadUrl", game.getDownLoadUrl() == null ? "" : game.getDownLoadUrl());
            map.put("gameDesc", game.getGameDesc() == null ? "" : game.getGameDesc());
            map.put("gameStar", li.getExt3() == null ? 0 : Integer.valueOf(li.getExt3()));
            map.put("summary", game.getSummary() == null ? "" : game.getSummary());
            map.put("downloadNum", NumParseUtil.getDownloadNumStr(String.valueOf(downloadNum)));
            map.put("gameId", gameId);
            map.put("gameDetailUrl", getGameDetailUrl(gameId));
            map.put("packageName", game.getPackageName() == null ? "" : game.getPackageName());
            map.put("displaysort", li.getDisplaysort());

            //增加是否独运
            map.put("runType", game.getRunType() == null ? "" : game.getRunType());
            //增加是否有礼包
            map.put("hasGift", game.getHasGift());

            //只生成mobileAloneGameList的列表注释对mobileWebGameList的影响
            /*if(clientType == 1){
                mobileWebGameList.add(map);
            }else*/
            if(clientType == 2){
                mobileAloneGameList.add(map);
            }
        }
    }

    private GameDTO getGameDTOByGames(Games games){
        GameDTO game = new GameDTO();
        game.setGameId(games.getGameId());
        game.setGameName(games.getGameName());
        game.setMobileGameType(games.getMobileGameType());
        game.setGameFeature(games.getGameFeature());
        game.setGameDesc(games.getGameDesc());
        game.setSummary(games.getSummary());
        game.setSmallPicUrl(games.getSmallPicUrl());
        game.setPicUrl(games.getPicUrl());
        return game;
    }

    private void buildAllGameDetailPage(List<Map<String,Object>> allFineGameList){

        for(Map.Entry gameEntry: appGamesMap.entrySet()){
            GameDTO game = (GameDTO)gameEntry.getValue();
            if(game == null){
                continue;
            }
            Map<String,Object> resultMap = new HashMap<String, Object>();
            Map<String,Object> rootMap = new HashMap<String, Object>();
            String gameId = game.getGameId();
            List<String> picList = getGamePicListByGameId(gameId);
            List<Map<String,Object>> randomFineGameList = EasyCollectionUtil.getRandomSubList(allFineGameList, 4);

            resultMap.put("gameId",gameId);
            resultMap.put("game",getGameMap(game,true));
            resultMap.put("picList",picList);
            resultMap.put("fineGameList",randomFineGameList);

            rootMap.put("gameDetail","var gameDetail = "+JsonObjectUtil.getDataJsonObject(resultMap));

            FreemarkerUtil.buildHtml(inputPath+"/detail", "gameId.js", rootMap, outputPath+"/detail",gameId+".js");
//            FreemarkerUtil.buildHtml(inputPath+"\\detail", "gameId.js", rootMap, outputPath+"\\detail",gameId+".js");
        }
    }

    private Map<String,Object> getGameMap(GameDTO game,boolean isNeedDesc){
        Map<String,Object> map = new HashMap<String, Object>();
        if(game == null) {
            return map;
        }
        String gameId = game.getGameId();
        map.put("iconUrl",  game.getSmallPicUrl()==null?"":game.getSmallPicUrl());
        map.put("gameName",game.getGameName()==null?"":game.getGameName());
        map.put("appSize", game.getAppSize()==null?"":game.getAppSize());
        map.put("downloadUrl", game.getDownLoadUrl()==null?"":game.getDownLoadUrl());
        //增加summary   hasGift  runType
        map.put("summary",game.getSummary()==null?"":game.getSummary());

        if(isNeedDesc){
            map.put("gameDesc", game.getGameDesc()==null?"":game.getGameDesc());
        }else{
            map.put("hasGift", game.getHasGift());
            map.put("runType", game.getRunType()==null?"":game.getRunType());
        }

        int downloadNum = 100000;
        if(game.getDownloadNum()!=null && game.getDownloadNum() > 0){
            downloadNum = game.getDownloadNum();
        }
        map.put("downloadNum", NumParseUtil.getDownloadNumStr(String.valueOf(downloadNum)));
        map.put("gameId",gameId);
        map.put("gameDetailUrl",getGameDetailUrl(gameId));
        map.put("packageName",game.getPackageName()==null?"":game.getPackageName());


        return map;
    }
    
    private Map<String,Object> getGameMapIds(GameDTO game,boolean isNeedDesc){
    	Map<String,Object> map = new HashMap<String, Object>();
    	if(game == null) {
    		return map;
    	}
    	String gameId = game.getGameId();
    	map.put("gameId",gameId);
    	map.put("packageName",game.getPackageName()==null?"":game.getPackageName());
    	
    	
    	return map;
    }


    private List<String> getGamePicListByGameId(String gameId){
        List<String> resultList = new ArrayList<String>();
        MobileGamePic mobileGamePic = FacadeFactory.INSTANCE.getMobileGamePicBo().getMobileGameScreenPicsByGameId(gameId);
        if(mobileGamePic==null){
            return resultList;
        }

        if(StringUtils.isNotEmpty(mobileGamePic.getPic1())){
            resultList.add(mobileGamePic.getPic1());
        }

        if(StringUtils.isNotEmpty(mobileGamePic.getPic2())){
            resultList.add(mobileGamePic.getPic2());
        }
        if(StringUtils.isNotEmpty(mobileGamePic.getPic3())){
            resultList.add(mobileGamePic.getPic3());
        }
        if(StringUtils.isNotEmpty(mobileGamePic.getPic4())){
            resultList.add(mobileGamePic.getPic4());
        }
        if(StringUtils.isNotEmpty(mobileGamePic.getPic5())){
            resultList.add(mobileGamePic.getPic5());
        }

        return resultList;
    }

    private List<Map<String,Object>> getFineGameList(String linklocId){
        List<Map<String,Object>> resultList = new ArrayList<Map<String, Object>>();
        List<LinkInfo> lilist=FacadeFactory.INSTANCE.getLinkInfoBo().getValidteLinkInfoListByLinkLocId_V2(linklocId, 100, isPreView);
        if(CollectionUtils.isEmpty(lilist)){
            return resultList;
        }

        Set<String> gameIdSet = new HashSet<String>();
        for(LinkInfo info : lilist){
            Map<String,Object> map = new HashMap<String, Object>();
            String gameId = info.getGameidbytuijian();
            if(StringUtils.isEmpty(gameId)) continue;

            if(gameIdSet.contains(gameId)){
                continue;
            }else {
                gameIdSet.add(gameId);
            }

            GameDTO game = appGamesMap.get(gameId);
            if(game == null){
                Games query = new Games();
                query.setGameId(gameId);
                Games games = FacadeFactory.INSTANCE.getBaseSo().findObject(query);
                if(games==null){
                    continue;
                }
                game = getGameDTOByGames(games);
            }
            String downloadNum = "";
            if(game.getDownloadNum()!=null){
                downloadNum = String.valueOf(game.getDownloadNum());
            }


            map.put("gameId",game.getGameId()==null?"":game.getGameId());
            map.put("gameName",game.getGameName()==null?"":game.getGameName());
            map.put("downloadUrl",game.getDownLoadUrl()==null?"":game.getDownLoadUrl());
            map.put("downloadNum",NumParseUtil.getDownloadNumStr(downloadNum));
            map.put("iconUrl",  game.getSmallPicUrl()==null?"":game.getSmallPicUrl());
            map.put("gameDetailUrl",getGameDetailUrl(gameId));
            map.put("packageName",game.getPackageName()==null?"":game.getPackageName());
            map.put("summary",game.getSummary()==null?"":game.getSummary());
            map.put("gameDesc",game.getGameDesc()==null?"":game.getGameDesc());
            map.put("firstOnLine",isFirstOnLine(info.getExt1()));

            //添加字段
            map.put("isHotOrNew", game.getIsHotOrNew());
            map.put("runType", game.getRunType());
            map.put("hasGift", game.getHasGift());


            resultList.add(map);

        }
        return resultList;
    }

    private int isFirstOnLine(String str){
        int firstOnLine = 0;
        if(StringUtils.isEmpty(str)){
            return firstOnLine;
        }

        try {
            firstOnLine = Integer.parseInt(str);
        } catch (NumberFormatException e) {
            logger.error("firstOnLine value "+str+" is not Int value!");
        }

        return firstOnLine;

    }

    private String getGameDetailUrl(String gameId){
        return "/detail/"+gameId+".html";
    }


    private void buildRankGamePage(){
        Map<String,Object> rootMap = new HashMap<String, Object>();
        rootMap.put("rank_data","var rank_data = "+JsonObjectUtil.getDataJsonObject(getMobileRankGameList()));

        FreemarkerUtil.buildHtml(inputPath, "rank_data.js", rootMap, outputPath, "rank_data.js");

    }

    private List<Map<String,Object>> getMobileRankGameList(){
        List<Map<String,Object>> resultList = new ArrayList<Map<String, Object>>();
        //获取下载链接
        List<LinkInfo> lilist=FacadeFactory.INSTANCE.getLinkInfoBo().getValidteLinkInfoListByLinkLocId_V2("1302", 400, isPreView);
        for(int i=0;i<lilist.size();i++){
            LinkInfo li=lilist.get(i);
            Map<String,Object> map=new HashMap<String,Object>();

            String gameId = li.getGameidbytuijian();
            if(StringUtils.isEmpty(gameId)) continue;

            GameDTO game = appGamesMap.get(gameId);
            if(game == null){
                Games query = new Games();
                query.setGameId(gameId);
                Games games = FacadeFactory.INSTANCE.getBaseSo().findObject(query);
                if(games==null){
                    continue;
                }
                game = getGameDTOByGames(games);
            }

            int downloadNum = 100000;
            if(game.getDownloadNum()!=null && game.getDownloadNum() > 0){
                downloadNum = game.getDownloadNum();
            }else if(StringUtils.isNotEmpty(li.getExt4())){
                downloadNum = Integer.parseInt(li.getExt4());
            }

            String appSize = "100.0M";
            if(StringUtils.isNotEmpty(game.getAppSize())){
                appSize = game.getAppSize();
            }else if(StringUtils.isNotEmpty(li.getExt2())){
                appSize = li.getExt2();
            }

            map.put("iconUrl",  game.getSmallPicUrl()==null?"":game.getSmallPicUrl());
            map.put("gameName",game.getGameName()==null?"":game.getGameName());
            map.put("gameFeature",gameFeaturesMap.get(String.valueOf(game.getGameFeature()))==null?"":gameFeaturesMap.get(String.valueOf(game.getGameFeature())));
            map.put("appSize", appSize);
            map.put("downloadUrl", game.getDownLoadUrl()==null?"":game.getDownLoadUrl());
            map.put("gameDesc", game.getGameDesc()==null?"":game.getGameDesc());
            map.put("summary",game.getSummary()==null?"":game.getSummary());
            map.put("downloadNum", NumParseUtil.getDownloadNumStr(String.valueOf(downloadNum)));
            map.put("gameId", gameId);
            map.put("packageName",game.getPackageName()==null?"":game.getPackageName());

            resultList.add(map);
        }
        return resultList;
    }

    private void buildDayRecommendJS(List<Map<String,Object>> recommendGamelist){
        String fileName = "recommendGames.js";
        Map<String,Object> rootMap = new HashMap<String, Object>();
        rootMap.put("recommendGames","var recommendGames = "+JsonObjectUtil.getDataJsonObject(recommendGamelist));

        FreemarkerUtil.buildHtml(inputPath, fileName, rootMap, outputPath, fileName);
    }

    private void buildSearchRecommendJS(List<Map<String,Object>> recommendGamelist){
        String fileName = "searchRecGames.js";
        Map<String,Object> rootMap = new HashMap<String, Object>();
        rootMap.put("searchRecGames","var searchRecGames = "+JsonObjectUtil.getDataJsonObject(recommendGamelist));

        FreemarkerUtil.buildHtml(inputPath, fileName, rootMap, outputPath, fileName);
    }

    private void buildAllSearchGamesJs(Map<String,GameDTO> appGamesMap){
        List<Map<String,Object>> resultList = new ArrayList<Map<String, Object>>();
        Map<String,Object> rootMap = new HashMap<String, Object>();
        List<Map<String,Object>> resultListIds = new ArrayList<Map<String, Object>>();
        Map<String,Object> rootMapIds = new HashMap<String, Object>();

        for(Map.Entry gameEntry: appGamesMap.entrySet()){
            GameDTO game = (GameDTO)gameEntry.getValue();
            if(game == null){
                continue;
            }
            resultList.add(getGameMap(game,false));
            resultListIds.add(getGameMapIds(game,false));
        }

        rootMap.put("allSearchGames","var allSearchGames = "+JsonObjectUtil.getDataJsonObject(resultList));
        rootMapIds.put("allSearchGames","var allSearchGames = "+JsonObjectUtil.getDataJsonObject(resultListIds));

        FreemarkerUtil.buildHtml(inputPath, "allSearchGames.js", rootMap, outputPath,"allSearchGames.js");
        FreemarkerUtil.buildHtml(inputPath, "allSearchGames.js", rootMapIds, outputPath,"allSearchGameIds.js");
    }

}
