package com.xunlei.niux.manager.template.builder.mobilegameofficial;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import com.ferret.common.dao.vo.Page;
import com.xunlei.common.facade.IFacadeCommon;
import com.xunlei.niux.data.vipgame.facade.FacadeFactory;
import com.xunlei.niux.data.vipgame.vo.Games;
import com.xunlei.niux.data.vipgame.vo.LinkInfo;
import com.xunlei.niux.data.vipgame.vo.mobilegameapkversion.MobileChannel;
import com.xunlei.niux.manager.template.builder.AbstractTemplateBuilder;
import com.xunlei.niux.manager.web.cache.ApkSpreadCache;
import com.xunlei.niux.manager.web.cache.GameCache;
import com.xunlei.niux.manager.web.util.FreemarkerUtil;
import org.apache.commons.lang.StringUtils;


/**
 * web版手游官网
 * @author lisu
 * 2014-07-04
 */
public class MobileGameBuilder extends AbstractTemplateBuilder {

	@Override
	public void executeShcema() throws Exception {
		buildMobileGame();
	}
	
	
	private String getTypeName(Games game){
		String typeName="";
		if(game.getGameType().equals("1")){
			typeName="角色扮演";
		}else if(game.getGameType().equals("2")){
			typeName="写实";
		}else if(game.getGameType().equals("3")){
			typeName="Q版萌系";
		}else if(game.getGameType().equals("4")){
			typeName="战争策略";
		}
		return  typeName;
	}
	
	private void buildMobileGame(){
		String htmlTemlateRoot = htmlTemplate.getTemplateroot();
		String roothtml = getHtmlRoot();
		Map<String,Object> rootMap=new HashMap<String,Object>();
		//获取轮播图
		List<LinkInfo> lilist=FacadeFactory.INSTANCE.getLinkInfoBo().getValidteLinkInfoListByLinkLocId_V2("1275", 4, isPreView);
		List<Map<String,String>> lunbotuList=new ArrayList<Map<String,String>>();
		for(int i=0;i<lilist.size();i++){
			LinkInfo li=lilist.get(i);
			Map<String,String> map=new HashMap<String,String>();
			map.put("title", li.getLinktitle()==null?"":li.getLinktitle());
			map.put("content", li.getLinkdesc()==null?"":li.getLinkdesc());
			map.put("url", li.getLinkurl()==null?"":li.getLinkurl());
			map.put("img", li.getPicurl()==null?"":li.getPicurl());
			lunbotuList.add(map);
		}
		rootMap.put("sliderImgList", lunbotuList);
		//手机页的轮播图
		lilist=FacadeFactory.INSTANCE.getLinkInfoBo().getValidteLinkInfoListByLinkLocId_V2("1277", 5, isPreView);
		List<Map<String,String>> mobilelunbotuList=new ArrayList<Map<String,String>>();
		for(int i=0;i<lilist.size();i++){
			LinkInfo li=lilist.get(i);
			Map<String,String> map=new HashMap<String,String>();
			map.put("title", li.getLinktitle()==null?"":li.getLinktitle());
			map.put("content", li.getLinkdesc()==null?"":li.getLinkdesc());
			map.put("url", li.getLinkurl()==null?"":li.getLinkurl());
			map.put("img", li.getPicurl()==null?"":li.getPicurl());
			mobilelunbotuList.add(map);
		}
		rootMap.put("mobilesliderImgList", mobilelunbotuList);
		
		//获取下载链接
		List<Map<String,Object>> downloadList=new ArrayList<Map<String,Object>>();
		lilist=FacadeFactory.INSTANCE.getLinkInfoBo().getValidteLinkInfoListByLinkLocId_V2("1276", 400, isPreView);
		List<Map<String,String>> channelList = getChannelList();
		for(int i=0;i<lilist.size();i++){
			LinkInfo li=lilist.get(i);
			Map<String,Object> map=new HashMap<String,Object>();
			Games game=GameCache.getInstance().getGameByGameId(li.getGameidbytuijian());
			if(game==null){
				continue;
			}
			map.put("imgSrc",  li.getPicurl()==null?"":li.getPicurl());
			map.put("title",game.getGameName());
			
			map.put("clientType",game.getMobileGameType().intValue());
			map.put("yxType",getTypeName(game));
			map.put("yxEditon", li.getExt1()==null?"":li.getExt1());
			map.put("yxSize", li.getExt2()==null?"":li.getExt2());
			map.put("yxDownUrl", li.getLinkurl()==null?"":li.getLinkurl().trim());
			map.put("yxDimenson", li.getSmallpicurl()==null?"":li.getSmallpicurl());
			map.put("yxDetail", game.getGameDesc()==null?"":game.getGameDesc());
			map.put("yxStar", li.getExt3()==null?0:Integer.valueOf(li.getExt3()));
			map.put("yxPeople", li.getExt4()==null?"":li.getExt4());
			map.put("gameid", game.getGameId());
			
			//modify by lisu 2015-03-19
			String commonUrl = ApkSpreadCache.getInstance().getSpreadJumpUrlByGameId(game.getGameId());
//			String commonUrl=li.getLinkurl()==null?"":li.getLinkurl().trim();
//			if(commonUrl.lastIndexOf("_")==commonUrl.length()-23){
//				commonUrl=commonUrl.substring(0, commonUrl.lastIndexOf("_"))+"_<%=advNo%>.apk";
//			}
			map.put("tmplDownUrl", commonUrl);
			downloadList.add(map);
		}
		rootMap.put("sliderYouxiList", downloadList);			
		rootMap.put("advList", channelList);

        String qcodePath = IFacadeCommon.INSTANCE.getLibconfigValueByConfigNo("qcodePath");
        rootMap.put("qrcodeImgPath", StringUtils.isEmpty(qcodePath)?"":qcodePath);
		
		FreemarkerUtil.buildHtml(htmlTemlateRoot, "mobilegame_inner.html", rootMap, roothtml,
				"mobilegame_inner.html");
		FreemarkerUtil.buildHtml(htmlTemlateRoot, "index.html", rootMap, roothtml+"/mobile/mpg",
				"index.html");
	}
	
	private List<Map<String,String>> getChannelList(){
		List<MobileChannel> mcList=FacadeFactory.INSTANCE.getBaseSo().findObjects(new MobileChannel(), new Page());
		List<Map<String,String>> mcMapList=new ArrayList<Map<String,String>>();
		for(MobileChannel mc:mcList){
			Map<String,String> tempMap=new HashMap<String, String>();
			tempMap.put("advNo", mc.getChannelId());
			mcMapList.add(tempMap);
		}
		return mcMapList;
	}
	
	
	public void buildDownLoad(){
		List<LinkInfo> linkList=FacadeFactory.INSTANCE.getLinkInfoBo().getValidteLinkInfoListByLinkLocId_V2("1276", 1000, isPreView);
		Map<String,LinkInfo> gameLiMap=new HashMap<String,LinkInfo>();
		for(int len=linkList.size();len>0;len--){
			LinkInfo li=linkList.get(len-1);
			gameLiMap.put(li.getGameidbytuijian(), li);
		}
		String htmlFilePath = isPreView ? htmlTemplate.getPreviewhtmlroot() : htmlTemplate.getHtmlroot();
		Map<String,Object> rootMap=new HashMap<String,Object>();
		List<Games> gamesList=GameCache.getInstance().getAllGames();
		for(int i=0;i<gamesList.size();i++){
			Games games=gamesList.get(i);
			Map<String,String> downloadmap=new HashMap<String,String>();
			LinkInfo li=gameLiMap.get(games.getGameId());
			
			downloadmap.put("name", games.getGameName());
			String type=games.getGameType();
			if("1".equals(type)){
				type="角色扮演";
			}else if("2".equals(type)){
				type="写实";
			}else if("3".equals(type)){
				type="Q版萌系";
			}else if("4".equals(type)){
				type="战争策略";
			}
			downloadmap.put("type",type);
			downloadmap.put("version", li==null||li.getExt1()==null?"":li.getExt1());
			downloadmap.put("size", li==null||li.getExt2()==null?"":li.getExt2());
			downloadmap.put("os", "android");
			downloadmap.put("description", games.getGameDesc()==null?"":games.getGameDesc());
			downloadmap.put("downloadLink",li==null||li.getLinkurl()==null?"":li.getLinkurl());
			downloadmap.put("image", li==null||li.getPicurl()==null?"":li.getPicurl());
			
			rootMap.put("gameDownLoad", downloadmap);
			//生成列表
			FreemarkerUtil.buildHtml(htmlTemplate.getTemplateroot()+"/mobile/account/gamedownload", "gameId.html", rootMap, htmlFilePath
					+ "/mobile/account/gamedownload" ,  games.getGameId()+".html");
		}
		
	}
}
