package com.xunlei.niux.manager.template.builder.mobilegameofficial;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.apache.log4j.Logger;

import com.xunlei.niux.data.vipgame.facade.FacadeFactory;
import com.xunlei.niux.data.vipgame.vo.Advice;
import com.xunlei.niux.data.vipgame.vo.Games;
import com.xunlei.niux.data.vipgame.vo.HtmlTemplate;
import com.xunlei.niux.data.vipgame.vo.LinkInfo;
import com.xunlei.niux.manager.web.cache.GameCache;
import com.xunlei.niux.manager.web.util.FreemarkerUtil;
import com.xunlei.util.StringTools;

/**
 * 文章模板生成
 * @author Administrator
 *
 */
public class MobileArticleBuilder {
	private static final Logger logger = Logger.getLogger(MobileArticleBuilder.class.getName());
	private long timestamp=0;
	/**
	 * 获取文章的url访问名字
	 * @param advice
	 * @return
	 */
//	private String getArticeUrlName(final Advice advice){
//		if(advice.getContenturl()==null||"".equals(advice.getContenturl())){
//			return System.currentTimeMillis()+".html";
//		}
//		String contentUrl=advice.getContenturl();
//		if(contentUrl.contains("/a/")){
//			return contentUrl.substring(contentUrl.lastIndexOf("/")+1);
//		}
//		return System.currentTimeMillis()+".html";
//	}
	
	private String getArticeUrlName(final Advice advice){
		String contentUrl = advice.getJumpUrl();
		if(StringTools.isEmpty(contentUrl)){//如果没有生成地址
			return null;
		}
		if(contentUrl.contains("/a/")){
			return contentUrl.substring(contentUrl.lastIndexOf("/")+1);
		}
		return System.currentTimeMillis()+".shtml";
	}
	
	  private Map<String, String> getHeadData(String gameId) {
		    Map<String,String> headMap = new HashMap<String,String>();
		    LinkInfo linkinfo = FacadeFactory.INSTANCE.getLinkInfoBo().getGameValidteLinkInfoByLinkLocId(
		      "302", gameId, false);
		    headMap.put("title", 
		      (linkinfo == null) || (linkinfo.getLinktitle() == null) ? "" : linkinfo.getLinktitle());
		    headMap.put("description", 
		      (linkinfo == null) || (linkinfo.getLinkdesc() == null) ? "" : linkinfo.getLinkdesc());
		    return headMap;
	}
	  
	public String buildArticleBuilder(final Advice advice){
		timestamp=System.currentTimeMillis();
		logger.info("builderaarticle timestamp["+timestamp+"]id["+advice.getGameId()+"开始生成");
		Games game=GameCache.getInstance().getGameByGameId(advice.getGameId());
		HtmlTemplate htmlTemplate=FacadeFactory.INSTANCE.getHtmlTemplateBo().find("000048");
		Map<String,String> articleInfoMap=new HashMap<String,String>();
		articleInfoMap.put("typeId", advice.getPlatformno()+"");
		articleInfoMap.put("title", advice.getTitle()+"");
		articleInfoMap.put("red", advice.getRed()+"");
		articleInfoMap.put("bold", advice.getBold()+"");
		articleInfoMap.put("content", getContent(game, advice));
		articleInfoMap.put("date", advice.getPublishDate().substring(0, 10));
		articleInfoMap.put("enterUrl", advice.getRemark()==null?"":advice.getRemark());
		String articeUrlName=getArticeUrlName(advice);
		String htmlFilePathRoot=htmlTemplate.getHtmlroot();
		if(htmlFilePathRoot.endsWith("/")){
			htmlFilePathRoot=htmlFilePathRoot.substring(0, htmlFilePathRoot.length()-1);
		}
		String previewhtmlFilePath=htmlTemplate.getPreviewhtmlroot();
		if(previewhtmlFilePath.endsWith("/")){
			previewhtmlFilePath=previewhtmlFilePath.substring(0, previewhtmlFilePath.length()-1);
		}
		String htmlFilePath=htmlFilePathRoot+"/official/"+game.getGameNo()+"/a";
		String htmlpath = htmlFilePathRoot+"/official/"+game.getGameNo();
	    previewhtmlFilePath=previewhtmlFilePath+"/official/"+game.getGameNo()+"/a";
		Map<String,Object> root=new HashMap<String,Object>();
		root.put("articleMap", articleInfoMap);
		root.put("gameInfo", game);
		logger.info("builderaarticle timestamp["+timestamp+"]id["+advice.getGameId()+"开始生成正式模板");
		FreemarkerUtil.buildHtml(htmlTemplate.getTemplateroot(),
				"article.html", root, htmlFilePath,
				articeUrlName);
		logger.info("builderaarticle timestamp["+timestamp+"]id["+advice.getGameId()+"开始生成预览模板");
		FreemarkerUtil.buildHtml(htmlTemplate.getTemplateroot(),
				"article.html", root, previewhtmlFilePath,
				articeUrlName);
		  //生成手游公告详情
        String gameid = advice.getGameId();
    	Games games = GameCache.getInstance().getGameByGameId(gameid);
    	if(games.getClientType().intValue()==3){//如果是手游
 	         root.put("articleMap", articleInfoMap);
 	   	     root.put("headMap", getHeadData(game.getGameId()));
    		 FreemarkerUtil.buildHtml(htmlTemplate.getTemplateroot()+"/web","article.html", root, htmlpath + "/web/a",articeUrlName);
    	}
		//生成推荐
		List<LinkInfo> tuijianDowLinkInfoList=FacadeFactory.INSTANCE.getLinkInfoBo().getValidteLinkInfoListByLinkLocId_V2("1265", 5,false);
		List<Map<String,String>> tuijianDownList=new ArrayList<Map<String,String>>();
		for(int i=0;i<tuijianDowLinkInfoList.size();i++){
			Map<String,String> tempMap=new HashMap<String,String>();
			LinkInfo templink=tuijianDowLinkInfoList.get(i);
			tempMap.put("url", templink.getLinkurl()==null?"":templink.getLinkurl());
			tempMap.put("img", templink.getPicurl()==null?"":templink.getPicurl());
			tempMap.put("title", templink.getLinktitle()==null?"":templink.getLinktitle());
			tuijianDownList.add(tempMap);
		}
		root.put("hotGameList", tuijianDownList);
		FreemarkerUtil.buildHtml(htmlTemplate.getTemplateroot(),
				"hotGame.html", root, htmlFilePathRoot+"/include/include",
				"hotGame.html");
		logger.info("builderaarticle timestamp["+timestamp+"]id["+advice.getGameId()+"开始同步");
		execRsync(htmlTemplate);
		logger.info("builderaarticle timestamp["+timestamp+"]id["+advice.getGameId()+"完成同步");
		String officilaWebSite=game.getOfficialWebSite();
		if(officilaWebSite.endsWith("/")){
			officilaWebSite=officilaWebSite.substring(0, officilaWebSite.length()-1);
		}
		return officilaWebSite+"/a/"+articeUrlName;
	}
	private String getContent(final Games games,final Advice advice){
		logger.info("builderaarticle timestamp["+timestamp+"]id["+advice.getGameId()+"开始替换静态图片");
		//替换静态图片访问地址
		String content=advice.getContent()==null?"":advice.getContent();
		content=content.replaceAll("src=\"/xlniuxmanager/userUploadFile/image","src=\"http://img.smxj.webgame.kanimg.com/userUploadFile/image");
		content=content.replaceAll("src=\"/xlniumanager/userUploadFile/image","src=\"http://img.smxj.webgame.kanimg.com/userUploadFile/image");
		logger.info("builderaarticle timestamp["+timestamp+"]id["+advice.getGameId()+"开始替换关键字");
		//替换关键字
		List<LinkInfo> lilist=FacadeFactory.INSTANCE.getLinkInfoBo().getGameValidteLinkInfoListByLinkLocId("256", games.getGameId(), 10, false);
		for(LinkInfo li:lilist){
			if(li.getLinktitle()==null||"".equals(li.getLinktitle())){
				continue;
			}
			content=content.replace(li.getLinktitle(), "<a href=\""+li.getLinkurl()+"\" target=\"_blank\">"+li.getLinktitle()+"</a>");
			logger.info("builderaarticle timestamp["+timestamp+"]id["+advice.getGameId()+"替换关键字"+li.getLinktitle());
		}
		logger.info("builderaarticle timestamp["+timestamp+"]id["+advice.getGameId()+"替换关键字完成");
		return content;
	}
	private void execRsync(final HtmlTemplate htmlTemplate){
		String execCmd=htmlTemplate.getRsyncname();//执行命
		if(execCmd==null||"".equals(execCmd)){
			return;
		}
		try {
			Runtime.getRuntime().exec(execCmd);
			Runtime.getRuntime().exec(htmlTemplate.getPreviewrsyncname());
		} catch (IOException e) {
			throw new RuntimeException("执行同步脚本："+execCmd+"出现异常",e);
		}

	}
}
