package com.xunlei.niux.manager.template.builder.jinzuan;

import com.ferret.common.dao.enums.OrderType;
import com.ferret.common.dao.vo.Page;
import com.xunlei.niux.data.active.dto.commonactivity.ActivityExtendInfoDTO;
import com.xunlei.niux.data.active.vo.commonactivity.ActivityExtendInfo;
import com.xunlei.niux.data.vipgame.enums.GiftTypeEnum;
import com.xunlei.niux.data.vipgame.facade.FacadeFactory;
import com.xunlei.niux.data.vipgame.vo.gift.Gift;
import com.xunlei.niux.data.vipgame.vo.lottery.LotteryActivity;
import com.xunlei.niux.data.vipgame.vo.lottery.LotteryGift;
import com.xunlei.niux.manager.web.util.FreemarkerUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;

/**
 * Created with IntelliJ IDEA.
 * User: admin
 * Date: 14-3-10
 * Time: 下午4:45
 * To change this template use File | Settings | File Templates.
 */
public class LotteryPageBulider implements Callable {
    private static final DateFormat sdf_time = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private static final String actNo = "JinZuanLottery";
    private static final Logger logger = Logger.getLogger(LotteryPageBulider.class);
    private String inputPath;
    private String outputPath;
    private boolean isPreview;

    public LotteryPageBulider(String inputPath, String outputPath, boolean isPreview) {
        this.inputPath = inputPath;
        this.outputPath = outputPath;
        this.isPreview = isPreview;
    }

    @Override
    public Object call() throws Exception {
        Map<String, Object> rootMap = new HashMap<String, Object>();
        rootMap.put("lotteryGiftList", getRealLotteryGiftByActNo());

        FreemarkerUtil.buildHtml(inputPath, "lottery.html", rootMap, outputPath, "lottery.html");
        return "";
    }

    public List<Map<String, Object>> getRealLotteryGiftByActNo() {
        List<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        if (StringUtils.isEmpty(actNo)) {
            return result;
        }

        Map<String, LotteryActivity> activityMap = getLotteryActivityByActNo(actNo);
        if (MapUtils.isEmpty(activityMap)) {
            return result;
        }

        //获取lotterygift
        LotteryGift query = new LotteryGift();
        query.setActNo(actNo);
        query.setIsValid(true);
        query.setGiftType(GiftTypeEnum.GOTGIFT);
        Page page = new Page();
        page.addOrder("displayOrder", OrderType.DESC);
        List<LotteryGift> giftList = FacadeFactory.INSTANCE.getBaseSo().findObjects(query, page);

        if (CollectionUtils.isEmpty(giftList)) {
            return result;
        }


        for (LotteryGift lotteryGift : giftList) {
            LotteryActivity activity = activityMap.get(lotteryGift.getModuleId());
            if (activity == null) {
                continue;
            }
            Map<String, Object> map = new HashMap<String, Object>();
            String giftId = lotteryGift.getGiftId();
            Gift gift = getGiftById(giftId);

            map.put("id", lotteryGift.getModuleId() == null ? "" : lotteryGift.getModuleId());
            map.put("name", lotteryGift.getGiftName());
            map.put("desc", gift.getSimpleDesc() == null ? "" : gift.getSimpleDesc());
            map.put("price", gift.getProductTotalPrice() == null ? 0 : gift.getProductTotalPrice());
            map.put("amount", lotteryGift.getTotalCount());
//        map.put("leftCount",lotteryGift.getLeftCount());
            map.put("everyDayCount", lotteryGift.getMaxNumPerDay());
            map.put("level", activity.getJinKaVipNum());
            map.put("img_list", lotteryGift.getPhoto() == null ? "" : lotteryGift.getPhoto());
            map.put("img_index1", lotteryGift.getExt1() == null ? "" : lotteryGift.getExt1());
            map.put("img_index2", lotteryGift.getExt2() == null ? "" : lotteryGift.getExt2());
            map.put("validPeriod", activity.getEndTime() == null ? "" : activity.getEndTime());
            map.put("detailUrl",lotteryGift.getDetailUrl()==null?"":lotteryGift.getDetailUrl());
            result.add(map);
        }

        return result;
    }

    private Gift getGiftById(String giftId) {
        if (StringUtils.isEmpty(giftId)) {
            return null;
        }
        Gift query = new Gift();
        query.setGiftId(Long.parseLong(giftId));

        Gift gift = FacadeFactory.INSTANCE.getBaseSo().findObject(query);

        return gift;
    }

    private Map<String, LotteryActivity> getLotteryActivityByActNo(String actNo) {
        Map<String, LotteryActivity> map = new HashMap<String, LotteryActivity>();
        if (StringUtils.isEmpty(actNo)) {
            return map;
        }

        LotteryActivity query = new LotteryActivity();
        query.setActNo(actNo);
        query.setIsValid(true);

        List<LotteryActivity> list = FacadeFactory.INSTANCE.getBaseSo().findObjects(query, new Page());

        if (CollectionUtils.isEmpty(list)) {
            return map;
        }

        Date now = new Date();
        for (LotteryActivity activity : list) {
            if (StringUtils.isEmpty(activity.getModuleId())) {
                continue;
            }
            if (StringUtils.isNotEmpty(activity.getStartTime())) {
                try {
                    Date startTime = sdf_time.parse(activity.getStartTime());
                    if (startTime.after(now)) {
                        continue;
                    }
                } catch (ParseException e) {
                    logger.error("日期格式转化错误", e);
                }
            }

            if (StringUtils.isNotEmpty(activity.getEndTime())) {
                try {
                    Date endTime = sdf_time.parse(activity.getEndTime());
                    if (endTime.before(now)) {
                        continue;
                    }
                } catch (ParseException e) {
                    logger.error("日期格式转化错误", e);
                }
            }
            map.put(activity.getModuleId(), activity);
        }

        return map;
    }
}
