package com.xunlei.niux.manager.template.builder.jinzuan;

import com.xunlei.niux.data.active.dto.commonactivity.ActivityGiftInfoDTO;
import com.xunlei.niux.data.jinzuanbiz.dto.GameRankingDTO;
import com.xunlei.niux.data.jinzuanbiz.facade.FacadeFactory;
import com.xunlei.niux.data.vipgame.vo.Games;
import com.xunlei.niux.data.vipgame.vo.LinkInfo;
import com.xunlei.niux.data.vipgame.vo.gift.Gift;
import com.xunlei.niux.manager.constant.LinkLocationIdConstant;
import com.xunlei.niux.manager.web.cache.GameCache;
import com.xunlei.niux.manager.web.util.FreemarkerUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.log4j.Logger;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;

/**
 * Created by jamesjxin on 14-3-20.
 */
public class LeftPartRankingPageBuilder implements Callable {
    private static final Logger logger = Logger.getLogger(LeftPartRankingPageBuilder.class);
    private static final String actNo = "JinZuanGiftPackage";
    private String inputPath;
    private String outputPath;
    private boolean isPreview;


    public LeftPartRankingPageBuilder(String inputPath, String outputPath, boolean isPreview) {
        this.inputPath = inputPath;
        this.outputPath = outputPath;
        this.isPreview = isPreview;
    }

    @Override
    public Object call() throws Exception {
        Map<String, Object> rootMap = new HashMap<String, Object>();
        rootMap.put("freeCoinRankingList", getfreeCoinRankingList());
        rootMap.put("firstPayRankingList", getfirstPayRankingList());
        rootMap.put("hotGiftList", gethotGiftList());
        rootMap.put("baseInfoAd", getBroadMessage());


        FreemarkerUtil.buildHtml(inputPath + "/include", "leftCom.html", rootMap, outputPath + "/include", "leftCom.html");
        FreemarkerUtil.buildHtml(inputPath + "/include", "baseInfoAd.html", rootMap, outputPath + "/include", "baseInfoAd.html");
        return "";

    }

    private List<Map<String, Object>> getfreeCoinRankingList() {
        List<Map<String, Object>> resultList = new ArrayList<Map<String, Object>>();

        List<GameRankingDTO> list = FacadeFactory.INSTANCE.getBonusExchangeCoinBo()
                .getBonusExchangeCoinGameRankingList(8);
        if (CollectionUtils.isEmpty(list)) {
            return null;
        }

        for (GameRankingDTO gameRankingDTO : list) {
            String gameId = gameRankingDTO.getGameId();
            Games game = GameCache.getInstance().getGameByGameId(gameId);
            if (game == null) {
                continue;
            }
            Map<String, Object> map = new HashMap<String, Object>();
            map.put("gameId", gameId);
            map.put("gameName", game.getGameName());
            map.put("count", gameRankingDTO.getTotalCount());
            resultList.add(map);
        }

        return resultList;
    }

    private List<Map<String, Object>> getfirstPayRankingList() {
        List<Map<String, Object>> resultList = new ArrayList<Map<String, Object>>();

        List<GameRankingDTO> list = FacadeFactory.INSTANCE.getGameFirstPayBo()
                .getGameFirstPayGameRankingList(8);
        if (CollectionUtils.isEmpty(list)) {
            return null;
        }

        for (GameRankingDTO gameRankingDTO : list) {
            String gameId = gameRankingDTO.getGameId();
            Games game = GameCache.getInstance().getGameByGameId(gameId);
            if (game == null) {
                continue;
            }
            Map<String, Object> map = new HashMap<String, Object>();
            map.put("gameId", gameId);
            map.put("gameName", game.getGameName());
            map.put("count", gameRankingDTO.getTotalCount());
            resultList.add(map);
        }

        return resultList;
    }

    private List<Map<String, Object>> gethotGiftList() {
        List<Map<String, Object>> resultList = new ArrayList<Map<String, Object>>();

        List<ActivityGiftInfoDTO> giftInfoList = com.xunlei.niux.data.active.facade.FacadeFactory.INSTANCE.getActivityGiftBo().getRankingJinZuanPackageTaked(actNo, 3);

        if (CollectionUtils.isEmpty(giftInfoList)) {
            return resultList;
        }

        for (ActivityGiftInfoDTO giftInfoDTO : giftInfoList) {
            int giftId = giftInfoDTO.getGiftId();
            Gift gift = getGiftByGiftId(giftId);
            if(gift == null){
                continue;
            }
            Map<String, Object> map = new HashMap<String, Object>();
            map.put("title", gift.getGiftName());
            map.put("img_left", giftInfoDTO.getSmallPic()==null?"":giftInfoDTO.getSmallPic());
            map.put("detailUrl",giftInfoDTO.getDetailUrl()==null?"":giftInfoDTO.getDetailUrl());
            resultList.add(map);
        }

        return resultList;
    }

    private Map<String, Object> getBroadMessage() {
        List<LinkInfo> lilist = com.xunlei.niux.data.vipgame.facade.FacadeFactory.INSTANCE.getLinkInfoBo()
                .getValidteLinkInfoListByLinkLocId(
                        LinkLocationIdConstant.NIUX_JINZUAN_BROADMESSAGE, 1,
                        isPreview);
        if (lilist == null || lilist.size() == 0) return null;

        LinkInfo li = lilist.get(0);
        Map<String, Object> map = new HashMap<String, Object>();
        map.put("title", li.getLinktitle());
        map.put("url", li.getLinkurl());
        map.put("date", li.getValiddatetime() == null ? "" : li.getValiddatetime().split(" ")[0]);
        return map;
    }

    private Gift getGiftByGiftId(Integer giftId) {

        Gift query = new Gift();
        query.setGiftId((long) giftId);
        query.setIsValid(true);
        Gift gift = com.xunlei.niux.data.vipgame.facade.FacadeFactory.INSTANCE.getBaseSo().findObject(query);

        return gift;
    }


}
