package com.xunlei.niux.manager.template.builder.jinzuan;

import com.ferret.common.dao.enums.OrderType;
import com.ferret.common.dao.vo.Page;
import com.xunlei.common.util.StringTools;
import com.xunlei.niux.data.vipgame.facade.FacadeFactory;
import com.xunlei.niux.data.vipgame.vo.Advice;
import com.xunlei.niux.data.vipgame.vo.GameServers;
import com.xunlei.niux.data.vipgame.vo.Games;
import com.xunlei.niux.data.vipgame.vo.LinkInfo;
import com.xunlei.niux.manager.constant.LinkLocationIdConstant;
import com.xunlei.niux.manager.web.cache.GameCache;
import com.xunlei.niux.manager.web.util.FreemarkerUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;

/**
 * Created by jamesjxin on 14-3-20.
 */
public class IndexPageBuilder implements Callable {
    private static final Logger logger = Logger.getLogger(IndexPageBuilder.class);

    private static final String ENTERURL = "http://niu.xunlei.com/entergame/";

    private String inputPath;
    private String outputPath;
    private boolean isPreview;

    public IndexPageBuilder(String inputPath, String outputPath, boolean isPreview) {
        this.inputPath = inputPath;
        this.outputPath = outputPath;
        this.isPreview = isPreview;
    }


    @Override
    public Object call() throws Exception {

        Map<String, Object> rootMap = new HashMap<String, Object>();
        rootMap.put("sliderImgList", getSliderImageList()); //首页轮播图列表
        rootMap.put("noticeList", getNoticeList());  //首页公告列表

        rootMap.put("productList", getProductList()); //免费礼包列表
        rootMap.put("lotteryGiftList", getlotteryGiftList()); //抽奖列表

        FreemarkerUtil.buildHtml(inputPath, "index.html", rootMap, outputPath, "index.html");
        return "";

    }

    private List<Map<String, Object>> getSliderImageList() {
        List<Map<String, Object>> templist = new ArrayList<Map<String, Object>>();
        LinkInfo info = new LinkInfo();
        info.setLinklocid(LinkLocationIdConstant.NIUX_JINZUAN_LUNBOPHOTO);
        Page page = new Page();
        page.setPageNo(1);//第一页
        page.setPageSize(6);//只取前6个
        page.addOrder("displayorder", OrderType.DESC);//按照降序排
        page.addOrder("validdatetime", OrderType.DESC);//生效时间
        List<LinkInfo> lilist = FacadeFactory.INSTANCE.getLinkInfoBo().find(info, page);
        if (lilist == null || lilist.size() == 0) return null;
        for (LinkInfo li : lilist) {
            Map<String, Object> map = new HashMap<String, Object>();
            map.put("title", li.getLinktitle());
            map.put("img", li.getPicurl());
            map.put("smallImg", li.getExt1());
            String gameid = li.getGameidbytuijian();
            if (!StringTools.isEmpty(gameid)) {//如果选择了游戏，则取官网地址
                Games games = GameCache.getInstance().getGameByGameId(gameid);
                GameServers servers = new GameServers();
                servers.setGameId(gameid);
                servers.setOpenStatus("1");//已开区
                Page gspage = new Page();
                gspage.setPageNo(1);
                gspage.setPageSize(1);
                gspage.addOrder("openTime", OrderType.DESC);
                List<GameServers> gslist = FacadeFactory.INSTANCE.getGameServersBo().find(servers, gspage);
                if (gslist != null && gslist.size() > 0) {
                    GameServers gs = gslist.get(0);//最新区
                    map.put("url", ENTERURL + games.getGameNo() + "/?fenQuNum=" + gs.getFenQuNum());
                } else {
                    map.put("url", li.getLinkurl());
                }
            } else {
                map.put("url", li.getLinkurl());
            }
            templist.add(map);
        }
        return templist;
    }

    private List<Map<String, Object>> getNoticeList() {
        String sql = "select * from advice where platformno != 'question' and adviceType = '4' order by displayOrder desc limit 0,3";
        List<Advice> list = FacadeFactory.INSTANCE.getAdviceBo().executeQuery(
                Advice.class, sql, new ArrayList());
        List<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        logger.info("getAdviceAdv.size=====================>" + list.size());
        if (list == null || list.size() == 0) return null;
        for (Advice info : list) {
            String gameid = info.getGameId();

            //游戏信息
            logger.info("gameid================>" + gameid);
            Games game = FacadeFactory.INSTANCE.getGamesBo().getGameByGameId(
                    gameid);

            Map<String, Object> map = new HashMap<String, Object>();
            map.put("id", info.getSeqId());
            map.put("gameId", game == null ? "" : game.getGameNo());
            map.put("gameName", game == null ? "" : game.getGameName());
            map.put("title", info.getTitle() == null ? "" : info.getTitle());
            map.put("url", info.getJumpUrl() == null ? "" : info.getJumpUrl());
            map.put("img", info.getExt1() == null ? "" : info.getExt1());
            map.put("content", info.getRemark() == null ? "" : info.getRemark());
            map.put("gameOfficialUrl", game == null ? "" : game.getOfficialWebSite());
            map.put("date", formatTime(info.getPublishDate()));

            map.put("isColor", info.getRed()==false ? 0 : 1);
            map.put("isStrong", info.getBold()==false ? 0 : 1);
            result.add(map);
            if(result.size()>=3){
                break;
            }
        }

        return result;
    }



    private List<Map<String, Object>> getProductList() {
        List<Map<String, Object>> productList = new GiftPackagePageBuilder(inputPath, outputPath, isPreview).getProductList();
        if (CollectionUtils.isEmpty(productList)) {
            return null;
        }

        if (productList.size() > 5) {
            productList = productList.subList(0, 5);
        }
        return productList;
    }

    private List<Map<String, Object>> getlotteryGiftList() {
        LotteryPageBulider lotteryPageBulider = new LotteryPageBulider(inputPath, outputPath, isPreview);
        List<Map<String, Object>> lotteryList = lotteryPageBulider.getRealLotteryGiftByActNo();
        if (CollectionUtils.isEmpty(lotteryList)) {
            return null;
        }

        if (lotteryList.size() > 5) {
            lotteryList = lotteryList.subList(0, 5);
        }
        return lotteryList;
    }

    private String formatTime(String time) {
        if (time == null) return "";
        if (time.length() == 19) {
            time = time.split(" ")[0];
        }
        if (time.length() == 10) {
            time = time.substring(5);
        }
        return time;
    }

}
