package com.xunlei.niux.manager.template.builder.jinzuan;

import com.ferret.common.dao.vo.Page;
import com.xunlei.niux.data.active.dto.commonactivity.ActivityExtendInfoDTO;
import com.xunlei.niux.data.active.dto.commonactivity.ActivityGiftInfoDTO;
import com.xunlei.niux.data.active.vo.commonactivity.ActivityExtendInfo;
import com.xunlei.niux.data.active.vo.commonactivity.ActivityGiftInfo;
import com.xunlei.niux.data.vipgame.vo.Games;
import com.xunlei.niux.data.vipgame.vo.gift.Gift;
import com.xunlei.niux.manager.web.cache.GameCache;
import com.xunlei.niux.manager.web.util.FreemarkerUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.concurrent.Callable;

/**
 * Created with IntelliJ IDEA.
 * User: admin
 * Date: 14-3-10
 * Time: 下午4:51
 * To change this template use File | Settings | File Templates.
 */
public class GiftPackagePageBuilder implements Callable{
    private static final Logger logger = Logger.getLogger(GiftPackagePageBuilder.class);
    private static final String actNo = "JinZuanGiftPackage";
    private static final DateFormat sdf_time = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    private String inputPath;
    private String outputPath;
    private boolean isPreview;
    private Map<String,Map<String,Object>> gameOrderMap;

    public GiftPackagePageBuilder(String inputPath, String outputPath, boolean isPreview) {
        this.inputPath = inputPath;
        this.outputPath = outputPath;
        this.isPreview = isPreview;
        this.gameOrderMap = new HashMap<String,Map<String,Object>>();
    }

    @Override
    public Object call() throws Exception {
        Map<String, Object> rootMap = new HashMap<String, Object>();
        rootMap.put("productList", getProductList());
        rootMap.put("gameOrderList", getGameOrderList());
        rootMap.put("recommendGameList", JinZuanUtil.getRecommendGameList("672"));

        FreemarkerUtil.buildHtml(inputPath, "gift.html", rootMap, outputPath, "gift.html");
        return "";

    }

    public List<Map<String, Object>> getProductList() {

        List<Map<String, Object>> resultList = new ArrayList<Map<String, Object>>();
        Map<String,ActivityExtendInfoDTO> activityMap = getActivityMap(actNo);

        ActivityGiftInfo query = new ActivityGiftInfo();
        query.setActNo(actNo);
        query.setIsValid(true);
        List<ActivityGiftInfoDTO>  actGiftList = com.xunlei.niux.data.active.facade.FacadeFactory.INSTANCE
                .getActivityGiftBo().getActivityGiftList(query);

        if(CollectionUtils.isEmpty(actGiftList)){
            return null;
        }

        for(ActivityGiftInfoDTO activityGiftInfoDTO : actGiftList){
            String moduleId = activityGiftInfoDTO.getModuleId();
            if(StringUtils.isEmpty(moduleId)){
                continue;
            }

            if(!activityMap.containsKey(moduleId)){
                continue;
            }


            ActivityExtendInfoDTO activityDTO = activityMap.get(moduleId);
            if(activityDTO == null){
                continue;
            }

            int giftId = activityGiftInfoDTO.getGiftId();
            Gift gift = getGiftByGiftId(giftId);
            if(gift == null){
                continue;
            }

            Map<String,Object> map = new HashMap<String, Object>();

            map.put("moduleId",moduleId);
            map.put("giftId",giftId);
            map.put("giftType",gift.getGiftType());
            map.put("giftName",gift.getGiftName());
            map.put("price", gift.getProductTotalPrice() == null ? 0 : gift.getProductTotalPrice());
            map.put("photo_list",activityGiftInfoDTO.getPhoto()==null?"":activityGiftInfoDTO.getPhoto());
            map.put("photo_left",activityGiftInfoDTO.getSmallPic()==null?"":activityGiftInfoDTO.getSmallPic());
            map.put("photo_index1",activityGiftInfoDTO.getExt1()==null?"":activityGiftInfoDTO.getExt1());
            map.put("photo_index2",activityGiftInfoDTO.getExt2()==null?"":activityGiftInfoDTO.getExt2());
            map.put("anualJinZuanLimit", activityDTO.getAnualJinZuanLimit());
            map.put("vipLevel",activityDTO.getJinkaLevelLimit());
            map.put("validPeriod",StringUtils.isEmpty(activityDTO.getEndTime())?"":activityDTO.getEndTime());
            map.put("desc",gift.getSimpleDesc());
            map.put("detailUrl",activityGiftInfoDTO.getDetailUrl()==null?"":activityGiftInfoDTO.getDetailUrl());
            String rule = gift.getExt1()==null?"":gift.getExt1();
            rule = rule.replaceAll("\\n","").replaceAll("\\|","<br>");
            map.put("rule",rule);

            String gameId = gift.getGameId();
            Games game = GameCache.getInstance().getGameByGameId(gameId);

            map.put("gameId",game==null?"":game.getGameId());

            if(game!=null && !gameOrderMap.containsKey(game.getGameId())){
                Map<String,Object> orderMap = new HashMap<String, Object>();
                orderMap.put("gameId",game==null?"":game.getGameId());
                orderMap.put("gameNo",game==null?"":game.getGameNo());
                orderMap.put("gameName",game==null?"":game.getGameName());
                orderMap.put("simpleName",game==null?"":game.getSimpleName());
                gameOrderMap.put(game.getGameId(), orderMap);
            } 

            resultList.add(map);
        }

        return resultList;
    }

    private List<Map<String,Object>> getGameOrderList(){
        if(MapUtils.isEmpty(gameOrderMap)){
           return new ArrayList<Map<String, Object>>();
        }
        List<Map<String,Object>> gameOrderList =new ArrayList<Map<String, Object>>(gameOrderMap.values());

        Collections.sort(gameOrderList,new Comparator<Map<String, Object>>() {
            @Override
            public int compare(Map<String, Object> map1, Map<String, Object> map2) {
                return map1.get("simpleName").toString().compareToIgnoreCase(map2.get("simpleName").toString());
            }
        });
        return gameOrderList;
    }



    private Map<String,ActivityExtendInfoDTO> getActivityMap(String actNo){
        Map<String,ActivityExtendInfoDTO> resultMap = new HashMap<String, ActivityExtendInfoDTO>();
        ActivityExtendInfo query = new ActivityExtendInfo();
        query.setActNo(actNo);

        List<ActivityExtendInfoDTO> list = com.xunlei.niux.data.active.facade.FacadeFactory.INSTANCE
                .getActivityExtendBo().getActivityInfoList(actNo);

        if(CollectionUtils.isEmpty(list)){
            return resultMap;
        }

        Date now = new Date();
        for(ActivityExtendInfoDTO activityDTO : list){
            if(StringUtils.isEmpty(activityDTO.getModuleId())){
                continue;
            }
            if(StringUtils.isNotEmpty(activityDTO.getStartTime())){
                try {
                    Date startTime = sdf_time.parse(activityDTO.getStartTime());
                    if(startTime.after(now)){
                        continue;
                    }
                } catch (ParseException e) {
                    logger.error("日期格式转化错误",e);
                }
            }

            if(StringUtils.isNotEmpty(activityDTO.getEndTime())){
                try {
                    Date endTime = sdf_time.parse(activityDTO.getEndTime());
                    if(endTime.before(now)){
                        continue;
                    }
                } catch (ParseException e) {
                    logger.error("日期格式转化错误",e);
                }
            }

            resultMap.put(activityDTO.getModuleId(),activityDTO);
        }
        return resultMap;
    }

    private Gift getGiftByGiftId(int giftId){
        Gift query = new Gift();
        query.setGiftId((long)giftId);
        query.setIsValid(true);

        List<Gift> giftList = com.xunlei.niux.data.vipgame.facade.FacadeFactory.INSTANCE.getBaseSo().findObjects(query, new Page());

        if(CollectionUtils.isEmpty(giftList)){
            return null;
        }
        return giftList.get(0);
    }


}
