package com.xunlei.niux.manager.template.builder.jinzuan;

import com.ferret.common.dao.vo.Page;
import com.xunlei.niux.data.active.bo.iface.ActivityExtendBo;
import com.xunlei.niux.data.active.bo.iface.ActivityGiftBo;
import com.xunlei.niux.data.active.dto.commonactivity.ActivityExtendInfoDTO;
import com.xunlei.niux.data.active.dto.commonactivity.ActivityGiftInfoDTO;
import com.xunlei.niux.data.active.vo.commonactivity.ActivityExtendInfo;
import com.xunlei.niux.data.active.vo.commonactivity.ActivityGiftInfo;
import com.xunlei.niux.data.vipgame.bo.BaseSo;
import com.xunlei.niux.data.vipgame.bo.LinkInfoBo;
import com.xunlei.niux.data.vipgame.vo.Games;
import com.xunlei.niux.data.vipgame.vo.LinkInfo;
import com.xunlei.niux.data.vipgame.vo.gift.Gift;
import com.xunlei.niux.manager.web.cache.GameCache;
import com.xunlei.niux.manager.web.util.FreemarkerUtil;

import java.lang.reflect.InvocationTargetException;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;

import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class GameRewardPageBuilder
        implements Callable
{
    private static final Logger logger = Logger.getLogger(GameRewardPageBuilder.class);
    private static final String actNo = "JiaChengGift";
    private static final DateFormat sdf_time = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private String inputPath;
    private String outputPath;
    private boolean isPreview;
    private Map<String, Map<String, Object>> gameOrderMap;

    public GameRewardPageBuilder(String inputPath, String outputPath, boolean isPreview)
    {
        this.inputPath = inputPath;
        this.outputPath = outputPath;
        this.isPreview = isPreview;
        this.gameOrderMap = new HashMap();
    }

    public Object call() throws Exception
    {
        Map rootMap = new HashMap();
        rootMap.put("gameRewardList", getProductList());
        rootMap.put("gameOrderList", getGameOrderList());
        rootMap.put("recommendGameList", getRecommendGameList());

        FreemarkerUtil.buildHtml(this.inputPath, "gamereward.html", rootMap, this.outputPath, "gamereward.html");
        return "";
    }

    public List<Map<String, Object>> getProductList()
    {
        List resultList = new ArrayList();
        Map activityMap = getActivityMap("JiaChengGift");

        logger.info("actNo:JiaChengGift");
        logger.info("activityMap:" + activityMap);

        ActivityGiftInfo query = new ActivityGiftInfo();
        query.setActNo("JiaChengGift");
        query.setIsValid(Boolean.valueOf(true));
        List<ActivityGiftInfoDTO>  actGiftList = com.xunlei.niux.data.active.facade.FacadeFactory.INSTANCE
                .getActivityGiftBo().getActivityGiftList(query);

        logger.info("actGiftList size :" + actGiftList.size());

        if (CollectionUtils.isEmpty(actGiftList)) {
            return null;
        }

        for (ActivityGiftInfoDTO activityGiftInfoDTO : actGiftList) {
            String moduleId = activityGiftInfoDTO.getModuleId();
            if (StringUtils.isEmpty(moduleId)) {
                logger.info("moduleId null :" + moduleId);
            }
            else if (!activityMap.containsKey(moduleId)) {
                logger.info("not has moduleId :" + moduleId);
            }
            else
            {
                ActivityExtendInfoDTO activityDTO = (ActivityExtendInfoDTO)activityMap.get(moduleId);
                if (activityDTO == null) {
                    logger.info("activityDTO null :" + activityDTO);
                }
                else
                {
                    int giftId = activityGiftInfoDTO.getGiftId().intValue();
                    Gift gift = getGiftByGiftId(giftId);
                    if (gift == null) {
                        logger.info("gift null :" + gift);
                    }
                    else
                    {
                        Map map = new HashMap();

                        map.put("moduleId", moduleId);
                        map.put("giftId", Integer.valueOf(giftId));
                        map.put("giftType", gift.getGiftType());
                        map.put("giftName", gift.getGiftName());
                        map.put("price", Double.valueOf(gift.getProductTotalPrice() == null ? 0.0D : gift.getProductTotalPrice().doubleValue()));
                        map.put("photo_list", activityGiftInfoDTO.getPhoto() == null ? "" : activityGiftInfoDTO.getPhoto());
                        map.put("photo_left", activityGiftInfoDTO.getSmallPic() == null ? "" : activityGiftInfoDTO.getSmallPic());
                        map.put("photo_index1", activityGiftInfoDTO.getExt1() == null ? "" : activityGiftInfoDTO.getExt1());
                        map.put("photo_index2", activityGiftInfoDTO.getExt2() == null ? "" : activityGiftInfoDTO.getExt2());
                        map.put("vipLevel", activityDTO.getJinkaLevelLimit());
                        map.put("validPeriod", StringUtils.isEmpty(activityDTO.getEndTime()) ? "" : activityDTO.getEndTime());
                        map.put("desc", gift.getSimpleDesc());
                        map.put("detailUrl", activityGiftInfoDTO.getDetailUrl() == null ? "" : activityGiftInfoDTO.getDetailUrl());
                        map.put("rule", gift.getExt1() == null ? "" : gift.getExt1());

                        Integer goodId = gift.getGoodId();

                        map.put("id", moduleId);
                        map.put("title", activityDTO.getTitle());
                        map.put("content", gift.getSimpleDesc());
                        map.put("img", activityGiftInfoDTO.getPhoto() == null ? "" : activityGiftInfoDTO.getPhoto());
                        map.put("level", activityDTO.getJinkaLevelLimit());

                        String gameId = gift.getGameId();
                        Games game = GameCache.getInstance().getGameByGameId(gameId);

                        map.put("gameId", game == null ? "" : game.getGameId());

                        if ((game != null) && (!this.gameOrderMap.containsKey(game.getGameId()))) {
                            Map orderMap = new HashMap();
                            orderMap.put("gameId", game == null ? "" : game.getGameId());
                            orderMap.put("gameNo", game == null ? "" : game.getGameNo());
                            orderMap.put("gameName", game == null ? "" : game.getGameName());
                            orderMap.put("simpleName", game == null ? "" : game.getSimpleName());
                            this.gameOrderMap.put(game.getGameId(), orderMap);
                        }

                        resultList.add(map);
                    }
                }
            }
        }
        return resultList;
    }

    private List<Map<String, Object>> getGameOrderList() {
        if (MapUtils.isEmpty(this.gameOrderMap)) {
            return new ArrayList();
        }
        List gameOrderList = new ArrayList(this.gameOrderMap.values());

        Collections.sort(gameOrderList, new Comparator()
        {
            @Override
            public int compare(Object o1, Object o2) {
                Map map1 = null;
                Map map2 = null;
                try {
                    map1 = BeanUtils.describe(o1);
                    map2 = BeanUtils.describe(o2);
                } catch (Exception e) {
                    logger.error("ERROR getGameOrderList",e);
                }
                return map1.get("simpleName").toString().compareToIgnoreCase(map2.get("simpleName").toString());
            }
        });
        return gameOrderList;
    }

    private List<Map<String, Object>> getRecommendGameList() {
        List list = new ArrayList();

        LinkInfo query = new LinkInfo();
        query.setLinklocid("673");
        List<LinkInfo> linkinfoList = com.xunlei.niux.data.vipgame.facade.FacadeFactory.INSTANCE.getLinkInfoBo().find(query);
        if (CollectionUtils.isEmpty(linkinfoList)) {
            return list;
        }

        for (LinkInfo linkInfo : linkinfoList) {
            String gameid = linkInfo.getGameid();
            Games game = GameCache.getInstance().getGameByGameId(gameid);
            if (game != null)
            {
                Map map = new HashMap();
                map.put("gameId", gameid);
                map.put("gameNo", game.getGameNo() == null ? "" : game.getGameNo());
                map.put("gameName", game.getGameName() == null ? "" : game.getGameName());
                map.put("simpleName", game.getSimpleName() == null ? "" : game.getSimpleName());
                list.add(map);
            }
        }
        return list;
    }

    private Map<String, ActivityExtendInfoDTO> getActivityMap(String actNo) {
        Map resultMap = new HashMap();
        ActivityExtendInfo query = new ActivityExtendInfo();
        query.setActNo(actNo);

        List<ActivityExtendInfoDTO> list = com.xunlei.niux.data.active.facade.FacadeFactory.INSTANCE
                .getActivityExtendBo().getActivityInfoList(actNo);

        if (CollectionUtils.isEmpty(list)) {
            logger.info("getActivityMap.list is empty.list:" + list);
            return resultMap;
        }

        Date now = new Date();
        for (ActivityExtendInfoDTO activityDTO : list) {
            if (StringUtils.isEmpty(activityDTO.getModuleId())) {
                logger.info("getActivityMap.ModuleId isEmpty.ModuleId:" + activityDTO.getModuleId());
            }
            else if (StringUtils.isNotEmpty(activityDTO.getStartTime())) {
                try {
                    Date startTime = sdf_time.parse(activityDTO.getStartTime());
                    if (startTime.after(now))
                        logger.info("getActivityMap startTime.after(now).start:" + startTime + ",now:" + now);
                }
                catch (ParseException e)
                {
                    logger.error("getActivityMap日期格式转化错误", e);
                }

            }
            else if (StringUtils.isNotEmpty(activityDTO.getEndTime())) {
                try {
                    Date endTime = sdf_time.parse(activityDTO.getEndTime());
                    if (endTime.before(now))
                        logger.info("getActivityMap endTime.before(now).start:" + endTime + ",now:" + now);
                }
                catch (ParseException e)
                {
                    logger.error("getActivityMap日期格式转化错误", e);
                }
            }
            else
                resultMap.put(activityDTO.getModuleId(), activityDTO);
        }
        return resultMap;
    }

    private Gift getGiftByGiftId(int giftId) {
        Gift query = new Gift();
        query.setGiftId(Long.valueOf(giftId));
        query.setIsValid(Boolean.valueOf(true));

        List giftList = com.xunlei.niux.data.vipgame.facade.FacadeFactory.INSTANCE.getBaseSo().findObjects(query, new Page());

        if (CollectionUtils.isEmpty(giftList)) {
            return null;
        }
        return (Gift)giftList.get(0);
    }
}