package com.xunlei.niux.manager.template.builder.jinzuan;

import com.xunlei.niux.data.vipgame.facade.FacadeFactory;
import com.xunlei.niux.data.vipgame.vo.LinkInfo;
import com.xunlei.niux.manager.constant.LinkLocationIdConstant;
import com.xunlei.niux.manager.template.builder.AbstractTemplateBuilder;
import com.xunlei.niux.manager.web.util.DateUtil;
import com.xunlei.niux.manager.web.util.FreemarkerUtil;
import org.apache.log4j.Logger;

import java.text.SimpleDateFormat;
import java.util.*;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;

/**
 * Created with IntelliJ IDEA.
 * User: admin
 * Date: 14-3-10
 * Time: 下午4:53
 * To change this template use File | Settings | File Templates.
 */
public class ActivityPageBuilder implements Callable{
    private static final Logger logger = Logger.getLogger(ActivityPageBuilder.class);
    private String inputPath;
    private String outputPath;
    private boolean isPreview;

    public ActivityPageBuilder(String inputPath, String outputPath, boolean isPreview) {
        this.inputPath = inputPath;
        this.outputPath = outputPath;
        this.isPreview = isPreview;
    }

    @Override
    public Object call() throws Exception {
        Map<String, Object> rootMap = new HashMap<String, Object>();
        rootMap.put("activityList", getActing(isPreview));

        FreemarkerUtil.buildHtml(inputPath, "activity.html", rootMap, outputPath, "activity.html");
        return "";
    }

    /**
     * 获得活动页中正在进行的活动
     * @return
     */
    private List<Map<String,Object>> getActing(boolean isPreView){
        List<Map<String,Object>> result = new ArrayList<Map<String,Object>>();
        List<LinkInfo> lilist= FacadeFactory.INSTANCE.getLinkInfoBo().getValidteLinkInfoListByLinkLocId(LinkLocationIdConstant.NIUX_JINZUAN_ACTIVITY, 100, isPreView);
        if(lilist == null||lilist.size()==0)return null;
        for(LinkInfo info:lilist){
            Map<String,Object> map = new HashMap<String,Object>();
            map.put("title", info.getLinktitle());
            map.put("content", info.getLinkdesc());
            map.put("url", info.getLinkurl());
            map.put("img", info.getPicurl());
            map.put("date", info.getInvaliddatetime());
            Date currentTime = new Date();
            SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            String dateString = formatter.format(currentTime);
            int status = DateUtil.timeCompare(info.getInvaliddatetime(), dateString);
            map.put("status", status);
            map.put("level", info.getExt1());
            result.add(map);
        }
        return result;
    }
}
