package com.xunlei.niux.manager.template.builder.guest;


import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import com.ferret.common.dao.enums.OrderType;
import com.ferret.common.dao.vo.Page;
import com.xunlei.common.facade.IFacadeCommon;
import com.xunlei.httptool.util.JsonObjectUtil;
import com.xunlei.niux.data.vipgame.facade.FacadeFactory;
import com.xunlei.niux.data.vipgame.vo.WholePeopleGuest;
import com.xunlei.niux.manager.template.builder.AbstractTemplateBuilder;
import com.xunlei.niux.manager.web.util.FileUtil;


/**
 * 世界杯赛程模版生成工具
 * @author lisu
 * 2013-06-28
 */
public class GuestBuilder extends AbstractTemplateBuilder {
	private boolean ispreview = false;//是否预览
    private static final SimpleDateFormat daysdf=new SimpleDateFormat("yyyy-MM-dd");
    private static  String wholePeopleGuestPath=IFacadeCommon.INSTANCE.getLibconfigValueByConfigNo("wholePeopleGuestPath");	
    private static  String SYNCPICCOMMOND=IFacadeCommon.INSTANCE.getLibconfigValueByConfigNo("wholePeopleGuestCmd");	 
    private String templateRoot;
    private String htmlFilePath;


		public static void main(String args[]) {
			try {
				new GuestBuilder().executeShcema();
			} catch (Exception e) {
				e.printStackTrace();
			}
		}

	 
	 @Override
	 public void executeShcema() throws Exception {
         templateRoot = htmlTemplate.getTemplateroot();
         htmlFilePath=isPreView?htmlTemplate.getPreviewhtmlroot():htmlTemplate.getHtmlroot();
         if(htmlFilePath.endsWith("/")){
             htmlFilePath=htmlFilePath.substring(0, htmlFilePath.length()-1);
         }
		 makeIndex();//生成会员特权首页		
	}
	
	private void makeIndex() throws Exception{
		makeFile();
	}
	 
	
	public void makeFile() {
		try{
			Calendar cal = Calendar.getInstance();			
			String nowDay = daysdf.format(cal.getTime());
			WholePeopleGuest query = new WholePeopleGuest();
			Page page = new Page();
			page.addOrder("dayTime", OrderType.DESC);
			page.addOrder("showId", OrderType.ESC);
			List<WholePeopleGuest> emList = FacadeFactory.INSTANCE.getBaseSo().findObjects(query,page);	
			Map<String,Object> map=new HashMap<String,Object>();
			List<WholePeopleGuest> nowList = new ArrayList<WholePeopleGuest>();
			for(WholePeopleGuest wpg:emList){
				if(wpg.getDayTime().equals(nowDay)){
					nowList.add(wpg);
				}
			}
			List<WholePeopleGuest> beforeList = new ArrayList<WholePeopleGuest>();
			for(WholePeopleGuest wpg:emList){
				if(!wpg.getDayTime().equals(nowDay)){
					beforeList.add(wpg);
				}
			}
			 map.put("beforeList", beforeList);
			 map.put("nowList", nowList);
			 String jsonStr=JsonObjectUtil.getDataJsonObject(map);
			 File file = FileUtil.createFile(wholePeopleGuestPath,"shijibei.json");
			 FileUtil.writeByChar(file, jsonStr);
			 
			 if(nowList != null){
				 nowList.clear();
				 nowList = null;
			 }
			 if(beforeList != null){
				 beforeList.clear();
				 beforeList = null;
			 }
			 if(emList != null){
				 emList.clear();
				 emList = null;
			 }
			 //同步文件到外网
			 sync();
			 
			 
		}catch(Exception e){
			e.printStackTrace();			
		}		
	}
	
	
	 public void sync(){
		 try {
			 Runtime.getRuntime().exec("/usr/local/bin/"+SYNCPICCOMMOND);			
		} catch (IOException e) {
			e.printStackTrace();
		}
	 }
	 
}
