package com.xunlei.niux.manager.template.builder.giftcenter;

import com.xunlei.common.util.XLRuntimeException;
import com.xunlei.niux.data.giftcenter.facade.FacadeFactory;
import com.xunlei.niux.data.giftcenter.vo.PackageMobilegameGift;
import com.xunlei.niux.data.giftcenter.vo.PackageWebgameGift;
import com.xunlei.niux.manager.template.builder.AbstractTemplateBuilder;
import com.xunlei.niux.manager.web.util.FreemarkerUtil;
import org.apache.log4j.Logger;

import java.util.*;

public class IndexPageBuilder extends AbstractTemplateBuilder {
    private static final Logger logger = Logger.getLogger(IndexPageBuilder.class);
    @Override
    public void executeShcema() throws Exception {
        String rootPath = htmlTemplate.getTemplateroot();
        if(!rootPath.endsWith("/")){
            rootPath += "/";
        }

        String htmlPath = htmlTemplate.getHtmlroot();
        if(htmlPath.endsWith("/")){
            htmlPath += "/";
        }

//        rootPath="D:\\tmp\\giftcenter";
//        htmlPath="D:\\tmp\\giftcenter";

        Map<String,Object> rootMap = new HashMap<String, Object>();
        rootMap.put("topGift",getTopGift());
        rootMap.put("topGiftOpenServer",getTopGiftOpenServer());
        rootMap.put("topGiftOthers",getTopGiftOthers());
        rootMap.put("webTimeGift",getWebTimeGift());
//        rootMap.put("webHotGift",getWebHotGift());
//        rootMap.put("mobileGift",getMobileGift());
//        rootMap.put("webOpen",getWebOpen());
//        rootMap.put("webTest",getWebTest());
//        rootMap.put("mobileTest",getMobileTest());
//        rootMap.put("searchGift",getSearchGift());
//        rootMap.put("rankingListWebGift",getRankingListWebGift());
//        rootMap.put("rankingListMobileGift",getRankingListMobileGift());
        rootMap.put("bookingGift",getBookingGift());
        System.out.println("######################" + rootMap);
        FreemarkerUtil.buildHtml(rootPath, "index.html", rootMap, htmlPath, "index.html");

        Map<String,Object> hotWebGift = new HashMap<String, Object>();
        hotWebGift.put("webHotGift",getWebHotGift());
        FreemarkerUtil.buildHtml(rootPath,"include/hot_web_gift.html",hotWebGift,htmlPath,"include/hot_web_gift.html");

        Map<String,Object> mobileGift = new HashMap<String, Object>();
        mobileGift.put("mobileGift",getMobileGift());
        FreemarkerUtil.buildHtml(rootPath,"include/hot_wap_gift.html",mobileGift,htmlPath,"include/hot_wap_gift.html");

        Map<String,Object> webOpen = new HashMap<String, Object>();
        webOpen.put("webOpen",getWebOpen());
        FreemarkerUtil.buildHtml(rootPath,"include/open_web_game.html",webOpen,htmlPath,"include/open_web_game.html");

        Map<String,Object> mobileTest = new HashMap<String, Object>();
        mobileTest.put("mobileTest",getMobileTest());
        FreemarkerUtil.buildHtml(rootPath,"include/test_wap_game.html",mobileTest,htmlPath,"include/test_wap_game.html");

        Map<String,Object> webTest = new HashMap<String, Object>();
        webTest.put("webTest",getWebTest());
        FreemarkerUtil.buildHtml(rootPath,"include/test_web_game.html",webTest,htmlPath,"include/test_web_game.html");

        Map<String,Object> rankingListWebGift = new HashMap<String, Object>();
        rankingListWebGift.put("rankingListWebGift",getRankingListWebGift());
        FreemarkerUtil.buildHtml(rootPath,"include/web_gift_rank.html",webTest,htmlPath,"include/web_gift_rank.html");

        Map<String,Object> rankingListMobileGift = new HashMap<String, Object>();
        rankingListMobileGift.put("rankingListMobileGift",getRankingListMobileGift());
        FreemarkerUtil.buildHtml(rootPath,"include/wap_gift_rank.html",webTest,htmlPath,"include/wap_gift_rank.html");


        Map<String,Object> rootMap1 = new HashMap<String, Object>();
        rootMap1.put("searchGift",getSearchGift());
        FreemarkerUtil.buildHtml(rootPath+"include", "search_recommend.html", rootMap1, htmlPath+"include", "search_recommend.html");

    }


    private Map<String,Object> getTopGift(){
        return FacadeFactory.INSTANCE.getIndexPageBo().getTopGift();
    }

    private List<Map<String, Object>> getTopGiftOpenServer(){
        return FacadeFactory.INSTANCE.getIndexPageBo().getTopGiftOpenServer();
    }

    private List<Map<String, Object>> getTopGiftOthers(){
        return FacadeFactory.INSTANCE.getIndexPageBo().getTopGiftOthers();
    }

    private List<Map<String, Object>> getWebTimeGift(){
        return FacadeFactory.INSTANCE.getIndexPageBo().getWebTimeGift();
    }

    private List<Map<String, Object>> getWebHotGift(){
        return FacadeFactory.INSTANCE.getIndexPageBo().getWebHotGift();
    }

    private List<Map<String, Object>> getMobileGift(){
        return FacadeFactory.INSTANCE.getIndexPageBo().getMobileGift();
    }

    private List<Map<String, Object>> getWebOpen(){
        return FacadeFactory.INSTANCE.getIndexPageBo().getWebOpen();
    }

    private List<Map<String, Object>> getWebTest(){
        return FacadeFactory.INSTANCE.getIndexPageBo().getWebTest();
    }


    private List<Map<String, Object>> getMobileTest(){
        return FacadeFactory.INSTANCE.getIndexPageBo().getMobileTest();
    }

    private List<Map<String, Object>> getSearchGift(){
        return FacadeFactory.INSTANCE.getIndexPageBo().getSearchGift();
    }
    private List<Map<String, Object>> getRankingListWebGift(){
        return FacadeFactory.INSTANCE.getIndexPageBo().getRankingListWebGift();
    }
    private List<Map<String, Object>> getRankingListMobileGift(){
        return FacadeFactory.INSTANCE.getIndexPageBo().getRankingListMobileGift();
    }
    private Map<String, Object> getBookingGift(){
        return FacadeFactory.INSTANCE.getIndexPageBo().getBookingGift();
    }

    private void putPackageWebgameGift(Long packageId,Map<String, Object> map) throws XLRuntimeException{
        PackageWebgameGift pkg = FacadeFactory.INSTANCE.getBaseSo().findById(PackageWebgameGift.class,packageId);
        if(pkg==null)
            throw new XLRuntimeException("无对应页游礼包id="+packageId);
        map.put("gameId",pkg.getGameId());
        map.put("platformId",pkg.getPlatformId());
        map.put("packageName",pkg.getPackageName());
        map.put("packageContent",pkg.getPackageContent());
        map.put("activationTips",pkg.getActivationTips());
        map.put("gameUrl",pkg.getGameUrl());
        map.put("packageStatus",pkg.getPackageStatus());
        map.put("startTime",pkg.getStartTime());
        map.put("endTime",pkg.getEndTime());
        map.put("needPhone",pkg.getNeedPhone());
        map.put("needXLVip",pkg.getNeedXLVip());
    }
    private void putPackageMobilegameGift(Long packageId,Map<String, Object> map) throws XLRuntimeException{
        PackageMobilegameGift pkg = FacadeFactory.INSTANCE.getBaseSo().findById(PackageMobilegameGift.class,packageId);
        if(pkg==null)
            throw new XLRuntimeException("无对应手游礼包id="+packageId);
        map.put("gameId",pkg.getGameId());
        map.put("platformId",pkg.getPlatformId());
        map.put("packageName",pkg.getPackageName());
        map.put("packageContent",pkg.getPackageContent());
        map.put("activationTips",pkg.getActivationTips());
        map.put("iosUrl",pkg.getIosUrl());
        map.put("androidUrl",pkg.getAndroidUrl());
        map.put("packageStatus",pkg.getPackageStatus());
        map.put("startTime",pkg.getStartTime());
        map.put("endTime",pkg.getEndTime());
        map.put("needPhone",pkg.getNeedPhone());
        map.put("needXLVip",pkg.getNeedXLVip());
    }

}
