package com.xunlei.niux.manager.template.builder.gameopenserver;

import com.ferret.common.dao.enums.OrderType;
import com.ferret.common.dao.vo.Page;
import com.xunlei.common.vo.LibClassD;
import com.xunlei.common.vo.LibClassM;
import com.xunlei.niux.data.vipgame.dto.OpenServerBean;
import com.xunlei.niux.data.vipgame.facade.FacadeFactory;
import com.xunlei.niux.data.vipgame.vo.Games;
import com.xunlei.niux.data.vipgame.vo.SeoGame;
import com.xunlei.niux.manager.template.builder.AbstractTemplateBuilder;
import com.xunlei.niux.manager.web.cache.GameCache;
import com.xunlei.niux.manager.web.util.FreemarkerUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.*;

/**
 * Created by jamesjxin on 14-1-16.
 */
public class GameServiceListBuilder extends AbstractTemplateBuilder {
    private static DateFormat sdf_time = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private static final int PAGESIZE = 100;   //SEO标题页每页最多的标题数
    private static final Logger logger = Logger.getLogger(GameServiceListBuilder.class);
//    private static final String FILEPATH = IFacadeCommon.INSTANCE.getLibconfigValueByConfigNo("advicePhotoPath");//
//    private static final String REMOREFILEPATH = IFacadeCommon.INSTANCE.getLibconfigValueByConfigNo("remoteAdvicePicPath");
//    private static final String KANKANURL = IFacadeCommon.INSTANCE.getLibconfigValueByConfigNo("kankanurl");

    private String tempPath;
    private String htmlFilePath;
    private int todayOpenServerNum = 0;
    private String msg;

    public static void main(String[] args){
        try {
//            new GameServiceListBuilder().executeShcema();
            String a = "http://?adv=b";
            a = a.substring(0,a.indexOf("?"));
            System.out.println(a);
        }catch (Exception e){

        }
    }

    @Override
    public void executeShcema() throws Exception {
        tempPath = htmlTemplate.getTemplateroot();
        htmlFilePath = isPreView ? htmlTemplate.getPreviewhtmlroot() : htmlTemplate.getHtmlroot();
        if(!htmlFilePath.endsWith("/")) {
            htmlFilePath = htmlFilePath + "/";
        }
//        tempPath = "/data/";
//        htmlFilePath = "/data/output/";

        makeServerListPages();
    }

    private void makeServerListPages(){
        /**
         * 1.获取最新100个开服数据
         * 2.10个一组填充html
         * 3.传到看看服务器
         */

        Map<String,Object> rootMap = new HashMap<String, Object>();
        List<Map<String,Object>> recomGameList = getRecomGameList();
        rootMap.put("recomGameList",recomGameList);


        List<Map<String,Object>> openServerBeanList = getValidOpenServerList();
        if(CollectionUtils.isEmpty(openServerBeanList)){
            msg = "没有有效的开服表数据(查看开服表信息和SEO推荐游戏是否维护完整)！";
            logger.error(msg);
            throw new RuntimeException(msg);
        }
        rootMap.put("otherInfo",getOtherInfo());

        int pageCount = 0;
        int size = openServerBeanList.size();
        if(size%PAGESIZE==0){
            pageCount = size/PAGESIZE;
        }else {
            pageCount = size/PAGESIZE + 1;
        }

        Map<String,Object> pageMap = new HashMap<String,Object>();
        pageMap.put("total",pageCount);
        rootMap.put("pageMap",pageMap);

        List<Map<String,Object>> curServerList = null;
        for(int pageIndex = 1; pageIndex <= pageCount; pageIndex++){
            curServerList = openServerBeanList.subList((pageIndex-1)*PAGESIZE,pageIndex*PAGESIZE<=size?pageIndex*PAGESIZE:size);
            rootMap.put("serverList",curServerList);
            pageMap.put("cur",pageIndex);

            changeListEnterUrlAdvNo(recomGameList,"201309100675345574");
            changeListEnterUrlAdvNo(curServerList,"201309100675345574");

            FreemarkerUtil.buildHtml(tempPath,
                    "list.html", rootMap, htmlFilePath + "kankan/niu",
                    pageIndex>1?"list_"+ pageIndex +".html":"list.html");

            changeListEnterUrlAdvNo(recomGameList,"201407286372645048");
            changeListEnterUrlAdvNo(curServerList,"201407286372645048");

            FreemarkerUtil.buildHtml(tempPath,
                    "list.html", rootMap, htmlFilePath + "niuofficial/niu",
                    pageIndex>1?"list_"+ pageIndex +".html":"list.html");

        }

    }

    private void changeListEnterUrlAdvNo(List<Map<String,Object>> list,String advNo){
        if(CollectionUtils.isEmpty(list)){
            return;
        }

        for(Map<String,Object> map : list){
            String enterGameUrl = map.get("enterGameUrl").toString();
            if(StringUtils.isEmpty(enterGameUrl)){
                continue;
            }

            if(enterGameUrl.indexOf("?")>0){
                enterGameUrl = enterGameUrl.substring(0,enterGameUrl.indexOf("?"));
            }

            enterGameUrl += "?advNo="+advNo;
            map.put("enterGameUrl",enterGameUrl);

        }
    }

    private List<Map<String,Object>> getRecomGameList(){
        List<Map<String,Object>> recomGameList = new ArrayList<Map<String, Object>>();

        Page page = new Page();
        page.addOrder("displayOrder", OrderType.DESC);
        page.setPageNo(1);
        page.setPageSize(10);
        List<SeoGame> seoGameList = FacadeFactory.INSTANCE.getBaseSo().findObjects(new SeoGame(),page);
        if(CollectionUtils.isEmpty(seoGameList)){
            return recomGameList;
        }

        for(SeoGame seoGame : seoGameList){
            Games game =  getGameByGameId(seoGame.getGameId());
            if(game == null){
                continue;
            }
            Map<String,Object> map = new HashMap<String, Object>();
            map.put("img",seoGame.getPhoto()==null?"":seoGame.getPhoto());
            map.put("gameName",game.getGameName()==null?"":game.getGameName());
            map.put("enterGameUrl",seoGame.getEnterGameUrl()==null?"":seoGame.getEnterGameUrl());
            recomGameList.add(map);
        }

        return recomGameList;
    }

    private Map<String,Object> getOtherInfo(){
        Map<String,Object> map = new HashMap<String,Object>();
        map.put("todayServerNum",todayOpenServerNum);
        return map;
    }

    private Games getGameByGameId(String gameId){
        if(StringUtils.isEmpty(gameId)){
            return null;
        }

        Games query = new Games();
        query.setGameId(gameId);

        Games game = FacadeFactory.INSTANCE.getBaseSo().findObject(query);

        return game;
    }

    private List<Map<String,Object>> getValidOpenServerList(){
        List<Map<String,Object>> resultList = new ArrayList<Map<String, Object>>();
        Date now = new Date();
        String todayEndStr = sdf_time.format(now).substring(0,10)+" 23:59:59";
        List<OpenServerBean> openServerList = FacadeFactory.INSTANCE.getOpenServerBo().getAllOpenServerList(todayEndStr);
//        List<OpenServerBean> openServerList = FacadeFactory.INSTANCE.getOpenServerBo().getAllOpenServerList("");

        if(CollectionUtils.isEmpty(openServerList)){
            return resultList;
        }

        for(OpenServerBean serverBean : openServerList){
            String openTime = serverBean.getOpenTime();
            if(StringUtils.isEmpty(openTime)){
                continue;
            }
            try{

                String todayStartStr = sdf_time.format(now).substring(0,10)+" 00:00:00";
                Date todayStart = sdf_time.parse(todayStartStr);
                Date serverOpenTime = sdf_time.parse(openTime);

                if(serverOpenTime.after(todayStart)){
                    todayOpenServerNum++;
                    if(serverOpenTime.before(now)){
                        serverBean.setStatus(2);
                    }else {
                        serverBean.setStatus(1);
                    }
                }else {
                    serverBean.setStatus(3);
                }

                resultList.add(generateMap(serverBean));

            }catch (Exception e){
                logger.error(serverBean.toString()+"的开服日期转换错误！");
                continue;
            }
        }

        return resultList;
    }

    public Map<String,Object> generateMap(OpenServerBean serverBean){
        Map<String,Object> map = new HashMap<String, Object>();
        if(serverBean == null){
            return map;
        }
        map.put("gameName",serverBean.getGameName()==null?"":serverBean.getGameName());
        map.put("gameType",getGameCategoryList(serverBean.getGameId()));
        map.put("openServerDateTime",serverBean.getOpenTime()==null?"":serverBean.getOpenTime());
        map.put("serverName",serverBean.getServerName()==null?"":serverBean.getServerName());
        map.put("status",serverBean.getStatus());
        map.put("enterGameUrl",serverBean.getEnterGameUrl());
        return map;
    }


    /**
     * 查询某游戏的游戏类型
     * @param gameid
     * @return
     */
    public String getGameCategoryList(String gameid) {
        Games games = GameCache.getInstance().getGameByGameId(gameid);
        List datas = LibClassM.getLibClassDList("gamecategory");
        String gameType = games.getGameType();
        for (int i = 0; i < datas.size(); i++) {
            String typeid = ((LibClassD) datas.get(i)).getItemno().trim();
            if(typeid.trim().equals(gameType.trim())){
                return  ((LibClassD) datas.get(i)).getItemname();
            }
        }
        return "";
    }


}
