package com.xunlei.niux.manager.template.builder.gameofficial.thread;

import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class ThreadPoolGame {
		private static final ThreadPoolGame instance = new ThreadPoolGame();
		ThreadPoolExecutor executor ;
		private ThreadPoolGame(){
			init();
		}
		
		private void init(){
			executor = new ThreadPoolExecutor(2,5,20,TimeUnit.SECONDS,
					new ArrayBlockingQueue<Runnable>(100),
					new ThreadPoolExecutor.AbortPolicy());
			Runtime.getRuntime().addShutdownHook(new Thread(){
				public void run(){
					shutDown();
				}
			});
		}
		
		private void shutDown(){
			executor.shutdown();
		}
		
		public static ThreadPoolGame getInstance(){
			return instance;
		}
		
		public  void execute(Runnable task){
			executor.execute(task);
		}
}
